/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.entity.TermValueSetConcept;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ITermValueSetConceptDao
extends JpaRepository<TermValueSetConcept, Long>,
IHapiFhirJpaRepository {
    @Query(value="SELECT COUNT(*) FROM TermValueSetConcept vsc WHERE vsc.myValueSetPid = :pid")
    public Integer countByTermValueSetId(@Param(value="pid") Long var1);

    @Query(value="DELETE FROM TermValueSetConcept vsc WHERE vsc.myValueSetPid = :pid")
    @Modifying
    public void deleteByTermValueSetId(@Param(value="pid") Long var1);

    @Query(value="SELECT vsc FROM TermValueSetConcept vsc WHERE vsc.myValueSetPid = :pid AND vsc.mySystem = :system_url")
    public List<TermValueSetConcept> findByTermValueSetIdSystemOnly(Pageable var1, @Param(value="pid") Long var2, @Param(value="system_url") String var3);

    @Query(value="SELECT vsc FROM TermValueSetConcept vsc WHERE vsc.myValueSetPid = :pid AND vsc.mySystem = :system_url AND vsc.myCode = :codeval")
    public Optional<TermValueSetConcept> findByTermValueSetIdSystemAndCode(@Param(value="pid") Long var1, @Param(value="system_url") String var2, @Param(value="codeval") String var3);

    @Query(value="SELECT vsc FROM TermValueSetConcept vsc WHERE vsc.myValueSetPid = :pid AND vsc.mySystem = :system_url AND vsc.mySystemVer = :system_version AND vsc.myCode = :codeval")
    public Optional<TermValueSetConcept> findByTermValueSetIdSystemAndCodeWithVersion(@Param(value="pid") Long var1, @Param(value="system_url") String var2, @Param(value="system_version") String var3, @Param(value="codeval") String var4);

    @Query(value="SELECT vsc FROM TermValueSetConcept vsc WHERE vsc.myValueSet.myResourcePid = :resource_pid AND vsc.myCode = :codeval")
    public List<TermValueSetConcept> findByValueSetResourcePidAndCode(@Param(value="resource_pid") Long var1, @Param(value="codeval") String var2);

    @Query(value="SELECT vsc FROM TermValueSetConcept vsc WHERE vsc.myValueSet.myResourcePid = :resource_pid AND vsc.mySystem = :system_url AND vsc.myCode = :codeval")
    public Optional<TermValueSetConcept> findByValueSetResourcePidSystemAndCode(@Param(value="resource_pid") Long var1, @Param(value="system_url") String var2, @Param(value="codeval") String var3);

    @Query(value="SELECT vsc FROM TermValueSetConcept vsc WHERE vsc.myValueSet.myResourcePid = :resource_pid AND vsc.mySystem = :system_url AND vsc.mySystemVer = :system_version AND vsc.myCode = :codeval")
    public Optional<TermValueSetConcept> findByValueSetResourcePidSystemAndCodeWithVersion(@Param(value="resource_pid") Long var1, @Param(value="system_url") String var2, @Param(value="system_version") String var3, @Param(value="codeval") String var4);

    @Query(value="SELECT vsc.myId FROM TermValueSetConcept vsc WHERE vsc.myValueSetPid = :pid ORDER BY vsc.myId")
    public List<Long> findIdsByTermValueSetId(@Param(value="pid") Long var1);

    @Query(value="UPDATE TermValueSetConcept vsc SET vsc.myOrder = :order WHERE vsc.myId = :pid")
    @Modifying
    public void updateOrderById(@Param(value="pid") Long var1, @Param(value="order") int var2);
}

