/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.entity.TermValueSet;
import ca.uhn.fhir.jpa.entity.TermValueSetPreExpansionStatusEnum;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ITermValueSetDao
extends JpaRepository<TermValueSet, Long>,
IHapiFhirJpaRepository {
    @Query(value="SELECT vs FROM TermValueSet vs WHERE vs.myResourcePid = :resource_pid")
    public Optional<TermValueSet> findByResourcePid(@Param(value="resource_pid") Long var1);

    @Deprecated
    @Query(value="SELECT vs FROM TermValueSet vs WHERE vs.myUrl = :url")
    public Optional<TermValueSet> findByUrl(@Param(value="url") String var1);

    @Query(value="SELECT vs FROM TermValueSet vs WHERE vs.myExpansionStatus = :expansion_status")
    public Slice<TermValueSet> findByExpansionStatus(Pageable var1, @Param(value="expansion_status") TermValueSetPreExpansionStatusEnum var2);

    @Query(value="SELECT vs FROM TermValueSet vs INNER JOIN ResourceTable r ON r.myId = vs.myResourcePid WHERE vs.myUrl = :url ORDER BY r.myUpdated DESC")
    public List<TermValueSet> findTermValueSetByUrl(Pageable var1, @Param(value="url") String var2);

    @Query(value="SELECT vs FROM ForcedId f, TermValueSet vs where f.myForcedId = :forcedId and vs.myResource = f.myResource")
    public Optional<TermValueSet> findTermValueSetByForcedId(@Param(value="forcedId") String var1);

    @Query(value="SELECT vs FROM TermValueSet vs WHERE vs.myUrl = :url AND vs.myVersion IS NULL")
    public Optional<TermValueSet> findTermValueSetByUrlAndNullVersion(@Param(value="url") String var1);

    @Query(value="SELECT vs FROM TermValueSet vs WHERE vs.myUrl = :url AND vs.myVersion = :version")
    public Optional<TermValueSet> findTermValueSetByUrlAndVersion(@Param(value="url") String var1, @Param(value="version") String var2);
}

