/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.expunge;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.expunge.IExpungeEverythingService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.entity.Batch2JobInstanceEntity;
import ca.uhn.fhir.jpa.entity.Batch2WorkChunkEntity;
import ca.uhn.fhir.jpa.entity.BulkImportJobEntity;
import ca.uhn.fhir.jpa.entity.BulkImportJobFileEntity;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.jpa.entity.PartitionEntity;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchInclude;
import ca.uhn.fhir.jpa.entity.SearchResult;
import ca.uhn.fhir.jpa.entity.SubscriptionTable;
import ca.uhn.fhir.jpa.entity.TermCodeSystem;
import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptDesignation;
import ca.uhn.fhir.jpa.entity.TermConceptMap;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroup;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElement;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElementTarget;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.entity.TermValueSet;
import ca.uhn.fhir.jpa.entity.TermValueSetConcept;
import ca.uhn.fhir.jpa.entity.TermValueSetConceptDesignation;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.NpmPackageEntity;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionEntity;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryProvenanceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTag;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantityNormalized;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceSearchUrlEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresentEntity;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.StopWatch;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;

@Service
public class ExpungeEverythingService
implements IExpungeEverythingService {
    private static final Logger ourLog = LoggerFactory.getLogger(ExpungeEverythingService.class);
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private HapiTransactionService myTxService;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    private int deletedResourceEntityCount;

    public void expungeEverything(@Nullable RequestDetails theRequest) {
        AtomicInteger counter = new AtomicInteger();
        HookParams hooks = new HookParams().add(AtomicInteger.class, (Object)counter).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRESTORAGE_EXPUNGE_EVERYTHING, (HookParams)hooks);
        ourLog.info("BEGINNING GLOBAL $expunge");
        Propagation propagation = Propagation.REQUIRES_NEW;
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forOperation(null, null, (String)"$expunge");
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequest(theRequest, details);
        this.myTxService.withRequest(theRequest).withPropagation(propagation).withRequestPartitionId(requestPartitionId).execute(() -> counter.addAndGet(this.doExpungeEverythingQuery("UPDATE " + TermCodeSystem.class.getSimpleName() + " d SET d.myCurrentVersion = null")));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, Batch2WorkChunkEntity.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, Batch2JobInstanceEntity.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, NpmPackageVersionResourceEntity.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, NpmPackageVersionEntity.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, NpmPackageEntity.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, SearchParamPresentEntity.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, BulkImportJobFileEntity.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, BulkImportJobEntity.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ForcedId.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceIndexedSearchParamDate.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceIndexedSearchParamNumber.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceIndexedSearchParamQuantity.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceIndexedSearchParamQuantityNormalized.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceIndexedSearchParamString.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceIndexedSearchParamToken.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceIndexedSearchParamUri.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceIndexedSearchParamCoords.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceIndexedComboStringUnique.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceIndexedComboTokenNonUnique.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceLink.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, SearchResult.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, SearchInclude.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermValueSetConceptDesignation.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermValueSetConcept.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermValueSet.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermConceptParentChildLink.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermConceptMapGroupElementTarget.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermConceptMapGroupElement.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermConceptMapGroup.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermConceptMap.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermConceptProperty.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermConceptDesignation.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermConcept.class, requestPartitionId));
        this.myTxService.withRequest(theRequest).withPropagation(propagation).withRequestPartitionId(requestPartitionId).execute(() -> {
            for (TermCodeSystem next : this.myEntityManager.createQuery("SELECT c FROM " + TermCodeSystem.class.getName() + " c", TermCodeSystem.class).getResultList()) {
                next.setCurrentVersion(null);
                this.myEntityManager.merge((Object)next);
            }
        });
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermCodeSystemVersion.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TermCodeSystem.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, SubscriptionTable.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceHistoryTag.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceTag.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, TagDefinition.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceHistoryProvenanceEntity.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceHistoryTable.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceSearchUrlEntity.class, requestPartitionId));
        int counterBefore = counter.get();
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, ResourceTable.class, requestPartitionId));
        counter.addAndGet(this.expungeEverythingByTypeWithoutPurging(theRequest, PartitionEntity.class, requestPartitionId));
        this.deletedResourceEntityCount = counter.get() - counterBefore;
        this.myTxService.withRequest(theRequest).withPropagation(propagation).withRequestPartitionId(requestPartitionId).execute(() -> counter.addAndGet(this.doExpungeEverythingQuery("DELETE from " + Search.class.getSimpleName() + " d")));
        this.purgeAllCaches();
        ourLog.info("COMPLETED GLOBAL $expunge - Deleted {} rows", (Object)counter.get());
    }

    public int getExpungeDeletedEntityCount() {
        return this.deletedResourceEntityCount;
    }

    private void purgeAllCaches() {
        this.myMemoryCacheService.invalidateAllCaches();
    }

    private int expungeEverythingByTypeWithoutPurging(RequestDetails theRequest, Class<?> theEntityType, RequestPartitionId theRequestPartitionId) {
        int outcome = 0;
        while (true) {
            StopWatch sw = new StopWatch();
            int count = (Integer)this.myTxService.withRequest(theRequest).withPropagation(Propagation.REQUIRES_NEW).withRequestPartitionId(theRequestPartitionId).execute(() -> {
                CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
                CriteriaQuery cq = cb.createQuery(theEntityType);
                cq.from(theEntityType);
                TypedQuery query = this.myEntityManager.createQuery(cq);
                query.setMaxResults(1000);
                List results = query.getResultList();
                for (Object result : results) {
                    this.myEntityManager.remove(result);
                }
                return results.size();
            });
            outcome += count;
            if (count == 0) break;
            ourLog.info("Have deleted {} entities of type {} in {}", new Object[]{outcome, theEntityType.getSimpleName(), sw});
        }
        return outcome;
    }

    public int expungeEverythingByType(Class<?> theEntityType) {
        int result = this.expungeEverythingByTypeWithoutPurging(null, theEntityType, RequestPartitionId.allPartitions());
        this.purgeAllCaches();
        return result;
    }

    public int expungeEverythingMdmLinks() {
        return this.expungeEverythingByType(MdmLink.class);
    }

    private int doExpungeEverythingQuery(String theQuery) {
        StopWatch sw = new StopWatch();
        int outcome = this.myEntityManager.createQuery(theQuery).executeUpdate();
        ourLog.debug("SqlQuery affected {} rows in {}: {}", new Object[]{outcome, sw, theQuery});
        return outcome;
    }
}

