/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.index;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.jpa.model.cross.JpaResourceLookup;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.search.builder.SearchBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class IdHelperService
implements IIdHelperService<JpaPid> {
    public static final Predicate[] EMPTY_PREDICATE_ARRAY = new Predicate[0];
    public static final String RESOURCE_PID = "RESOURCE_PID";
    @Autowired
    protected IResourceTableDao myResourceTableDao;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private FhirContext myFhirCtx;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired
    private PartitionSettings myPartitionSettings;
    private boolean myDontCheckActiveTransactionForUnitTest;

    @VisibleForTesting
    void setDontCheckActiveTransactionForUnitTest(boolean theDontCheckActiveTransactionForUnitTest) {
        this.myDontCheckActiveTransactionForUnitTest = theDontCheckActiveTransactionForUnitTest;
    }

    @Nonnull
    public IResourceLookup<JpaPid> resolveResourceIdentity(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theResourceId) throws ResourceNotFoundException {
        return this.resolveResourceIdentity(theRequestPartitionId, theResourceType, theResourceId, false);
    }

    @Nonnull
    public IResourceLookup<JpaPid> resolveResourceIdentity(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theResourceId, boolean theExcludeDeleted) throws ResourceNotFoundException {
        IdDt id;
        Map<String, List<IResourceLookup<JpaPid>>> matches;
        assert (this.myDontCheckActiveTransactionForUnitTest || TransactionSynchronizationManager.isSynchronizationActive());
        if (theResourceId.contains("/")) {
            theResourceId = theResourceId.substring(theResourceId.indexOf("/") + 1);
        }
        if ((matches = this.translateForcedIdToPids(theRequestPartitionId, Collections.singletonList(id = new IdDt(theResourceType, theResourceId)), theExcludeDeleted)).isEmpty() || !matches.containsKey(theResourceId)) {
            throw new ResourceNotFoundException(Msg.code((int)2001) + "Resource " + id + " is not known");
        }
        if (matches.size() > 1 || matches.get(theResourceId).size() > 1) {
            String msg = this.myFhirCtx.getLocalizer().getMessage(IdHelperService.class, "nonUniqueForcedId", new Object[0]);
            throw new PreconditionFailedException(Msg.code((int)1099) + msg);
        }
        return matches.get(theResourceId).get(0);
    }

    @Nonnull
    public Map<String, JpaPid> resolveResourcePersistentIds(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, List<String> theIds) {
        return this.resolveResourcePersistentIds(theRequestPartitionId, theResourceType, theIds, false);
    }

    @Nonnull
    public Map<String, JpaPid> resolveResourcePersistentIds(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, List<String> theIds, boolean theExcludeDeleted) {
        assert (this.myDontCheckActiveTransactionForUnitTest || TransactionSynchronizationManager.isSynchronizationActive());
        Validate.notNull(theIds, (String)"theIds cannot be null", (Object[])new Object[0]);
        Validate.isTrue((!theIds.isEmpty() ? 1 : 0) != 0, (String)"theIds must not be empty", (Object[])new Object[0]);
        HashMap<String, JpaPid> retVals = new HashMap<String, JpaPid>();
        for (String id : theIds) {
            JpaPid retVal;
            if (!this.idRequiresForcedId(id)) {
                retVal = JpaPid.fromId((Long)Long.parseLong(id));
                retVals.put(id, retVal);
                continue;
            }
            if (this.myStorageSettings.isDeleteEnabled()) {
                retVal = (JpaPid)this.resolveResourceIdentity(theRequestPartitionId, theResourceType, id, theExcludeDeleted).getPersistentId();
                retVals.put(id, retVal);
                continue;
            }
            String key = this.toForcedIdToPidKey(theRequestPartitionId, theResourceType, id);
            retVal = (JpaPid)this.myMemoryCacheService.getThenPutAfterCommit(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, (Object)key, t -> {
                List<IdType> ids = Collections.singletonList(new IdType(theResourceType, id));
                List<JpaPid> resolvedIds = this.resolveResourcePersistentIdsWithCache(theRequestPartitionId, ids);
                if (resolvedIds.isEmpty()) {
                    throw new ResourceNotFoundException(Msg.code((int)1100) + ids.get(0));
                }
                return resolvedIds.get(0);
            });
            retVals.put(id, retVal);
        }
        return retVals;
    }

    @Nonnull
    public JpaPid resolveResourcePersistentIds(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theId) {
        return this.resolveResourcePersistentIds(theRequestPartitionId, theResourceType, theId, false);
    }

    @Nonnull
    public JpaPid resolveResourcePersistentIds(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theId, boolean theExcludeDeleted) {
        Validate.notNull((Object)theId, (String)"theId must not be null", (Object[])new Object[0]);
        Map<String, JpaPid> retVal = this.resolveResourcePersistentIds(theRequestPartitionId, theResourceType, Collections.singletonList(theId), theExcludeDeleted);
        return retVal.get(theId);
    }

    public boolean idRequiresForcedId(String theId) {
        return this.myStorageSettings.getResourceClientIdStrategy() == JpaStorageSettings.ClientIdStrategyEnum.ANY || !IdHelperService.isValidPid(theId);
    }

    @Nonnull
    private String toForcedIdToPidKey(@Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, String theId) {
        return RequestPartitionId.stringifyForKey((RequestPartitionId)theRequestPartitionId) + "/" + theResourceType + "/" + theId;
    }

    @Nonnull
    public List<JpaPid> resolveResourcePersistentIdsWithCache(RequestPartitionId theRequestPartitionId, List<IIdType> theIds) {
        boolean onlyForcedIds = false;
        return this.resolveResourcePersistentIdsWithCache(theRequestPartitionId, theIds, onlyForcedIds);
    }

    @Nonnull
    public List<JpaPid> resolveResourcePersistentIdsWithCache(@Nonnull RequestPartitionId theRequestPartitionId, List<IIdType> theIds, boolean theOnlyForcedIds) {
        assert (this.myDontCheckActiveTransactionForUnitTest || TransactionSynchronizationManager.isSynchronizationActive());
        ArrayList<JpaPid> retVal = new ArrayList<JpaPid>(theIds.size());
        for (IIdType id : theIds) {
            if (id.hasIdPart()) continue;
            throw new InvalidRequestException(Msg.code((int)1101) + "Parameter value missing in request");
        }
        if (!theIds.isEmpty()) {
            HashSet<IIdType> idsToCheck = new HashSet<IIdType>(theIds.size());
            for (IIdType nextId : theIds) {
                if (this.myStorageSettings.getResourceClientIdStrategy() != JpaStorageSettings.ClientIdStrategyEnum.ANY && nextId.isIdPartValidLong()) {
                    if (theOnlyForcedIds) continue;
                    JpaPid jpaPid = JpaPid.fromId((Long)nextId.getIdPartAsLong());
                    jpaPid.setAssociatedResourceId(nextId);
                    retVal.add(jpaPid);
                    continue;
                }
                String key = this.toForcedIdToPidKey(theRequestPartitionId, nextId.getResourceType(), nextId.getIdPart());
                JpaPid cachedId = (JpaPid)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, (Object)key);
                if (cachedId != null) {
                    retVal.add(cachedId);
                    continue;
                }
                idsToCheck.add(nextId);
            }
            new QueryChunker().chunk(idsToCheck, SearchBuilder.getMaximumPageSize() / 2, ids -> this.doResolvePersistentIds(theRequestPartitionId, (List<IIdType>)ids, (List<JpaPid>)retVal));
        }
        return retVal;
    }

    private void doResolvePersistentIds(RequestPartitionId theRequestPartitionId, List<IIdType> theIds, List<JpaPid> theOutputListToPopulate) {
        CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createTupleQuery();
        Root from = criteriaQuery.from(ResourceTable.class);
        criteriaQuery.multiselect(new Selection[]{from.get("myId").as(Long.class), from.get("myResourceType").as(String.class), from.get("myFhirId").as(String.class)});
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(theIds.size());
        for (IIdType next : theIds) {
            ArrayList<Predicate> andPredicates = new ArrayList<Predicate>(3);
            if (StringUtils.isNotBlank((CharSequence)next.getResourceType())) {
                Predicate typeCriteria = cb.equal(from.get("myResourceType").as(String.class), (Object)next.getResourceType());
                andPredicates.add(typeCriteria);
            }
            Predicate idCriteria = cb.equal(from.get("myFhirId").as(String.class), (Object)next.getIdPart());
            andPredicates.add(idCriteria);
            this.getOptionalPartitionPredicate(theRequestPartitionId, cb, (Root<ResourceTable>)from).ifPresent(andPredicates::add);
            predicates.add(cb.and(andPredicates.toArray(EMPTY_PREDICATE_ARRAY)));
        }
        criteriaQuery.where((Expression)cb.or(predicates.toArray(EMPTY_PREDICATE_ARRAY)));
        TypedQuery query = this.myEntityManager.createQuery(criteriaQuery);
        List results = query.getResultList();
        for (Tuple nextId : results) {
            Long resourceId = (Long)nextId.get(0, Long.class);
            String resourceType = (String)nextId.get(1, String.class);
            String forcedId = (String)nextId.get(2, String.class);
            if (resourceId == null) continue;
            JpaPid jpaPid = JpaPid.fromId((Long)resourceId);
            this.populateAssociatedResourceId(resourceType, forcedId, jpaPid);
            theOutputListToPopulate.add(jpaPid);
            String key = this.toForcedIdToPidKey(theRequestPartitionId, resourceType, forcedId);
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, (Object)key, (Object)jpaPid);
        }
    }

    private Optional<Predicate> getOptionalPartitionPredicate(RequestPartitionId theRequestPartitionId, CriteriaBuilder cb, Root<ResourceTable> from) {
        if (this.myPartitionSettings.isAllowUnqualifiedCrossPartitionReference()) {
            return Optional.empty();
        }
        if (theRequestPartitionId.isDefaultPartition() && this.myPartitionSettings.getDefaultPartitionId() == null) {
            Predicate partitionIdCriteria = cb.isNull(from.get("myPartitionIdValue").as(Integer.class));
            return Optional.of(partitionIdCriteria);
        }
        if (!theRequestPartitionId.isAllPartitions()) {
            List<Integer> partitionIds = theRequestPartitionId.getPartitionIds();
            if ((partitionIds = BaseJoiningPredicateBuilder.replaceDefaultPartitionIdIfNonNull(this.myPartitionSettings, partitionIds)).size() > 1) {
                Predicate partitionIdCriteria = from.get("myPartitionIdValue").as(Integer.class).in(partitionIds);
                return Optional.of(partitionIdCriteria);
            }
            if (partitionIds.size() == 1) {
                Predicate partitionIdCriteria = cb.equal(from.get("myPartitionIdValue").as(Integer.class), (Object)partitionIds.get(0));
                return Optional.of(partitionIdCriteria);
            }
        }
        return Optional.empty();
    }

    private void populateAssociatedResourceId(String nextResourceType, String forcedId, JpaPid jpaPid) {
        IIdType resourceId = this.myFhirCtx.getVersion().newIdType();
        resourceId.setValue(nextResourceType + "/" + forcedId);
        jpaPid.setAssociatedResourceId(resourceId);
    }

    @Nonnull
    public IIdType translatePidIdToForcedId(FhirContext theCtx, String theResourceType, JpaPid theId) {
        if (theId.getAssociatedResourceId() != null) {
            return theId.getAssociatedResourceId();
        }
        IIdType retVal = theCtx.getVersion().newIdType();
        Optional<String> forcedId = this.translatePidIdToForcedIdWithCache(theId);
        if (forcedId.isPresent()) {
            retVal.setValue(forcedId.get());
        } else {
            retVal.setValue(theResourceType + "/" + theId);
        }
        return retVal;
    }

    public Optional<String> translatePidIdToForcedIdWithCache(JpaPid theId) {
        return (Optional)this.myMemoryCacheService.get(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, (Object)theId.getId(), pid -> this.myResourceTableDao.findById(pid).map(ResourceTable::asTypedFhirResourceId));
    }

    private ListMultimap<String, String> organizeIdsByResourceType(Collection<IIdType> theIds) {
        ListMultimap typeToIds = MultimapBuilder.hashKeys().arrayListValues().build();
        for (IIdType nextId : theIds) {
            if (this.myStorageSettings.getResourceClientIdStrategy() != JpaStorageSettings.ClientIdStrategyEnum.ANY && IdHelperService.isValidPid(nextId)) continue;
            if (nextId.hasResourceType()) {
                typeToIds.put((Object)nextId.getResourceType(), (Object)nextId.getIdPart());
                continue;
            }
            typeToIds.put((Object)"", (Object)nextId.getIdPart());
        }
        return typeToIds;
    }

    private Map<String, List<IResourceLookup<JpaPid>>> translateForcedIdToPids(@Nonnull RequestPartitionId theRequestPartitionId, Collection<IIdType> theId, boolean theExcludeDeleted) {
        List<Long> pids;
        theId.forEach(id -> Validate.isTrue((boolean)id.hasIdPart()));
        if (theId.isEmpty()) {
            return new HashMap<String, List<IResourceLookup<JpaPid>>>();
        }
        HashMap<String, List<IResourceLookup<JpaPid>>> retVal = new HashMap<String, List<IResourceLookup<JpaPid>>>();
        RequestPartitionId requestPartitionId = this.replaceDefault(theRequestPartitionId);
        if (this.myStorageSettings.getResourceClientIdStrategy() != JpaStorageSettings.ClientIdStrategyEnum.ANY && !(pids = theId.stream().filter(t -> IdHelperService.isValidPid(t)).map(t -> t.getIdPartAsLong()).collect(Collectors.toList())).isEmpty()) {
            this.resolvePids(requestPartitionId, pids, retVal);
        }
        ListMultimap<String, String> typeToIds = this.organizeIdsByResourceType(theId);
        for (Map.Entry nextEntry : typeToIds.asMap().entrySet()) {
            String nextResourceType = (String)nextEntry.getKey();
            Collection nextIds = (Collection)nextEntry.getValue();
            if (!this.myStorageSettings.isDeleteEnabled()) {
                Iterator forcedIdIterator = nextIds.iterator();
                while (forcedIdIterator.hasNext()) {
                    String nextForcedId = (String)forcedIdIterator.next();
                    String nextKey = nextResourceType + "/" + nextForcedId;
                    IResourceLookup cachedLookup = (IResourceLookup)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, (Object)nextKey);
                    if (cachedLookup == null) continue;
                    forcedIdIterator.remove();
                    retVal.computeIfAbsent(nextForcedId, id -> new ArrayList()).add(cachedLookup);
                }
            }
            if (nextIds.isEmpty()) continue;
            assert (StringUtils.isNotBlank((CharSequence)nextResourceType));
            Collection views = requestPartitionId.isAllPartitions() ? this.myResourceTableDao.findAndResolveByForcedIdWithNoType(nextResourceType, nextIds, theExcludeDeleted) : (requestPartitionId.isDefaultPartition() ? this.myResourceTableDao.findAndResolveByForcedIdWithNoTypeInPartitionNull(nextResourceType, nextIds, theExcludeDeleted) : (requestPartitionId.hasDefaultPartitionId() ? this.myResourceTableDao.findAndResolveByForcedIdWithNoTypeInPartitionIdOrNullPartitionId(nextResourceType, nextIds, requestPartitionId.getPartitionIdsWithoutDefault(), theExcludeDeleted) : this.myResourceTableDao.findAndResolveByForcedIdWithNoTypeInPartition(nextResourceType, nextIds, requestPartitionId.getPartitionIds(), theExcludeDeleted)));
            for (Object[] next : views) {
                String resourceType = (String)next[0];
                Long resourcePid = (Long)next[1];
                String forcedId = (String)next[2];
                Date deletedAt = (Date)next[3];
                JpaResourceLookup lookup = new JpaResourceLookup(resourceType, resourcePid, deletedAt);
                retVal.computeIfAbsent(forcedId, id -> new ArrayList()).add(lookup);
                if (this.myStorageSettings.isDeleteEnabled()) continue;
                String key = resourceType + "/" + forcedId;
                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, (Object)key, (Object)lookup);
            }
        }
        return retVal;
    }

    RequestPartitionId replaceDefault(RequestPartitionId theRequestPartitionId) {
        if (this.myPartitionSettings.getDefaultPartitionId() != null && !theRequestPartitionId.isAllPartitions() && theRequestPartitionId.hasDefaultPartitionId()) {
            List partitionIds = theRequestPartitionId.getPartitionIds().stream().map(t -> t == null ? this.myPartitionSettings.getDefaultPartitionId() : t).collect(Collectors.toList());
            return RequestPartitionId.fromPartitionIds(partitionIds);
        }
        return theRequestPartitionId;
    }

    private void resolvePids(@Nonnull RequestPartitionId theRequestPartitionId, List<Long> thePidsToResolve, Map<String, List<IResourceLookup<JpaPid>>> theTargets) {
        if (!this.myStorageSettings.isDeleteEnabled()) {
            Iterator<Long> forcedIdIterator = thePidsToResolve.iterator();
            while (forcedIdIterator.hasNext()) {
                Long nextPid = forcedIdIterator.next();
                String nextKey = Long.toString(nextPid);
                IResourceLookup cachedLookup = (IResourceLookup)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, (Object)nextKey);
                if (cachedLookup == null) continue;
                forcedIdIterator.remove();
                theTargets.computeIfAbsent(nextKey, id -> new ArrayList()).add(cachedLookup);
            }
        }
        if (!thePidsToResolve.isEmpty()) {
            Collection<Object[]> lookup = theRequestPartitionId.isAllPartitions() ? this.myResourceTableDao.findLookupFieldsByResourcePid(thePidsToResolve) : (theRequestPartitionId.isDefaultPartition() ? this.myResourceTableDao.findLookupFieldsByResourcePidInPartitionNull(thePidsToResolve) : (theRequestPartitionId.hasDefaultPartitionId() ? this.myResourceTableDao.findLookupFieldsByResourcePidInPartitionIdsOrNullPartition(thePidsToResolve, theRequestPartitionId.getPartitionIdsWithoutDefault()) : this.myResourceTableDao.findLookupFieldsByResourcePidInPartitionIds(thePidsToResolve, theRequestPartitionId.getPartitionIds())));
            lookup.stream().map(t -> new JpaResourceLookup((String)t[0], (Long)t[1], (Date)t[2])).forEach(t -> {
                String id = t.getPersistentId().toString();
                if (!theTargets.containsKey(id)) {
                    theTargets.put(id, new ArrayList());
                }
                ((List)theTargets.get(id)).add(t);
                if (!this.myStorageSettings.isDeleteEnabled()) {
                    String nextKey = t.getPersistentId().toString();
                    this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, (Object)nextKey, t);
                }
            });
        }
    }

    public PersistentIdToForcedIdMap<JpaPid> translatePidsToForcedIds(Set<JpaPid> theResourceIds) {
        assert (this.myDontCheckActiveTransactionForUnitTest || TransactionSynchronizationManager.isSynchronizationActive());
        Set thePids = theResourceIds.stream().map(JpaPid::getId).collect(Collectors.toSet());
        HashMap<Long, Optional> retVal = new HashMap<Long, Optional>(this.myMemoryCacheService.getAllPresent(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, thePids));
        List remainingPids = thePids.stream().filter(t -> !retVal.containsKey(t)).collect(Collectors.toList());
        new QueryChunker().chunk(remainingPids, t -> {
            List resourceEntities = this.myResourceTableDao.findAllById((Iterable)t);
            for (ResourceTable nextResourceEntity : resourceEntities) {
                Long nextResourcePid = nextResourceEntity.getId();
                Optional<String> nextForcedId = Optional.of(nextResourceEntity.asTypedFhirResourceId());
                retVal.put(nextResourcePid, nextForcedId);
                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, (Object)nextResourcePid, nextForcedId);
            }
        });
        remainingPids = thePids.stream().filter(t -> !retVal.containsKey(t)).collect(Collectors.toList());
        for (Long nextResourcePid : remainingPids) {
            retVal.put(nextResourcePid, Optional.empty());
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, (Object)nextResourcePid, Optional.empty());
        }
        HashMap convertRetVal = new HashMap();
        retVal.forEach((k, v) -> convertRetVal.put(JpaPid.fromId((Long)k), v));
        return new PersistentIdToForcedIdMap(convertRetVal);
    }

    public void addResolvedPidToForcedId(JpaPid theJpaPid, @Nonnull RequestPartitionId theRequestPartitionId, String theResourceType, @Nullable String theForcedId, @Nullable Date theDeletedAt) {
        if (theForcedId != null) {
            if (theJpaPid.getAssociatedResourceId() == null) {
                this.populateAssociatedResourceId(theResourceType, theForcedId, theJpaPid);
            }
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, (Object)theJpaPid.getId(), Optional.of(theResourceType + "/" + theForcedId));
            String key = this.toForcedIdToPidKey(theRequestPartitionId, theResourceType, theForcedId);
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.FORCED_ID_TO_PID, (Object)key, (Object)theJpaPid);
        } else {
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.PID_TO_FORCED_ID, (Object)theJpaPid.getId(), Optional.empty());
        }
        if (!this.myStorageSettings.isDeleteEnabled()) {
            JpaResourceLookup lookup = new JpaResourceLookup(theResourceType, theJpaPid.getId(), theDeletedAt);
            String nextKey = theJpaPid.toString();
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.RESOURCE_LOOKUP, (Object)nextKey, (Object)lookup);
        }
    }

    @VisibleForTesting
    void setPartitionSettingsForUnitTest(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    public static boolean isValidPid(IIdType theId) {
        if (theId == null) {
            return false;
        }
        String idPart = theId.getIdPart();
        return IdHelperService.isValidPid(idPart);
    }

    public static boolean isValidPid(String theIdPart) {
        return StringUtils.isNumeric((CharSequence)theIdPart);
    }

    @Nonnull
    public List<JpaPid> getPidsOrThrowException(@Nonnull RequestPartitionId theRequestPartitionId, List<IIdType> theIds) {
        List<JpaPid> resourcePersistentIds = this.resolveResourcePersistentIdsWithCache(theRequestPartitionId, theIds);
        return resourcePersistentIds;
    }

    @Nullable
    public JpaPid getPidOrNull(@Nonnull RequestPartitionId theRequestPartitionId, IBaseResource theResource) {
        JpaPid retVal;
        Object resourceId = theResource.getUserData(RESOURCE_PID);
        if (resourceId == null) {
            IIdType id = theResource.getIdElement();
            try {
                retVal = this.resolveResourcePersistentIds(theRequestPartitionId, id.getResourceType(), id.getIdPart());
            }
            catch (ResourceNotFoundException e) {
                retVal = null;
            }
        } else {
            retVal = JpaPid.fromId((Long)Long.parseLong(resourceId.toString()));
        }
        return retVal;
    }

    @Nonnull
    public JpaPid getPidOrThrowException(@Nonnull RequestPartitionId theRequestPartitionId, IIdType theId) {
        List<IIdType> ids = Collections.singletonList(theId);
        List<JpaPid> resourcePersistentIds = this.resolveResourcePersistentIdsWithCache(theRequestPartitionId, ids);
        if (resourcePersistentIds.isEmpty()) {
            throw new InvalidRequestException(Msg.code((int)2295) + "Invalid ID was provided: [" + theId.getIdPart() + "]");
        }
        return resourcePersistentIds.get(0);
    }

    @Nonnull
    public JpaPid getPidOrThrowException(@Nonnull IAnyResource theResource) {
        Long theResourcePID = (Long)theResource.getUserData(RESOURCE_PID);
        if (theResourcePID == null) {
            throw new IllegalStateException(Msg.code((int)2108) + String.format("Unable to find %s in the user data for %s with ID %s", RESOURCE_PID, theResource, theResource.getId()));
        }
        return JpaPid.fromId((Long)theResourcePID);
    }

    public IIdType resourceIdFromPidOrThrowException(JpaPid thePid, String theResourceType) {
        Optional optionalResource = this.myResourceTableDao.findById(thePid.getId());
        if (optionalResource.isEmpty()) {
            throw new ResourceNotFoundException(Msg.code((int)2124) + "Requested resource not found");
        }
        return ((ResourceTable)optionalResource.get()).getIdDt().toVersionless();
    }

    public Set<String> translatePidsToFhirResourceIds(Set<JpaPid> thePids) {
        assert (TransactionSynchronizationManager.isSynchronizationActive());
        PersistentIdToForcedIdMap<JpaPid> pidToForcedIdMap = this.translatePidsToForcedIds(thePids);
        return pidToForcedIdMap.getResolvedResourceIds();
    }

    public JpaPid newPid(Object thePid) {
        return JpaPid.fromId((Long)((Long)thePid));
    }

    public JpaPid newPidFromStringIdAndResourceName(String thePid, String theResourceName) {
        return JpaPid.fromIdAndResourceType((Long)Long.parseLong(thePid), (String)theResourceName);
    }
}

