/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.index;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirDao;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedComboStringUniqueDao;
import ca.uhn.fhir.jpa.dao.index.DaoSearchParamSynchronizer;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamWithInlineReferencesExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamWithInlineReferencesExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorService;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class SearchParamWithInlineReferencesExtractor
extends BaseSearchParamWithInlineReferencesExtractor<JpaPid>
implements ISearchParamWithInlineReferencesExtractor {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchParamWithInlineReferencesExtractor.class);
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private SearchParamExtractorService mySearchParamExtractorService;
    @Autowired
    private DaoSearchParamSynchronizer myDaoSearchParamSynchronizer;
    @Autowired
    private IResourceIndexedComboStringUniqueDao myResourceIndexedCompositeStringUniqueDao;
    @Autowired
    private PartitionSettings myPartitionSettings;

    @VisibleForTesting
    public void setPartitionSettings(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    @VisibleForTesting
    public void setSearchParamExtractorService(SearchParamExtractorService theSearchParamExtractorService) {
        this.mySearchParamExtractorService = theSearchParamExtractorService;
    }

    @VisibleForTesting
    public void setSearchParamRegistry(ISearchParamRegistry theSearchParamRegistry) {
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    public void populateFromResource(RequestPartitionId theRequestPartitionId, ResourceIndexedSearchParams theParams, TransactionDetails theTransactionDetails, ResourceTable theEntity, IBaseResource theResource, ResourceIndexedSearchParams theExistingParams, RequestDetails theRequest, boolean thePerformIndexing) {
        if (thePerformIndexing) {
            this.extractInlineReferences(theRequest, theResource, theTransactionDetails);
        }
        this.mySearchParamExtractorService.extractFromResource(theRequestPartitionId, theRequest, theParams, theExistingParams, theEntity, theResource, theTransactionDetails, thePerformIndexing, ISearchParamExtractor.ALL_PARAMS);
        Iterator existingLinkIter = theExistingParams.getResourceLinks().iterator();
        while (existingLinkIter.hasNext()) {
            ResourceLink nextExisting = (ResourceLink)existingLinkIter.next();
            if (!theParams.myLinks.remove(nextExisting)) continue;
            existingLinkIter.remove();
            theParams.myLinks.add(nextExisting);
        }
    }

    @Nullable
    private Collection<? extends BaseResourceIndexedSearchParam> findParameterIndexes(ResourceIndexedSearchParams theParams, RuntimeSearchParam nextCompositeOf) {
        Collection paramsListForCompositePart = null;
        switch (nextCompositeOf.getParamType()) {
            case NUMBER: {
                paramsListForCompositePart = theParams.myNumberParams;
                break;
            }
            case DATE: {
                paramsListForCompositePart = theParams.myDateParams;
                break;
            }
            case STRING: {
                paramsListForCompositePart = theParams.myStringParams;
                break;
            }
            case TOKEN: {
                paramsListForCompositePart = theParams.myTokenParams;
                break;
            }
            case QUANTITY: {
                paramsListForCompositePart = theParams.myQuantityParams;
                break;
            }
            case URI: {
                paramsListForCompositePart = theParams.myUriParams;
                break;
            }
        }
        if (paramsListForCompositePart != null) {
            paramsListForCompositePart = paramsListForCompositePart.stream().filter(t -> t.getParamName().equals(nextCompositeOf.getName())).collect(Collectors.toList());
        }
        return paramsListForCompositePart;
    }

    @VisibleForTesting
    public void setDaoSearchParamSynchronizer(DaoSearchParamSynchronizer theDaoSearchParamSynchronizer) {
        this.myDaoSearchParamSynchronizer = theDaoSearchParamSynchronizer;
    }

    public void storeUniqueComboParameters(ResourceIndexedSearchParams theParams, ResourceTable theEntity, ResourceIndexedSearchParams theExistingParams) {
        if (this.myStorageSettings.isUniqueIndexesEnabled()) {
            for (ResourceIndexedComboStringUnique next : DaoSearchParamSynchronizer.subtract(theExistingParams.myComboStringUniques, theParams.myComboStringUniques)) {
                ourLog.debug("Removing unique index: {}", (Object)next);
                this.myEntityManager.remove((Object)next);
                theEntity.getParamsComboStringUnique().remove(next);
            }
            boolean haveNewStringUniqueParams = false;
            for (ResourceIndexedComboStringUnique next : DaoSearchParamSynchronizer.subtract(theParams.myComboStringUniques, theExistingParams.myComboStringUniques)) {
                ResourceIndexedComboStringUnique existing;
                if (this.myStorageSettings.isUniqueIndexesCheckedBeforeSave() && (existing = this.myResourceIndexedCompositeStringUniqueDao.findByQueryString(next.getIndexString())) != null) {
                    String searchParameterId = "(unknown)";
                    if (next.getSearchParameterId() != null) {
                        searchParameterId = next.getSearchParameterId().toUnqualifiedVersionless().getValue();
                    }
                    String msg = this.myFhirContext.getLocalizer().getMessage(BaseHapiFhirDao.class, "uniqueIndexConflictFailure", new Object[]{theEntity.getResourceType(), next.getIndexString(), existing.getResource().getIdDt().toUnqualifiedVersionless().getValue(), searchParameterId});
                    throw new ResourceVersionConflictException(Msg.code((int)1093) + msg);
                }
                ourLog.debug("Persisting unique index: {}", (Object)next);
                this.myEntityManager.persist((Object)next);
                haveNewStringUniqueParams = true;
            }
            theEntity.setParamsComboStringUniquePresent(theParams.myComboStringUniques.size() > 0 || haveNewStringUniqueParams);
        }
    }
}

