/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.mdm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdmExpansionCacheSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmExpansionCacheSvc.class);
    private final ConcurrentHashMap<String, String> mySourceToGoldenIdCache = new ConcurrentHashMap();

    public String getGoldenResourceId(String theSourceId) {
        ourLog.debug(this.buildLogMessage("About to lookup cached resource ID " + theSourceId));
        String goldenResourceId = this.mySourceToGoldenIdCache.get(theSourceId);
        if (StringUtils.isBlank((CharSequence)goldenResourceId) && this.mySourceToGoldenIdCache.containsValue(theSourceId)) {
            goldenResourceId = theSourceId;
        }
        return goldenResourceId;
    }

    private String buildLogMessage(String theMessage) {
        return this.buildLogMessage(theMessage, false);
    }

    public String buildLogMessage(String message, boolean theAddCacheContentContent) {
        StringBuilder builder = new StringBuilder();
        builder.append(message);
        if (ourLog.isDebugEnabled() || theAddCacheContentContent) {
            builder.append("\n").append("Current cache content is:").append("\n");
            this.mySourceToGoldenIdCache.entrySet().stream().forEach(entry -> builder.append((String)entry.getKey()).append(" -> ").append((String)entry.getValue()).append("\n"));
            return builder.toString();
        }
        return builder.toString();
    }

    public void setCacheContents(Map<String, String> theSourceResourceIdToGoldenResourceIdMap) {
        if (this.mySourceToGoldenIdCache.isEmpty()) {
            this.mySourceToGoldenIdCache.putAll(theSourceResourceIdToGoldenResourceIdMap);
        }
    }

    public boolean hasBeenPopulated() {
        return !this.mySourceToGoldenIdCache.isEmpty();
    }
}

