/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.mdm;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.IMdmLinkJpaRepository;
import ca.uhn.fhir.jpa.entity.HapiFhirEnversRevision;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.EnversRevision;
import ca.uhn.fhir.mdm.api.IMdmLink;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmLinkWithRevision;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.api.params.MdmHistorySearchParameters;
import ca.uhn.fhir.mdm.api.params.MdmQuerySearchParameters;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.mdm.model.MdmPidTuple;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQueryCreator;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.history.Revisions;

public class MdmLinkDaoJpaImpl
implements IMdmLinkDao<JpaPid, MdmLink> {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmLinkDaoJpaImpl.class);
    @Autowired
    IMdmLinkJpaRepository myMdmLinkDao;
    @Autowired
    protected EntityManager myEntityManager;
    @Autowired
    private IIdHelperService<JpaPid> myIdHelperService;
    @Autowired
    private AuditReader myAuditReader;

    public int deleteWithAnyReferenceToPid(JpaPid thePid) {
        return this.myMdmLinkDao.deleteWithAnyReferenceToPid(thePid.getId());
    }

    public int deleteWithAnyReferenceToPidAndMatchResultNot(JpaPid thePid, MdmMatchResultEnum theMatchResult) {
        return this.myMdmLinkDao.deleteWithAnyReferenceToPidAndMatchResultNot(thePid.getId(), theMatchResult);
    }

    public List<MdmPidTuple<JpaPid>> expandPidsFromGroupPidGivenMatchResult(JpaPid theGroupPid, MdmMatchResultEnum theMdmMatchResultEnum) {
        return this.myMdmLinkDao.expandPidsFromGroupPidGivenMatchResult(theGroupPid.getId(), theMdmMatchResultEnum).stream().map(this::daoTupleToMdmTuple).collect(Collectors.toList());
    }

    private MdmPidTuple<JpaPid> daoTupleToMdmTuple(IMdmLinkJpaRepository.MdmPidTuple theMdmPidTuple) {
        return MdmPidTuple.fromGoldenAndSource((IResourcePersistentId)JpaPid.fromId((Long)theMdmPidTuple.getGoldenPid()), (IResourcePersistentId)JpaPid.fromId((Long)theMdmPidTuple.getSourcePid()));
    }

    public List<MdmPidTuple<JpaPid>> expandPidsBySourcePidAndMatchResult(JpaPid theSourcePid, MdmMatchResultEnum theMdmMatchResultEnum) {
        return this.myMdmLinkDao.expandPidsBySourcePidAndMatchResult(theSourcePid.getId(), theMdmMatchResultEnum).stream().map(this::daoTupleToMdmTuple).collect(Collectors.toList());
    }

    public List<MdmLink> findLinksAssociatedWithGoldenResourceOfSourceResourceExcludingNoMatch(JpaPid theSourcePid) {
        return this.myMdmLinkDao.findLinksAssociatedWithGoldenResourceOfSourceResourceExcludingMatchResult(theSourcePid.getId(), MdmMatchResultEnum.NO_MATCH);
    }

    public List<MdmPidTuple<JpaPid>> expandPidsByGoldenResourcePidAndMatchResult(JpaPid theSourcePid, MdmMatchResultEnum theMdmMatchResultEnum) {
        return this.myMdmLinkDao.expandPidsByGoldenResourcePidAndMatchResult(theSourcePid.getId(), theMdmMatchResultEnum).stream().map(this::daoTupleToMdmTuple).collect(Collectors.toList());
    }

    public List<JpaPid> findPidByResourceNameAndThreshold(String theResourceName, Date theHighThreshold, Pageable thePageable) {
        return this.myMdmLinkDao.findPidByResourceNameAndThreshold(theResourceName, theHighThreshold, thePageable).stream().map(JpaPid::fromId).collect(Collectors.toList());
    }

    public List<JpaPid> findPidByResourceNameAndThresholdAndPartitionId(String theResourceName, Date theHighThreshold, List<Integer> thePartitionIds, Pageable thePageable) {
        return this.myMdmLinkDao.findPidByResourceNameAndThresholdAndPartitionId(theResourceName, theHighThreshold, thePartitionIds, thePageable).stream().map(JpaPid::fromId).collect(Collectors.toList());
    }

    public List<MdmLink> findAllById(List<JpaPid> thePids) {
        List theLongPids = thePids.stream().map(JpaPid::getId).collect(Collectors.toList());
        return this.myMdmLinkDao.findAllById(theLongPids);
    }

    public Optional<MdmLink> findById(JpaPid thePid) {
        return this.myMdmLinkDao.findById(thePid.getId());
    }

    public void deleteAll(List<MdmLink> theLinks) {
        this.myMdmLinkDao.deleteAll(theLinks);
    }

    public List<MdmLink> findAll(Example<MdmLink> theExample) {
        return this.myMdmLinkDao.findAll(theExample);
    }

    public List<MdmLink> findAll() {
        return this.myMdmLinkDao.findAll();
    }

    public Long count() {
        return this.myMdmLinkDao.count();
    }

    public void deleteAll() {
        this.myMdmLinkDao.deleteAll();
    }

    public MdmLink save(MdmLink theMdmLink) {
        return (MdmLink)((Object)this.myMdmLinkDao.save((Object)theMdmLink));
    }

    public Optional<MdmLink> findOne(Example<MdmLink> theExample) {
        return this.myMdmLinkDao.findOne(theExample);
    }

    public void delete(MdmLink theMdmLink) {
        this.myMdmLinkDao.delete((Object)theMdmLink);
    }

    public MdmLink validateMdmLink(IMdmLink theMdmLink) throws UnprocessableEntityException {
        if (theMdmLink instanceof MdmLink) {
            return (MdmLink)theMdmLink;
        }
        throw new UnprocessableEntityException(Msg.code((int)2109) + "Unprocessable MdmLink implementation");
    }

    @Deprecated
    public Page<MdmLink> search(IIdType theGoldenResourceId, IIdType theSourceId, MdmMatchResultEnum theMatchResult, MdmLinkSourceEnum theLinkSource, MdmPageRequest thePageRequest, List<Integer> thePartitionIds) {
        MdmQuerySearchParameters mdmQuerySearchParameters = new MdmQuerySearchParameters(thePageRequest).setGoldenResourceId(theGoldenResourceId).setSourceId(theSourceId).setMatchResult(theMatchResult).setLinkSource(theLinkSource).setPartitionIds(thePartitionIds);
        return this.search(mdmQuerySearchParameters);
    }

    public Page<MdmLink> search(MdmQuerySearchParameters theParams) {
        CriteriaBuilder criteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(MdmLink.class);
        Root from = criteriaQuery.from(MdmLink.class);
        List<Order> orderList = this.getOrderList(theParams, criteriaBuilder, (Root<MdmLink>)from);
        List<Predicate> andPredicates = this.buildPredicates(theParams, criteriaBuilder, (Root<MdmLink>)from);
        Predicate finalQuery = criteriaBuilder.and(andPredicates.toArray(new Predicate[0]));
        if (!orderList.isEmpty()) {
            criteriaQuery.orderBy(orderList);
        }
        TypedQuery typedQuery = this.myEntityManager.createQuery(criteriaQuery.where((Expression)finalQuery));
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        countQuery.select((Selection)criteriaBuilder.count((Expression)countQuery.from(MdmLink.class))).where((Expression)finalQuery);
        Long totalResults = (Long)this.myEntityManager.createQuery(countQuery).getSingleResult();
        MdmPageRequest pageRequest = theParams.getPageRequest();
        List result = typedQuery.setFirstResult(pageRequest.getOffset()).setMaxResults(pageRequest.getCount()).getResultList();
        return new PageImpl(result, (Pageable)PageRequest.of((int)pageRequest.getPage(), (int)pageRequest.getCount()), totalResults.longValue());
    }

    @NotNull
    private List<Predicate> buildPredicates(MdmQuerySearchParameters theParams, CriteriaBuilder criteriaBuilder, Root<MdmLink> from) {
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>();
        if (theParams.getGoldenResourceId() != null) {
            Predicate goldenResourcePredicate = criteriaBuilder.equal(from.get("myGoldenResourcePid").as(Long.class), (Object)((JpaPid)this.myIdHelperService.getPidOrThrowException(RequestPartitionId.allPartitions(), theParams.getGoldenResourceId())).getId());
            andPredicates.add(goldenResourcePredicate);
        }
        if (theParams.getSourceId() != null) {
            Predicate sourceIdPredicate = criteriaBuilder.equal(from.get("mySourcePid").as(Long.class), (Object)((JpaPid)this.myIdHelperService.getPidOrThrowException(RequestPartitionId.allPartitions(), theParams.getSourceId())).getId());
            andPredicates.add(sourceIdPredicate);
        }
        if (theParams.getMatchResult() != null) {
            Predicate matchResultPredicate = criteriaBuilder.equal(from.get("myMatchResult").as(MdmMatchResultEnum.class), (Object)theParams.getMatchResult());
            andPredicates.add(matchResultPredicate);
        }
        if (theParams.getLinkSource() != null) {
            Predicate linkSourcePredicate = criteriaBuilder.equal(from.get("myLinkSource").as(MdmLinkSourceEnum.class), (Object)theParams.getLinkSource());
            andPredicates.add(linkSourcePredicate);
        }
        if (!CollectionUtils.isEmpty((Collection)theParams.getPartitionIds())) {
            Expression exp = from.get("myPartitionId").get("myPartitionId").as(Integer.class);
            Predicate linkSourcePredicate = exp.in((Collection)theParams.getPartitionIds());
            andPredicates.add(linkSourcePredicate);
        }
        if (theParams.getResourceType() != null) {
            Predicate resourceTypePredicate = criteriaBuilder.equal(from.get("myGoldenResource").get("myResourceType").as(String.class), (Object)theParams.getResourceType());
            andPredicates.add(resourceTypePredicate);
        }
        return andPredicates;
    }

    private List<Order> getOrderList(MdmQuerySearchParameters theParams, CriteriaBuilder criteriaBuilder, Root<MdmLink> from) {
        if (CollectionUtils.isEmpty((Collection)theParams.getSort())) {
            return Collections.emptyList();
        }
        return theParams.getSort().stream().map(sortSpec -> {
            Path path = from.get(sortSpec.getParamName());
            return sortSpec.getOrder() == SortOrderEnum.DESC ? criteriaBuilder.desc((Expression)path) : criteriaBuilder.asc((Expression)path);
        }).collect(Collectors.toList());
    }

    public Optional<MdmLink> findBySourcePidAndMatchResult(JpaPid theSourcePid, MdmMatchResultEnum theMatch) {
        return this.myMdmLinkDao.findBySourcePidAndMatchResult(theSourcePid.getId(), theMatch);
    }

    public void deleteLinksWithAnyReferenceToPids(List<JpaPid> theResourcePersistentIds) {
        List goldenResourcePids = theResourcePersistentIds.stream().map(JpaPid::getId).collect(Collectors.toList());
        List chunks = ListUtils.partition(goldenResourcePids, (int)500);
        for (List chunk : chunks) {
            this.myMdmLinkDao.deleteLinksWithAnyReferenceToPids(chunk);
            this.myMdmLinkDao.deleteLinksHistoryWithAnyReferenceToPids(chunk);
        }
    }

    @Deprecated(since="6.5.6", forRemoval=true)
    public Revisions<Long, MdmLink> findHistory(JpaPid theMdmLinkPid) {
        Revisions revisions = this.myMdmLinkDao.findRevisions(theMdmLinkPid.getId());
        revisions.forEach(revision -> ourLog.debug("MdmLink revision: {}", revision));
        return revisions;
    }

    public List<MdmLinkWithRevision<MdmLink>> getHistoryForIds(MdmHistorySearchParameters theMdmHistorySearchParameters) {
        AuditQueryCreator auditQueryCreator = this.myAuditReader.createQuery();
        try {
            AuditCriterion goldenResourceAndOrResourceIdCriterion;
            AuditCriterion goldenResourceIdCriterion = this.buildAuditCriterionOrNull(theMdmHistorySearchParameters.getGoldenResourceIds(), "myGoldenResourcePid");
            AuditCriterion resourceIdCriterion = this.buildAuditCriterionOrNull(theMdmHistorySearchParameters.getSourceIds(), "mySourcePid");
            if (!theMdmHistorySearchParameters.getGoldenResourceIds().isEmpty() && !theMdmHistorySearchParameters.getSourceIds().isEmpty()) {
                if (ObjectUtils.anyNull((Object[])new Object[]{goldenResourceIdCriterion, resourceIdCriterion})) {
                    return new ArrayList<MdmLinkWithRevision<MdmLink>>();
                }
                goldenResourceAndOrResourceIdCriterion = AuditEntity.and((AuditCriterion)goldenResourceIdCriterion, (AuditCriterion)resourceIdCriterion);
            } else if (!theMdmHistorySearchParameters.getGoldenResourceIds().isEmpty()) {
                if (ObjectUtils.anyNull((Object[])new Object[]{goldenResourceIdCriterion})) {
                    return new ArrayList<MdmLinkWithRevision<MdmLink>>();
                }
                goldenResourceAndOrResourceIdCriterion = goldenResourceIdCriterion;
            } else if (!theMdmHistorySearchParameters.getSourceIds().isEmpty()) {
                if (ObjectUtils.anyNull((Object[])new Object[]{resourceIdCriterion})) {
                    return new ArrayList<MdmLinkWithRevision<MdmLink>>();
                }
                goldenResourceAndOrResourceIdCriterion = resourceIdCriterion;
            } else {
                throw new IllegalArgumentException(Msg.code((int)2298) + "$mdm-link-history Golden resource and source query IDs cannot both be empty.");
            }
            List mdmLinksWithRevisions = auditQueryCreator.forRevisionsOfEntity(MdmLink.class, false, false).add(goldenResourceAndOrResourceIdCriterion).addOrder(AuditEntity.property((String)"myGoldenResourcePid").asc()).addOrder(AuditEntity.property((String)"mySourcePid").asc()).addOrder(AuditEntity.revisionNumber().desc()).getResultList();
            return mdmLinksWithRevisions.stream().map(this::buildRevisionFromObjectArray).collect(Collectors.toUnmodifiableList());
        }
        catch (IllegalStateException exception) {
            ourLog.error("got an Exception when trying to invoke Envers:", (Throwable)exception);
            throw new IllegalStateException(Msg.code((int)2291) + "Hibernate envers AuditReader is returning Service is not yet initialized but front-end validation has not caught the error that envers is disabled");
        }
    }

    @Nonnull
    private List<Long> convertToLongIds(List<IIdType> theMdmHistorySearchParameters) {
        return this.myIdHelperService.getPidsOrThrowException(RequestPartitionId.allPartitions(), theMdmHistorySearchParameters).stream().map(JpaPid::getId).collect(Collectors.toUnmodifiableList());
    }

    private AuditCriterion buildAuditCriterionOrNull(List<IIdType> theMdmHistorySearchParameterIds, String theProperty) {
        List<Long> longIds = this.convertToLongIds(theMdmHistorySearchParameterIds);
        return longIds.isEmpty() ? null : AuditEntity.property((String)theProperty).in(longIds);
    }

    private MdmLinkWithRevision<MdmLink> buildRevisionFromObjectArray(Object[] theArray) {
        Object mdmLinkUncast = theArray[0];
        Object revisionUncast = theArray[1];
        Object revisionTypeUncast = theArray[2];
        Validate.isInstanceOf(MdmLink.class, (Object)mdmLinkUncast);
        Validate.isInstanceOf(HapiFhirEnversRevision.class, (Object)revisionUncast);
        Validate.isInstanceOf(RevisionType.class, (Object)revisionTypeUncast);
        HapiFhirEnversRevision revision = (HapiFhirEnversRevision)revisionUncast;
        return new MdmLinkWithRevision((IMdmLink)((MdmLink)((Object)mdmLinkUncast)), new EnversRevision((RevisionType)revisionTypeUncast, revision.getRev(), revision.getRevtstmp()));
    }
}

