/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.mdm;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.dao.data.IMdmLinkJpaMetricsRepository;
import ca.uhn.fhir.mdm.api.BaseMdmMetricSvc;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.params.GenerateMdmMetricsParameters;
import ca.uhn.fhir.mdm.model.MdmLinkMetrics;
import ca.uhn.fhir.mdm.model.MdmLinkScoreMetrics;
import ca.uhn.fhir.mdm.model.MdmMetrics;
import ca.uhn.fhir.mdm.model.MdmResourceMetrics;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

public class MdmMetricSvcJpaImpl
extends BaseMdmMetricSvc {
    private final IMdmLinkJpaMetricsRepository myJpaRepository;
    private final EntityManagerFactory myEntityManagerFactory;

    public MdmMetricSvcJpaImpl(IMdmLinkJpaMetricsRepository theRepository, DaoRegistry theDaoRegistry, EntityManagerFactory theEntityManagerFactory) {
        super(theDaoRegistry);
        this.myJpaRepository = theRepository;
        this.myEntityManagerFactory = theEntityManagerFactory;
    }

    protected MdmLinkMetrics generateLinkMetrics(GenerateMdmMetricsParameters theParameters) {
        List<MdmLinkSourceEnum> linkSources = theParameters.getLinkSourceFilters();
        List<MdmMatchResultEnum> matchResults = theParameters.getMatchResultFilters();
        if (linkSources.isEmpty()) {
            linkSources = Arrays.asList(MdmLinkSourceEnum.values());
        }
        if (matchResults.isEmpty()) {
            matchResults = Arrays.asList(MdmMatchResultEnum.values());
        }
        Object[][] data = this.myJpaRepository.generateMetrics(theParameters.getResourceType(), linkSources, matchResults);
        MdmLinkMetrics metrics = new MdmLinkMetrics();
        metrics.setResourceType(theParameters.getResourceType());
        for (Object[] row : data) {
            MdmMatchResultEnum matchResult = (MdmMatchResultEnum)row[0];
            MdmLinkSourceEnum source = (MdmLinkSourceEnum)row[1];
            long count = (Long)row[2];
            metrics.addMetric(matchResult, source, count);
        }
        return metrics;
    }

    protected MdmLinkScoreMetrics generateLinkScoreMetrics(GenerateMdmMetricsParameters theParameters) {
        String resourceType = theParameters.getResourceType();
        List<MdmMatchResultEnum> matchResultTypes = theParameters.getMatchResultFilters();
        if (matchResultTypes.isEmpty()) {
            matchResultTypes = Arrays.asList(MdmMatchResultEnum.values());
        }
        String sql = "SELECT %s FROM MPI_LINK ml WHERE ml.TARGET_TYPE = :resourceType AND ml.MATCH_RESULT in (:matchResult)";
        StringBuilder sb = new StringBuilder();
        sb.append("sum(case when ml.SCORE is null then 1 else 0 end) as B_NULL");
        for (int i = 0; i < 100; ++i) {
            double bucket = this.getBucket(i + 1);
            sb.append(",\n");
            if (i == 0) {
                sb.append(String.format("sum(case when ml.SCORE <= %.2f then 1 else 0 end) as B%d", bucket, i));
                continue;
            }
            sb.append(String.format("sum(case when ml.score > %.2f and ml.SCORE <= %.2f then 1 else 0 end) as B%d", this.getBucket(i), bucket, i));
        }
        EntityManager em = this.myEntityManagerFactory.createEntityManager();
        Query nativeQuery = em.createNativeQuery(String.format(sql, sb.toString()));
        org.hibernate.query.Query hibernateQuery = (org.hibernate.query.Query)nativeQuery;
        hibernateQuery.setParameter("resourceType", (Object)resourceType);
        hibernateQuery.setParameter("matchResult", matchResultTypes.stream().map(Enum::ordinal).collect(Collectors.toList()));
        List results = hibernateQuery.getResultList();
        em.close();
        MdmLinkScoreMetrics metrics = new MdmLinkScoreMetrics();
        Object[] row = (Object[])results.get(0);
        int length = row.length;
        for (int i = 0; i < length; ++i) {
            BigInteger bi = row[i] != null ? (BigInteger)row[i] : BigInteger.valueOf(0L);
            double bucket = this.getBucket(i);
            if (i == 0) {
                metrics.addScore("NULL", Long.valueOf(bi.longValue()));
                continue;
            }
            if (i == 1) {
                metrics.addScore(String.format("x_<_%.2f", bucket), Long.valueOf(bi.longValue()));
                continue;
            }
            metrics.addScore(String.format("%.2f_<_x_<=_%.2f", this.getBucket(i - 1), bucket), Long.valueOf(bi.longValue()));
        }
        return metrics;
    }

    @Transactional
    public MdmMetrics generateMdmMetrics(GenerateMdmMetricsParameters theParameters) {
        MdmResourceMetrics resourceMetrics = this.generateResourceMetrics(theParameters);
        MdmLinkMetrics linkMetrics = this.generateLinkMetrics(theParameters);
        MdmLinkScoreMetrics scoreMetrics = this.generateLinkScoreMetrics(theParameters);
        MdmMetrics metrics = MdmMetrics.fromSeperableMetrics((MdmResourceMetrics)resourceMetrics, (MdmLinkMetrics)linkMetrics, (MdmLinkScoreMetrics)scoreMetrics);
        return metrics;
    }
}

