/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.r4b;

import ca.uhn.fhir.jpa.dao.BaseHapiFhirSystemDao;
import ca.uhn.fhir.jpa.dao.JpaResourceDao;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.Collection;
import java.util.List;
import javax.persistence.TypedQuery;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.Meta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirSystemDaoR4B
extends BaseHapiFhirSystemDao<Bundle, Meta> {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirSystemDaoR4B.class);

    public Meta metaGetOperation(RequestDetails theRequestDetails) {
        String sql = "SELECT d FROM TagDefinition d WHERE d.myId IN (SELECT DISTINCT t.myTagId FROM ResourceTag t)";
        TypedQuery q = this.myEntityManager.createQuery(sql, TagDefinition.class);
        List tagDefinitions = q.getResultList();
        return this.toMeta(tagDefinitions);
    }

    public IBaseBundle processMessage(RequestDetails theRequestDetails, IBaseBundle theMessage) {
        return JpaResourceDao.throwProcessMessageNotImplemented();
    }

    protected Meta toMeta(Collection<TagDefinition> tagDefinitions) {
        Meta retVal = new Meta();
        for (TagDefinition next : tagDefinitions) {
            switch (next.getTagType()) {
                case PROFILE: {
                    retVal.addProfile(next.getCode());
                    break;
                }
                case SECURITY_LABEL: {
                    retVal.addSecurity().setSystem(next.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
                    break;
                }
                case TAG: {
                    retVal.addTag().setSystem(next.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
                }
            }
        }
        return retVal;
    }
}

