/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.r5;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.dao.ITransactionProcessorVersionAdapter;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;

public class TransactionProcessorVersionAdapterR5
implements ITransactionProcessorVersionAdapter<Bundle, Bundle.BundleEntryComponent> {
    public void setResponseStatus(Bundle.BundleEntryComponent theBundleEntry, String theStatus) {
        theBundleEntry.getResponse().setStatus(theStatus);
    }

    public void setResponseLastModified(Bundle.BundleEntryComponent theBundleEntry, Date theLastModified) {
        theBundleEntry.getResponse().setLastModified(theLastModified);
    }

    public void setResource(Bundle.BundleEntryComponent theBundleEntry, IBaseResource theResource) {
        theBundleEntry.setResource((Resource)theResource);
    }

    public IBaseResource getResource(Bundle.BundleEntryComponent theBundleEntry) {
        return theBundleEntry.getResource();
    }

    public String getBundleType(Bundle theRequest) {
        if (theRequest.getType() == null) {
            return null;
        }
        return ((Bundle.BundleType)theRequest.getTypeElement().getValue()).toCode();
    }

    public void populateEntryWithOperationOutcome(BaseServerResponseException theCaughtEx, Bundle.BundleEntryComponent theEntry) {
        OperationOutcome oo = new OperationOutcome();
        oo.addIssue().setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics(theCaughtEx.getMessage()).setCode(OperationOutcome.IssueType.EXCEPTION);
        theEntry.getResponse().setOutcome((Resource)oo);
    }

    public Bundle createBundle(String theBundleType) {
        Bundle resp = new Bundle();
        try {
            resp.setType(Bundle.BundleType.fromCode((String)theBundleType));
        }
        catch (FHIRException theE) {
            throw new InternalErrorException(Msg.code((int)1125) + "Unknown bundle type: " + theBundleType);
        }
        return resp;
    }

    public List<Bundle.BundleEntryComponent> getEntries(Bundle theRequest) {
        return theRequest.getEntry();
    }

    public void addEntry(Bundle theBundle, Bundle.BundleEntryComponent theEntry) {
        theBundle.addEntry(theEntry);
    }

    public Bundle.BundleEntryComponent addEntry(Bundle theBundle) {
        return theBundle.addEntry();
    }

    public String getEntryRequestVerb(FhirContext theContext, Bundle.BundleEntryComponent theEntry) {
        String retVal = null;
        Bundle.HTTPVerb value = (Bundle.HTTPVerb)theEntry.getRequest().getMethodElement().getValue();
        if (value != null) {
            retVal = value.toCode();
        }
        return retVal;
    }

    public String getFullUrl(Bundle.BundleEntryComponent theEntry) {
        return theEntry.getFullUrl();
    }

    public void setFullUrl(Bundle.BundleEntryComponent theEntry, String theFullUrl) {
        theEntry.setFullUrl(theFullUrl);
    }

    public String getEntryIfNoneExist(Bundle.BundleEntryComponent theEntry) {
        return theEntry.getRequest().getIfNoneExist();
    }

    public String getEntryRequestUrl(Bundle.BundleEntryComponent theEntry) {
        return theEntry.getRequest().getUrl();
    }

    public void setResponseLocation(Bundle.BundleEntryComponent theEntry, String theResponseLocation) {
        theEntry.getResponse().setLocation(theResponseLocation);
    }

    public void setResponseETag(Bundle.BundleEntryComponent theEntry, String theEtag) {
        theEntry.getResponse().setEtag(theEtag);
    }

    public String getEntryRequestIfMatch(Bundle.BundleEntryComponent theEntry) {
        return theEntry.getRequest().getIfMatch();
    }

    public String getEntryRequestIfNoneExist(Bundle.BundleEntryComponent theEntry) {
        return theEntry.getRequest().getIfNoneExist();
    }

    public String getEntryRequestIfNoneMatch(Bundle.BundleEntryComponent theEntry) {
        return theEntry.getRequest().getIfNoneMatch();
    }

    public void setResponseOutcome(Bundle.BundleEntryComponent theEntry, IBaseOperationOutcome theOperationOutcome) {
        theEntry.getResponse().setOutcome((Resource)theOperationOutcome);
    }

    public void setRequestVerb(Bundle.BundleEntryComponent theEntry, String theVerb) {
        theEntry.getRequest().setMethod(Bundle.HTTPVerb.fromCode((String)theVerb));
    }

    public void setRequestUrl(Bundle.BundleEntryComponent theEntry, String theUrl) {
        theEntry.getRequest().setUrl(theUrl);
    }
}

