/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.dao.search.HSearchCompositeSearchIndexDataImpl;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.search.CompositeSearchIndexData;
import ca.uhn.fhir.jpa.model.search.DateSearchIndexData;
import ca.uhn.fhir.jpa.model.search.ExtendedHSearchIndexData;
import ca.uhn.fhir.jpa.model.search.QuantitySearchIndexData;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParamComposite;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.MetaUtil;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ExtendedHSearchIndexExtractor {
    private final JpaStorageSettings myJpaStorageSettings;
    private final FhirContext myContext;
    private final ResourceSearchParams myParams;
    private final ISearchParamExtractor mySearchParamExtractor;

    public ExtendedHSearchIndexExtractor(JpaStorageSettings theJpaStorageSettings, FhirContext theContext, ResourceSearchParams theActiveParams, ISearchParamExtractor theSearchParamExtractor) {
        this.myJpaStorageSettings = theJpaStorageSettings;
        this.myContext = theContext;
        this.myParams = theActiveParams;
        this.mySearchParamExtractor = theSearchParamExtractor;
    }

    @Nonnull
    public ExtendedHSearchIndexData extract(IBaseResource theResource, ResourceIndexedSearchParams theNewParams) {
        ExtendedHSearchIndexData retVal = new ExtendedHSearchIndexData(this.myContext, (StorageSettings)this.myJpaStorageSettings, theResource);
        if (this.myJpaStorageSettings.isStoreResourceInHSearchIndex()) {
            retVal.setRawResourceData(this.myContext.newJsonParser().encodeResourceToString(theResource));
        }
        retVal.setForcedId(theResource.getIdElement().getIdPart());
        this.extractAutocompleteTokens(theResource, retVal);
        theNewParams.myStringParams.stream().filter(nextParam -> !nextParam.isMissing()).forEach(nextParam -> retVal.addStringIndexData(nextParam.getParamName(), nextParam.getValueExact()));
        theNewParams.myTokenParams.stream().filter(nextParam -> !nextParam.isMissing()).forEach(nextParam -> retVal.addTokenIndexDataIfNotPresent(nextParam.getParamName(), nextParam.getSystem(), nextParam.getValue()));
        theNewParams.myNumberParams.stream().filter(nextParam -> !nextParam.isMissing()).forEach(nextParam -> retVal.addNumberIndexDataIfNotPresent(nextParam.getParamName(), nextParam.getValue()));
        theNewParams.myDateParams.stream().filter(nextParam -> !nextParam.isMissing()).forEach(nextParam -> retVal.addDateIndexData(nextParam.getParamName(), ExtendedHSearchIndexExtractor.convertDate(nextParam)));
        theNewParams.myQuantityParams.stream().filter(nextParam -> !nextParam.isMissing()).forEach(nextParam -> retVal.addQuantityIndexData(nextParam.getParamName(), ExtendedHSearchIndexExtractor.convertQuantity(nextParam)));
        theNewParams.myUriParams.stream().filter(nextParam -> !nextParam.isMissing()).forEach(nextParam -> retVal.addUriIndexData(nextParam.getParamName(), nextParam.getUri()));
        theResource.getMeta().getTag().forEach(tag -> retVal.addTokenIndexData("_tag", tag));
        theResource.getMeta().getSecurity().forEach(sec -> retVal.addTokenIndexData("_security", sec));
        theResource.getMeta().getProfile().forEach(prof -> retVal.addUriIndexData("_profile", (String)prof.getValue()));
        String source = MetaUtil.getSource((FhirContext)this.myContext, (IBaseMetaType)theResource.getMeta());
        if (StringUtils.isNotBlank((CharSequence)source)) {
            retVal.addUriIndexData("_source", source);
        }
        theNewParams.myCompositeParams.forEach(nextParam -> retVal.addCompositeIndexData(nextParam.getSearchParamName(), this.buildCompositeIndexData((ResourceIndexedSearchParamComposite)nextParam)));
        if (theResource.getMeta().getLastUpdated() != null) {
            int ordinal = ResourceIndexedSearchParamDate.calculateOrdinalValue((Date)theResource.getMeta().getLastUpdated()).intValue();
            retVal.addDateIndexData("_lastUpdated", theResource.getMeta().getLastUpdated(), ordinal, theResource.getMeta().getLastUpdated(), ordinal);
        }
        if (!theNewParams.myLinks.isEmpty()) {
            HashMap linkPathToParamName = new HashMap();
            for (String nextParamName : theNewParams.getPopulatedResourceLinkParameters()) {
                RuntimeSearchParam sp = this.myParams.get(nextParamName);
                List pathsSplit = sp.getPathsSplit();
                for (String nextPath : pathsSplit) {
                    nextPath = nextPath.toLowerCase(Locale.ROOT);
                    linkPathToParamName.computeIfAbsent(nextPath, p -> new ArrayList()).add(nextParamName);
                }
            }
            for (ResourceLink nextLink : theNewParams.getResourceLinks()) {
                String insensitivePath = nextLink.getSourcePath().toLowerCase(Locale.ROOT);
                List paramNames = linkPathToParamName.getOrDefault(insensitivePath, Collections.emptyList());
                for (String nextParamName : paramNames) {
                    Object qualifiedTargetResourceId = "";
                    if (!Strings.isNullOrEmpty((String)nextLink.getTargetResourceId())) {
                        qualifiedTargetResourceId = nextLink.getTargetResourceType() + "/" + nextLink.getTargetResourceId();
                    } else if (!Strings.isNullOrEmpty((String)nextLink.getTargetResourceUrl())) {
                        qualifiedTargetResourceId = nextLink.getTargetResourceUrl();
                    }
                    retVal.addResourceLinkIndexData(nextParamName, (String)qualifiedTargetResourceId);
                }
            }
        }
        return retVal;
    }

    @Nonnull
    private CompositeSearchIndexData buildCompositeIndexData(ResourceIndexedSearchParamComposite theSearchParamComposite) {
        return new HSearchCompositeSearchIndexDataImpl(theSearchParamComposite);
    }

    private void extractAutocompleteTokens(IBaseResource theResource, ExtendedHSearchIndexData theRetVal) {
        this.myParams.values().stream().filter(p -> p.getParamType() == RestSearchParameterTypeEnum.TOKEN).forEach(p -> this.mySearchParamExtractor.extractValues(p.getPath(), (IBase)theResource).forEach(nextValue -> this.indexTokenValue(theRetVal, (RuntimeSearchParam)p, (IBase)nextValue)));
    }

    private void indexTokenValue(ExtendedHSearchIndexData theRetVal, RuntimeSearchParam p, IBase nextValue) {
        String nextType = this.mySearchParamExtractor.toRootTypeName(nextValue);
        String spName = p.getName();
        switch (nextType) {
            case "CodeableConcept": {
                this.addToken_CodeableConcept(theRetVal, spName, nextValue);
                break;
            }
            case "Coding": {
                this.addToken_Coding(theRetVal, spName, (IBaseCoding)nextValue);
                break;
            }
        }
    }

    private void addToken_CodeableConcept(ExtendedHSearchIndexData theRetVal, String theSpName, IBase theValue) {
        List codings = this.mySearchParamExtractor.getCodingsFromCodeableConcept(theValue);
        for (IBase nextCoding : codings) {
            this.addToken_Coding(theRetVal, theSpName, (IBaseCoding)nextCoding);
        }
    }

    private void addToken_Coding(ExtendedHSearchIndexData theRetVal, String theSpName, IBaseCoding theNextValue) {
        theRetVal.addTokenIndexData(theSpName, theNextValue);
    }

    @Nonnull
    public static DateSearchIndexData convertDate(ResourceIndexedSearchParamDate nextParam) {
        return new DateSearchIndexData(nextParam.getValueLow(), nextParam.getValueLowDateOrdinal().intValue(), nextParam.getValueHigh(), nextParam.getValueHighDateOrdinal().intValue());
    }

    @Nonnull
    public static QuantitySearchIndexData convertQuantity(ResourceIndexedSearchParamQuantity nextParam) {
        return new QuantitySearchIndexData(nextParam.getUnits(), nextParam.getSystem(), nextParam.getValue().doubleValue());
    }
}

