/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.dao.search.ExtendedHSearchClauseBuilder;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.param.CompositeParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ExtendedHSearchSearchBuilder {
    public static final String EMPTY_MODIFIER = "";
    public static final Set<String> ourUnsafeSearchParmeters = Sets.newHashSet((Object[])new String[]{"_id", "_meta"});

    public boolean isSupportsSomeOf(SearchParameterMap myParams) {
        return myParams.getSort() != null || myParams.getLastUpdated() != null || myParams.entrySet().stream().filter(e -> !ourUnsafeSearchParmeters.contains(e.getKey())).flatMap(andList -> ((List)andList.getValue()).stream()).flatMap(Collection::stream).anyMatch(this::isParamTypeSupported);
    }

    public boolean isSupportsAllOf(SearchParameterMap myParams) {
        return CollectionUtils.isEmpty((Collection)myParams.getRevIncludes()) && CollectionUtils.isEmpty((Collection)myParams.getIncludes()) && myParams.getEverythingMode() == null && BooleanUtils.isFalse((Boolean)myParams.isDeleteExpunge()) && myParams.getNearDistanceParam() == null && myParams.getSearchContainedMode() == SearchContainedModeEnum.FALSE && myParams.entrySet().stream().filter(e -> !ourUnsafeSearchParmeters.contains(e.getKey())).flatMap(andList -> ((List)andList.getValue()).stream()).flatMap(Collection::stream).allMatch(this::isParamTypeSupported);
    }

    private boolean isParamTypeSupported(IQueryParameterType param) {
        String modifier = StringUtils.defaultString((String)param.getQueryParameterQualifier(), (String)EMPTY_MODIFIER);
        if (param instanceof TokenParam) {
            switch (modifier) {
                case ":text": 
                case "": {
                    return true;
                }
            }
            return false;
        }
        if (param instanceof StringParam) {
            switch (modifier) {
                case ":text": 
                case ":exact": 
                case ":contains": 
                case "": {
                    return true;
                }
            }
            return false;
        }
        if (param instanceof QuantityParam) {
            return modifier.equals(EMPTY_MODIFIER);
        }
        if (param instanceof CompositeParam) {
            switch (modifier) {
                case ":missing": {
                    return false;
                }
            }
            return true;
        }
        if (param instanceof ReferenceParam) {
            if (((ReferenceParam)param).getChain() != null) {
                return false;
            }
            switch (modifier) {
                case "": {
                    return true;
                }
            }
            return false;
        }
        if (param instanceof DateParam) {
            return modifier.equals(EMPTY_MODIFIER);
        }
        if (param instanceof UriParam) {
            return modifier.equals(EMPTY_MODIFIER);
        }
        if (param instanceof NumberParam) {
            return modifier.equals(EMPTY_MODIFIER);
        }
        return false;
    }

    public void addAndConsumeAdvancedQueryClauses(ExtendedHSearchClauseBuilder builder, String theResourceType, SearchParameterMap theParams, ISearchParamRegistry theSearchParamRegistry) {
        ArrayList<String> paramNames = this.compileParamNames(theParams);
        for (String nextParam : paramNames) {
            RuntimeSearchParam activeParam;
            if (ourUnsafeSearchParmeters.contains(nextParam) || (activeParam = theSearchParamRegistry.getActiveSearchParam(theResourceType, nextParam)) == null) continue;
            switch (activeParam.getParamType()) {
                case TOKEN: {
                    List tokenTextAndOrTerms = theParams.removeByNameAndModifier(nextParam, ":text");
                    builder.addStringTextSearch(nextParam, tokenTextAndOrTerms);
                    List tokenUnmodifiedAndOrTerms = theParams.removeByNameUnmodified(nextParam);
                    builder.addTokenUnmodifiedSearch(nextParam, tokenUnmodifiedAndOrTerms);
                    break;
                }
                case STRING: {
                    List stringTextAndOrTerms = theParams.removeByNameAndModifier(nextParam, ":text");
                    builder.addStringTextSearch(nextParam, stringTextAndOrTerms);
                    List stringExactAndOrTerms = theParams.removeByNameAndModifier(nextParam, ":exact");
                    builder.addStringExactSearch(nextParam, stringExactAndOrTerms);
                    List stringContainsAndOrTerms = theParams.removeByNameAndModifier(nextParam, ":contains");
                    builder.addStringContainsSearch(nextParam, stringContainsAndOrTerms);
                    List stringAndOrTerms = theParams.removeByNameUnmodified(nextParam);
                    builder.addStringUnmodifiedSearch(nextParam, stringAndOrTerms);
                    break;
                }
                case QUANTITY: {
                    List quantityAndOrTerms = theParams.removeByNameUnmodified(nextParam);
                    builder.addQuantityUnmodifiedSearch(nextParam, quantityAndOrTerms);
                    break;
                }
                case REFERENCE: {
                    List referenceAndOrTerms = theParams.removeByNameUnmodified(nextParam);
                    builder.addReferenceUnchainedSearch(nextParam, referenceAndOrTerms);
                    break;
                }
                case DATE: {
                    List dateAndOrTerms = nextParam.equalsIgnoreCase("_lastupdated") ? this.getLastUpdatedAndOrList(theParams) : theParams.removeByNameUnmodified(nextParam);
                    builder.addDateUnmodifiedSearch(nextParam, dateAndOrTerms);
                    break;
                }
                case COMPOSITE: {
                    List compositeAndOrTerms = theParams.removeByNameUnmodified(nextParam);
                    List subSearchParams = JpaParamUtil.resolveCompositeComponentsDeclaredOrder((ISearchParamRegistry)theSearchParamRegistry, (RuntimeSearchParam)activeParam);
                    builder.addCompositeUnmodifiedSearch(activeParam, subSearchParams, compositeAndOrTerms);
                    break;
                }
                case URI: {
                    List uriUnmodifiedAndOrTerms = theParams.removeByNameUnmodified(nextParam);
                    builder.addUriUnmodifiedSearch(nextParam, uriUnmodifiedAndOrTerms);
                    break;
                }
                case NUMBER: {
                    List numberUnmodifiedAndOrTerms = theParams.remove(nextParam);
                    builder.addNumberUnmodifiedSearch(nextParam, numberUnmodifiedAndOrTerms);
                    break;
                }
            }
        }
    }

    private List<List<IQueryParameterType>> getLastUpdatedAndOrList(SearchParameterMap theParams) {
        DateParam activeBound = theParams.getLastUpdated().getLowerBound() != null ? theParams.getLastUpdated().getLowerBound() : theParams.getLastUpdated().getUpperBound();
        List<List<IQueryParameterType>> result = List.of(List.of(activeBound));
        theParams.setLastUpdated(null);
        return result;
    }

    private ArrayList<String> compileParamNames(SearchParameterMap theParams) {
        ArrayList nameList = Lists.newArrayList((Iterable)theParams.keySet());
        if (theParams.getLastUpdated() != null) {
            nameList.add("_lastUpdated");
        }
        return nameList;
    }
}

