/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.jpa.dao.search.ExtendedHSearchIndexExtractor;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.search.CompositeSearchIndexData;
import ca.uhn.fhir.jpa.model.search.HSearchElementCache;
import ca.uhn.fhir.jpa.model.search.HSearchIndexWriter;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParamComposite;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.util.ObjectUtil;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hl7.fhir.instance.model.api.IBaseCoding;

class HSearchCompositeSearchIndexDataImpl
implements CompositeSearchIndexData {
    final ResourceIndexedSearchParamComposite mySearchParamComposite;

    public HSearchCompositeSearchIndexDataImpl(ResourceIndexedSearchParamComposite theSearchParamComposite) {
        this.mySearchParamComposite = theSearchParamComposite;
    }

    public void writeIndexEntry(HSearchIndexWriter theHSearchIndexWriter, HSearchElementCache theRoot) {
        boolean hasAnEmptyComponent = this.mySearchParamComposite.getComponents().stream().anyMatch(c -> c.getParamIndexValues().isEmpty());
        if (hasAnEmptyComponent) {
            return;
        }
        DocumentElement nestedParamRoot = theRoot.getObjectElement(new String[]{"nsp"});
        DocumentElement compositeRoot = nestedParamRoot.addObject(this.mySearchParamComposite.getSearchParamName());
        for (ResourceIndexedSearchParamComposite.Component subParam : this.mySearchParamComposite.getComponents()) {
            DocumentElement subParamElement = compositeRoot.addObject(subParam.getSearchParamName());
            switch (subParam.getSearchParameterType()) {
                case DATE: {
                    DocumentElement dateElement = subParamElement.addObject("dt");
                    subParam.getParamIndexValues().stream().flatMap(o -> ObjectUtil.castIfInstanceof((Object)o, ResourceIndexedSearchParamDate.class).stream()).map(ExtendedHSearchIndexExtractor::convertDate).forEach(d -> theHSearchIndexWriter.writeDateFields(dateElement, d));
                    break;
                }
                case QUANTITY: {
                    DocumentElement quantityElement = subParamElement.addObject("quantity");
                    subParam.getParamIndexValues().stream().flatMap(o -> ObjectUtil.castIfInstanceof((Object)o, ResourceIndexedSearchParamQuantity.class).stream()).map(ExtendedHSearchIndexExtractor::convertQuantity).forEach(q -> theHSearchIndexWriter.writeQuantityFields(quantityElement, q));
                    break;
                }
                case STRING: {
                    DocumentElement stringElement = subParamElement.addObject("string");
                    subParam.getParamIndexValues().stream().flatMap(o -> ObjectUtil.castIfInstanceof((Object)o, ResourceIndexedSearchParamString.class).stream()).forEach(risps -> theHSearchIndexWriter.writeBasicStringFields(stringElement, risps.getValueExact()));
                    break;
                }
                case TOKEN: {
                    DocumentElement tokenElement = subParamElement.addObject("token");
                    subParam.getParamIndexValues().stream().flatMap(o -> ObjectUtil.castIfInstanceof((Object)o, ResourceIndexedSearchParamToken.class).stream()).forEach(rispt -> theHSearchIndexWriter.writeTokenFields(tokenElement, (IBaseCoding)new Tag(rispt.getSystem(), rispt.getValue())));
                    break;
                }
                case URI: {
                    subParam.getParamIndexValues().stream().flatMap(o -> ObjectUtil.castIfInstanceof((Object)o, ResourceIndexedSearchParamUri.class).stream()).forEach(rispu -> theHSearchIndexWriter.writeUriFields(subParamElement, rispu.getUri()));
                    break;
                }
                case NUMBER: {
                    subParam.getParamIndexValues().stream().flatMap(o -> ObjectUtil.castIfInstanceof((Object)o, ResourceIndexedSearchParamNumber.class).stream()).forEach(rispn -> theHSearchIndexWriter.writeNumberFields(subParamElement, rispn.getValue()));
                    break;
                }
                case COMPOSITE: {
                    assert (false) : "composite components can't be composite";
                    break;
                }
                case REFERENCE: {
                    break;
                }
            }
        }
    }
}

