/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.batch2.model.StatusEnum;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="BT2_JOB_INSTANCE", indexes={@Index(name="IDX_BT2JI_CT", columnList="CREATE_TIME")})
public class Batch2JobInstanceEntity
implements Serializable {
    public static final int STATUS_MAX_LENGTH = 20;
    public static final int TIME_REMAINING_LENGTH = 100;
    public static final int PARAMS_JSON_MAX_LENGTH = 2000;
    private static final long serialVersionUID = 8187134261799095422L;
    @Id
    @Column(name="ID", length=100, nullable=false)
    private String myId;
    @Column(name="CREATE_TIME", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myCreateTime;
    @Column(name="START_TIME", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myStartTime;
    @Column(name="END_TIME", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myEndTime;
    @Version
    @Column(name="UPDATE_TIME", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myUpdateTime;
    @Column(name="DEFINITION_ID", length=100, nullable=false)
    private String myDefinitionId;
    @Column(name="DEFINITION_VER", nullable=false)
    private int myDefinitionVersion;
    @Column(name="STAT", length=20, nullable=false)
    @Enumerated(value=EnumType.STRING)
    private StatusEnum myStatus;
    @Column(name="JOB_CANCELLED", nullable=false)
    private boolean myCancelled;
    @Column(name="FAST_TRACKING", nullable=true)
    private Boolean myFastTracking;
    @Column(name="PARAMS_JSON", length=2000, nullable=true)
    private String myParamsJson;
    @Lob
    @Column(name="PARAMS_JSON_LOB", nullable=true)
    private String myParamsJsonLob;
    @Column(name="CMB_RECS_PROCESSED", nullable=true)
    private Integer myCombinedRecordsProcessed;
    @Column(name="CMB_RECS_PER_SEC", nullable=true)
    private Double myCombinedRecordsProcessedPerSecond;
    @Column(name="TOT_ELAPSED_MILLIS", nullable=true)
    private Integer myTotalElapsedMillis;
    @Column(name="WORK_CHUNKS_PURGED", nullable=false)
    private boolean myWorkChunksPurged;
    @Column(name="PROGRESS_PCT")
    private double myProgress;
    @Column(name="ERROR_MSG", length=500, nullable=true)
    private String myErrorMessage;
    @Column(name="ERROR_COUNT")
    private int myErrorCount;
    @Column(name="EST_REMAINING", length=100, nullable=true)
    private String myEstimatedTimeRemaining;
    @Column(name="CUR_GATED_STEP_ID", length=100, nullable=true)
    private String myCurrentGatedStepId;
    @Column(name="WARNING_MSG", length=4000, nullable=true)
    private String myWarningMessages;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="REPORT", nullable=true, length=0x7FFFFFFE)
    private String myReport;

    public String getCurrentGatedStepId() {
        return this.myCurrentGatedStepId;
    }

    public void setCurrentGatedStepId(String theCurrentGatedStepId) {
        this.myCurrentGatedStepId = theCurrentGatedStepId;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }

    public void setCancelled(boolean theCancelled) {
        this.myCancelled = theCancelled;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public void setErrorCount(int theErrorCount) {
        this.myErrorCount = theErrorCount;
    }

    public Integer getTotalElapsedMillis() {
        return this.myTotalElapsedMillis;
    }

    public void setTotalElapsedMillis(Integer theTotalElapsedMillis) {
        this.myTotalElapsedMillis = theTotalElapsedMillis;
    }

    public Integer getCombinedRecordsProcessed() {
        return this.myCombinedRecordsProcessed;
    }

    public void setCombinedRecordsProcessed(Integer theCombinedRecordsProcessed) {
        this.myCombinedRecordsProcessed = theCombinedRecordsProcessed;
    }

    public Double getCombinedRecordsProcessedPerSecond() {
        return this.myCombinedRecordsProcessedPerSecond;
    }

    public void setCombinedRecordsProcessedPerSecond(Double theCombinedRecordsProcessedPerSecond) {
        this.myCombinedRecordsProcessedPerSecond = theCombinedRecordsProcessedPerSecond;
    }

    public Date getCreateTime() {
        return this.myCreateTime;
    }

    public void setCreateTime(Date theCreateTime) {
        this.myCreateTime = theCreateTime;
    }

    public Date getStartTime() {
        return this.myStartTime;
    }

    public void setStartTime(Date theStartTime) {
        this.myStartTime = theStartTime;
    }

    public Date getEndTime() {
        return this.myEndTime;
    }

    public void setEndTime(Date theEndTime) {
        this.myEndTime = theEndTime;
    }

    public void setUpdateTime(Date theTime) {
        this.myUpdateTime = theTime;
    }

    public Date getUpdateTime() {
        return this.myUpdateTime;
    }

    public String getId() {
        return this.myId;
    }

    public void setId(String theId) {
        this.myId = theId;
    }

    public String getDefinitionId() {
        return this.myDefinitionId;
    }

    public void setDefinitionId(String theDefinitionId) {
        this.myDefinitionId = theDefinitionId;
    }

    public int getDefinitionVersion() {
        return this.myDefinitionVersion;
    }

    public void setDefinitionVersion(int theDefinitionVersion) {
        this.myDefinitionVersion = theDefinitionVersion;
    }

    public StatusEnum getStatus() {
        return this.myStatus;
    }

    public void setStatus(StatusEnum theStatus) {
        this.myStatus = theStatus;
    }

    public String getParams() {
        if (this.myParamsJsonLob != null) {
            return this.myParamsJsonLob;
        }
        return this.myParamsJson;
    }

    public void setParams(String theParams) {
        this.myParamsJsonLob = null;
        this.myParamsJson = null;
        if (theParams != null && theParams.length() > 2000) {
            this.myParamsJsonLob = theParams;
        } else {
            this.myParamsJson = theParams;
        }
    }

    public boolean getWorkChunksPurged() {
        return this.myWorkChunksPurged;
    }

    public void setWorkChunksPurged(boolean theWorkChunksPurged) {
        this.myWorkChunksPurged = theWorkChunksPurged;
    }

    public double getProgress() {
        return this.myProgress;
    }

    public void setProgress(double theProgress) {
        this.myProgress = theProgress;
    }

    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public void setErrorMessage(String theErrorMessage) {
        this.myErrorMessage = StringUtils.left((String)theErrorMessage, (int)500);
    }

    public String getEstimatedTimeRemaining() {
        return this.myEstimatedTimeRemaining;
    }

    public void setEstimatedTimeRemaining(String theEstimatedTimeRemaining) {
        this.myEstimatedTimeRemaining = StringUtils.left((String)theEstimatedTimeRemaining, (int)100);
    }

    public String getReport() {
        return this.myReport;
    }

    public void setReport(String theReport) {
        this.myReport = theReport;
    }

    public String getWarningMessages() {
        return this.myWarningMessages;
    }

    public void setWarningMessages(String theWarningMessages) {
        this.myWarningMessages = theWarningMessages;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.myId).append("definitionId", (Object)this.myDefinitionId).append("definitionVersion", this.myDefinitionVersion).append("errorCount", this.myErrorCount).append("createTime", (Object)this.myCreateTime).append("startTime", (Object)this.myStartTime).append("endTime", (Object)this.myEndTime).append("updateTime", (Object)this.myUpdateTime).append("status", (Object)this.myStatus).append("cancelled", this.myCancelled).append("combinedRecordsProcessed", (Object)this.myCombinedRecordsProcessed).append("combinedRecordsProcessedPerSecond", (Object)this.myCombinedRecordsProcessedPerSecond).append("totalElapsedMillis", (Object)this.myTotalElapsedMillis).append("workChunksPurged", this.myWorkChunksPurged).append("progress", this.myProgress).append("errorMessage", (Object)this.myErrorMessage).append("estimatedTimeRemaining", (Object)this.myEstimatedTimeRemaining).append("report", (Object)this.myReport).append("warningMessages", (Object)this.myWarningMessages).toString();
    }

    public boolean isFastTracking() {
        if (this.myFastTracking == null) {
            this.myFastTracking = false;
        }
        return this.myFastTracking;
    }

    public void setFastTracking(boolean theFastTracking) {
        this.myFastTracking = theFastTracking;
    }
}

