/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.batch2.model.WorkChunkStatusEnum;
import ca.uhn.fhir.jpa.entity.Batch2JobInstanceEntity;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="BT2_WORK_CHUNK", indexes={@Index(name="IDX_BT2WC_II_SEQ", columnList="INSTANCE_ID,SEQ")})
public class Batch2WorkChunkEntity
implements Serializable {
    public static final int ERROR_MSG_MAX_LENGTH = 500;
    public static final int WARNING_MSG_MAX_LENGTH = 4000;
    private static final long serialVersionUID = -6202771941965780558L;
    @Id
    @Column(name="ID", length=100)
    private String myId;
    @Column(name="SEQ", nullable=false)
    private int mySequence;
    @Column(name="CREATE_TIME", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myCreateTime;
    @Column(name="START_TIME", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myStartTime;
    @Column(name="END_TIME", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myEndTime;
    @Version
    @Column(name="UPDATE_TIME", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date myUpdateTime;
    @Column(name="RECORDS_PROCESSED", nullable=true)
    private Integer myRecordsProcessed;
    @Column(name="DEFINITION_ID", length=100, nullable=false)
    private String myJobDefinitionId;
    @Column(name="DEFINITION_VER", length=100, nullable=false)
    private int myJobDefinitionVersion;
    @Column(name="TGT_STEP_ID", length=100, nullable=false)
    private String myTargetStepId;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="CHUNK_DATA", nullable=true, length=0x7FFFFFFE)
    private String mySerializedData;
    @Column(name="STAT", length=20, nullable=false)
    @Enumerated(value=EnumType.STRING)
    private WorkChunkStatusEnum myStatus;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="INSTANCE_ID", insertable=false, updatable=false, foreignKey=@ForeignKey(name="FK_BT2WC_INSTANCE"))
    private Batch2JobInstanceEntity myInstance;
    @Column(name="INSTANCE_ID", length=100, nullable=false)
    private String myInstanceId;
    @Column(name="ERROR_MSG", length=500, nullable=true)
    private String myErrorMessage;
    @Column(name="ERROR_COUNT", nullable=false)
    private int myErrorCount;
    @Column(name="WARNING_MSG", length=4000, nullable=true)
    private String myWarningMessage;

    public Batch2WorkChunkEntity() {
    }

    public Batch2WorkChunkEntity(String theId, int theSequence, String theJobDefinitionId, int theJobDefinitionVersion, String theInstanceId, String theTargetStepId, WorkChunkStatusEnum theStatus, Date theCreateTime, Date theStartTime, Date theUpdateTime, Date theEndTime, String theErrorMessage, int theErrorCount, Integer theRecordsProcessed, String theWarningMessage) {
        this.myId = theId;
        this.mySequence = theSequence;
        this.myJobDefinitionId = theJobDefinitionId;
        this.myJobDefinitionVersion = theJobDefinitionVersion;
        this.myInstanceId = theInstanceId;
        this.myTargetStepId = theTargetStepId;
        this.myStatus = theStatus;
        this.myCreateTime = theCreateTime;
        this.myStartTime = theStartTime;
        this.myUpdateTime = theUpdateTime;
        this.myEndTime = theEndTime;
        this.myErrorMessage = theErrorMessage;
        this.myErrorCount = theErrorCount;
        this.myRecordsProcessed = theRecordsProcessed;
        this.myWarningMessage = theWarningMessage;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public void setErrorCount(int theErrorCount) {
        this.myErrorCount = theErrorCount;
    }

    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public void setErrorMessage(String theErrorMessage) {
        this.myErrorMessage = StringUtils.left((String)theErrorMessage, (int)500);
    }

    public String getWarningMessage() {
        return this.myWarningMessage;
    }

    public void setWarningMessage(String theWarningMessage) {
        this.myWarningMessage = theWarningMessage;
    }

    public int getSequence() {
        return this.mySequence;
    }

    public void setSequence(int theSequence) {
        this.mySequence = theSequence;
    }

    public Date getCreateTime() {
        return this.myCreateTime;
    }

    public void setCreateTime(Date theCreateTime) {
        this.myCreateTime = theCreateTime;
    }

    public Date getStartTime() {
        return this.myStartTime;
    }

    public void setStartTime(Date theStartTime) {
        this.myStartTime = theStartTime;
    }

    public Date getEndTime() {
        return this.myEndTime;
    }

    public void setEndTime(Date theEndTime) {
        this.myEndTime = theEndTime;
    }

    public Date getUpdateTime() {
        return this.myUpdateTime;
    }

    public Integer getRecordsProcessed() {
        return this.myRecordsProcessed;
    }

    public void setRecordsProcessed(Integer theRecordsProcessed) {
        this.myRecordsProcessed = theRecordsProcessed;
    }

    public Batch2JobInstanceEntity getInstance() {
        return this.myInstance;
    }

    public void setInstance(Batch2JobInstanceEntity theInstance) {
        this.myInstance = theInstance;
    }

    public String getJobDefinitionId() {
        return this.myJobDefinitionId;
    }

    public void setJobDefinitionId(String theJobDefinitionId) {
        this.myJobDefinitionId = theJobDefinitionId;
    }

    public int getJobDefinitionVersion() {
        return this.myJobDefinitionVersion;
    }

    public void setJobDefinitionVersion(int theJobDefinitionVersion) {
        this.myJobDefinitionVersion = theJobDefinitionVersion;
    }

    public String getTargetStepId() {
        return this.myTargetStepId;
    }

    public void setTargetStepId(String theTargetStepId) {
        this.myTargetStepId = theTargetStepId;
    }

    public String getSerializedData() {
        return this.mySerializedData;
    }

    public void setSerializedData(String theSerializedData) {
        this.mySerializedData = theSerializedData;
    }

    public WorkChunkStatusEnum getStatus() {
        return this.myStatus;
    }

    public void setStatus(WorkChunkStatusEnum theStatus) {
        this.myStatus = theStatus;
    }

    public String getId() {
        return this.myId;
    }

    public void setId(String theId) {
        this.myId = theId;
    }

    public String getInstanceId() {
        return this.myInstanceId;
    }

    public void setInstanceId(String theInstanceId) {
        this.myInstanceId = theInstanceId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.myId).append("instanceId", (Object)this.myInstanceId).append("sequence", this.mySequence).append("errorCount", this.myErrorCount).append("jobDefinitionId", (Object)this.myJobDefinitionId).append("jobDefinitionVersion", this.myJobDefinitionVersion).append("createTime", (Object)this.myCreateTime).append("startTime", (Object)this.myStartTime).append("endTime", (Object)this.myEndTime).append("updateTime", (Object)this.myUpdateTime).append("recordsProcessed", (Object)this.myRecordsProcessed).append("targetStepId", (Object)this.myTargetStepId).append("serializedData", (Object)this.mySerializedData).append("status", (Object)this.myStatus).append("errorMessage", (Object)this.myErrorMessage).append("warningMessage", (Object)this.myWarningMessage).toString();
    }
}

