/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobJson;
import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobStatusEnum;
import ca.uhn.fhir.jpa.bulk.imprt.model.JobFileRowProcessingModeEnum;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="HFJ_BLK_IMPORT_JOB", uniqueConstraints={@UniqueConstraint(name="IDX_BLKIM_JOB_ID", columnNames={"JOB_ID"})})
public class BulkImportJobEntity
implements Serializable {
    public static final String HFJ_BLK_IMPORT_JOB = "HFJ_BLK_IMPORT_JOB";
    public static final String JOB_ID = "JOB_ID";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_BLKIMJOB_PID")
    @SequenceGenerator(name="SEQ_BLKIMJOB_PID", sequenceName="SEQ_BLKIMJOB_PID")
    @Column(name="PID")
    private Long myId;
    @Column(name="JOB_ID", length=36, nullable=false, updatable=false)
    private String myJobId;
    @Column(name="JOB_DESC", nullable=true, length=500)
    private String myJobDescription;
    @Enumerated(value=EnumType.STRING)
    @Column(name="JOB_STATUS", length=10, nullable=false)
    private BulkImportJobStatusEnum myStatus;
    @Version
    @Column(name="OPTLOCK", nullable=false)
    private int myVersion;
    @Column(name="FILE_COUNT", nullable=false)
    private int myFileCount;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="STATUS_TIME", nullable=false)
    private Date myStatusTime;
    @Column(name="STATUS_MESSAGE", nullable=true, length=500)
    private String myStatusMessage;
    @Column(name="ROW_PROCESSING_MODE", length=20, nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private JobFileRowProcessingModeEnum myRowProcessingMode;
    @Column(name="BATCH_SIZE", nullable=false, updatable=false)
    private int myBatchSize;

    public String getJobDescription() {
        return this.myJobDescription;
    }

    public void setJobDescription(String theJobDescription) {
        this.myJobDescription = StringUtils.left((String)theJobDescription, (int)500);
    }

    public JobFileRowProcessingModeEnum getRowProcessingMode() {
        return this.myRowProcessingMode;
    }

    public void setRowProcessingMode(JobFileRowProcessingModeEnum theRowProcessingMode) {
        this.myRowProcessingMode = theRowProcessingMode;
    }

    public Date getStatusTime() {
        return this.myStatusTime;
    }

    public void setStatusTime(Date theStatusTime) {
        this.myStatusTime = theStatusTime;
    }

    public int getFileCount() {
        return this.myFileCount;
    }

    public void setFileCount(int theFileCount) {
        this.myFileCount = theFileCount;
    }

    public String getJobId() {
        return this.myJobId;
    }

    public void setJobId(String theJobId) {
        this.myJobId = theJobId;
    }

    public BulkImportJobStatusEnum getStatus() {
        return this.myStatus;
    }

    public void setStatus(BulkImportJobStatusEnum theStatus) {
        if (this.myStatus != theStatus) {
            this.myStatus = theStatus;
            this.setStatusTime(new Date());
            this.setStatusMessage(null);
        }
    }

    public String getStatusMessage() {
        return this.myStatusMessage;
    }

    public void setStatusMessage(String theStatusMessage) {
        this.myStatusMessage = StringUtils.left((String)theStatusMessage, (int)500);
    }

    public BulkImportJobJson toJson() {
        return new BulkImportJobJson().setProcessingMode(this.getRowProcessingMode()).setFileCount(this.getFileCount()).setJobDescription(this.getJobDescription());
    }

    public int getBatchSize() {
        return this.myBatchSize;
    }

    public void setBatchSize(int theBatchSize) {
        this.myBatchSize = theBatchSize;
    }
}

