/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.bulk.imprt.model.BulkImportJobFileJson;
import ca.uhn.fhir.jpa.entity.BulkImportJobEntity;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="HFJ_BLK_IMPORT_JOBFILE", indexes={@Index(name="IDX_BLKIM_JOBFILE_JOBID", columnList="JOB_PID")})
public class BulkImportJobFileEntity
implements Serializable {
    public static final int MAX_DESCRIPTION_LENGTH = 500;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_BLKIMJOBFILE_PID")
    @SequenceGenerator(name="SEQ_BLKIMJOBFILE_PID", sequenceName="SEQ_BLKIMJOBFILE_PID")
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="JOB_PID", referencedColumnName="PID", nullable=false, foreignKey=@ForeignKey(name="FK_BLKIMJOBFILE_JOB"))
    private BulkImportJobEntity myJob;
    @Column(name="FILE_SEQ", nullable=false)
    private int myFileSequence;
    @Column(name="FILE_DESCRIPTION", nullable=true, length=500)
    private String myFileDescription;
    @Lob
    @Column(name="JOB_CONTENTS", nullable=false)
    private byte[] myContents;
    @Column(name="TENANT_NAME", nullable=true, length=200)
    private String myTenantName;

    public String getFileDescription() {
        return this.myFileDescription;
    }

    public void setFileDescription(String theFileDescription) {
        this.myFileDescription = StringUtils.left((String)theFileDescription, (int)500);
    }

    public BulkImportJobEntity getJob() {
        return this.myJob;
    }

    public void setJob(BulkImportJobEntity theJob) {
        this.myJob = theJob;
    }

    public int getFileSequence() {
        return this.myFileSequence;
    }

    public void setFileSequence(int theFileSequence) {
        this.myFileSequence = theFileSequence;
    }

    public String getContents() {
        return new String(this.myContents, StandardCharsets.UTF_8);
    }

    public void setContents(String theContents) {
        this.myContents = theContents.getBytes(StandardCharsets.UTF_8);
    }

    public BulkImportJobFileJson toJson() {
        return new BulkImportJobFileJson().setContents(this.getContents()).setTenantName(this.getTenantName());
    }

    public String getTenantName() {
        return this.myTenantName;
    }

    public void setTenantName(String theTenantName) {
        this.myTenantName = theTenantName;
    }
}

