/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.entity.SearchInclude;
import ca.uhn.fhir.jpa.entity.SearchTypeEnum;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HistorySearchStyleEnum;
import ca.uhn.fhir.rest.server.util.ICachedSearchDetails;
import ca.uhn.fhir.system.HapiSystemProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.OptimisticLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="HFJ_SEARCH", uniqueConstraints={@UniqueConstraint(name="IDX_SEARCH_UUID", columnNames={"SEARCH_UUID"})}, indexes={@Index(name="IDX_SEARCH_RESTYPE_HASHS", columnList="RESOURCE_TYPE,SEARCH_QUERY_STRING_HASH,CREATED"), @Index(name="IDX_SEARCH_CREATED", columnList="CREATED")})
public class Search
implements ICachedSearchDetails,
Serializable {
    public static final int SEARCH_UUID_COLUMN_LENGTH = 48;
    public static final String HFJ_SEARCH = "HFJ_SEARCH";
    private static final int MAX_SEARCH_QUERY_STRING = 10000;
    private static final int FAILURE_MESSAGE_LENGTH = 500;
    private static final long serialVersionUID = 1L;
    private static final Logger ourLog = LoggerFactory.getLogger(Search.class);
    public static final String SEARCH_UUID = "SEARCH_UUID";
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED", nullable=false, updatable=false)
    private Date myCreated;
    @OptimisticLock(excluded=true)
    @Column(name="SEARCH_DELETED", nullable=true)
    private Boolean myDeleted;
    @Column(name="FAILURE_CODE", nullable=true)
    private Integer myFailureCode;
    @Column(name="FAILURE_MESSAGE", length=500, nullable=true)
    private String myFailureMessage;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="EXPIRY_OR_NULL", nullable=true)
    private Date myExpiryOrNull;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SEARCH")
    @SequenceGenerator(name="SEQ_SEARCH", sequenceName="SEQ_SEARCH")
    @Column(name="PID")
    private Long myId;
    @OneToMany(mappedBy="mySearch", cascade={CascadeType.ALL})
    private Collection<SearchInclude> myIncludes;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LAST_UPDATED_HIGH", nullable=true, insertable=true, updatable=false)
    private Date myLastUpdatedHigh;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LAST_UPDATED_LOW", nullable=true, insertable=true, updatable=false)
    private Date myLastUpdatedLow;
    @Column(name="NUM_FOUND", nullable=false)
    private int myNumFound;
    @Column(name="NUM_BLOCKED", nullable=true)
    private Integer myNumBlocked;
    @Column(name="PREFERRED_PAGE_SIZE", nullable=true)
    private Integer myPreferredPageSize;
    @Column(name="RESOURCE_ID", nullable=true)
    private Long myResourceId;
    @Column(name="RESOURCE_TYPE", length=200, nullable=true)
    private String myResourceType;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="SEARCH_QUERY_STRING", nullable=true, updatable=false, length=10000)
    private String mySearchQueryString;
    @Column(name="SEARCH_QUERY_STRING_HASH", nullable=true, updatable=false)
    private Integer mySearchQueryStringHash;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="SEARCH_TYPE", nullable=false)
    private SearchTypeEnum mySearchType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="SEARCH_STATUS", nullable=false, length=10)
    private SearchStatusEnum myStatus;
    @Column(name="TOTAL_COUNT", nullable=true)
    private Integer myTotalCount;
    @Column(name="SEARCH_UUID", length=48, nullable=false, updatable=false)
    private String myUuid;
    @Version
    @Column(name="OPTLOCK_VERSION", nullable=true)
    private Integer myVersion;
    @Lob
    @Column(name="SEARCH_PARAM_MAP", nullable=true)
    private byte[] mySearchParameterMap;
    @Transient
    private transient SearchParameterMap mySearchParameterMapTransient;
    @Transient
    private Integer myOffset;
    @Transient
    private Integer mySizeModeSize;
    @Transient
    private HistorySearchStyleEnum myHistorySearchStyle;

    public Integer getSizeModeSize() {
        return this.mySizeModeSize;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("myLastUpdatedHigh", (Object)this.myLastUpdatedHigh).append("myLastUpdatedLow", (Object)this.myLastUpdatedLow).append("myNumFound", this.myNumFound).append("myNumBlocked", (Object)this.myNumBlocked).append("myStatus", (Object)this.myStatus).append("myTotalCount", (Object)this.myTotalCount).append("myUuid", (Object)this.myUuid).append("myVersion", (Object)this.myVersion).toString();
    }

    public int getNumBlocked() {
        return this.myNumBlocked != null ? this.myNumBlocked : 0;
    }

    public void setNumBlocked(int theNumBlocked) {
        this.myNumBlocked = theNumBlocked;
    }

    public Date getExpiryOrNull() {
        return this.myExpiryOrNull;
    }

    public void setExpiryOrNull(Date theExpiryOrNull) {
        this.myExpiryOrNull = theExpiryOrNull;
    }

    public Boolean getDeleted() {
        return this.myDeleted;
    }

    public void setDeleted(Boolean theDeleted) {
        this.myDeleted = theDeleted;
    }

    public Date getCreated() {
        return this.myCreated;
    }

    public void setCreated(Date theCreated) {
        this.myCreated = theCreated;
    }

    public Integer getFailureCode() {
        return this.myFailureCode;
    }

    public void setFailureCode(Integer theFailureCode) {
        this.myFailureCode = theFailureCode;
    }

    public String getFailureMessage() {
        return this.myFailureMessage;
    }

    public void setFailureMessage(String theFailureMessage) {
        this.myFailureMessage = StringUtils.left((String)theFailureMessage, (int)500);
        if (HapiSystemProperties.isUnitTestCaptureStackEnabled()) {
            this.myFailureMessage = theFailureMessage;
        }
    }

    public Long getId() {
        return this.myId;
    }

    public Collection<SearchInclude> getIncludes() {
        if (this.myIncludes == null) {
            this.myIncludes = new ArrayList<SearchInclude>();
        }
        return this.myIncludes;
    }

    public DateRangeParam getLastUpdated() {
        if (this.myLastUpdatedLow == null && this.myLastUpdatedHigh == null) {
            return null;
        }
        return new DateRangeParam(this.myLastUpdatedLow, this.myLastUpdatedHigh);
    }

    public void setLastUpdated(DateRangeParam theLastUpdated) {
        if (theLastUpdated == null) {
            this.myLastUpdatedLow = null;
            this.myLastUpdatedHigh = null;
        } else {
            this.myLastUpdatedLow = theLastUpdated.getLowerBoundAsInstant();
            this.myLastUpdatedHigh = theLastUpdated.getUpperBoundAsInstant();
        }
    }

    public Date getLastUpdatedHigh() {
        return this.myLastUpdatedHigh;
    }

    public Date getLastUpdatedLow() {
        return this.myLastUpdatedLow;
    }

    public int getNumFound() {
        ourLog.trace("getNumFound {}", (Object)this.myNumFound);
        return this.myNumFound;
    }

    public void setNumFound(int theNumFound) {
        ourLog.trace("setNumFound {}", (Object)theNumFound);
        this.myNumFound = theNumFound;
    }

    public Integer getPreferredPageSize() {
        return this.myPreferredPageSize;
    }

    public void setPreferredPageSize(Integer thePreferredPageSize) {
        this.myPreferredPageSize = thePreferredPageSize;
    }

    public Long getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public void setResourceType(String theResourceType) {
        this.myResourceType = theResourceType;
    }

    public String getSearchQueryString() {
        return this.mySearchQueryString;
    }

    public void setSearchQueryString(String theSearchQueryString, RequestPartitionId theRequestPartitionId) {
        String searchQueryString = null;
        if (theSearchQueryString != null) {
            searchQueryString = Search.createSearchQueryStringForStorage(theSearchQueryString, theRequestPartitionId);
        }
        this.mySearchQueryString = searchQueryString == null || searchQueryString.length() > 10000 ? UUID.randomUUID().toString() : searchQueryString;
        this.mySearchQueryStringHash = this.mySearchQueryString.hashCode();
    }

    public SearchTypeEnum getSearchType() {
        return this.mySearchType;
    }

    public void setSearchType(SearchTypeEnum theSearchType) {
        this.mySearchType = theSearchType;
    }

    public SearchStatusEnum getStatus() {
        ourLog.trace("getStatus {}", (Object)this.myStatus);
        return this.myStatus;
    }

    public void setStatus(SearchStatusEnum theStatus) {
        ourLog.trace("setStatus {}", (Object)theStatus);
        this.myStatus = theStatus;
    }

    public Integer getTotalCount() {
        return this.myTotalCount;
    }

    public void setTotalCount(Integer theTotalCount) {
        this.myTotalCount = theTotalCount;
    }

    public String getUuid() {
        return this.myUuid;
    }

    public void setUuid(String theUuid) {
        this.myUuid = theUuid;
    }

    public void setLastUpdated(Date theLowerBound, Date theUpperBound) {
        this.myLastUpdatedLow = theLowerBound;
        this.myLastUpdatedHigh = theUpperBound;
    }

    private Set<Include> toIncList(boolean theWantReverse, boolean theIncludeAll, boolean theWantIterate) {
        HashSet<Include> retVal = new HashSet<Include>();
        for (SearchInclude next : this.getIncludes()) {
            if (theWantReverse != next.isReverse()) continue;
            if (theIncludeAll) {
                retVal.add(new Include(next.getInclude(), next.isRecurse()));
                continue;
            }
            if (theWantIterate != next.isRecurse()) continue;
            retVal.add(new Include(next.getInclude(), next.isRecurse()));
        }
        return Collections.unmodifiableSet(retVal);
    }

    private Set<Include> toIncList(boolean theWantReverse) {
        return this.toIncList(theWantReverse, true, true);
    }

    public Set<Include> toIncludesList() {
        return this.toIncList(false);
    }

    public Set<Include> toRevIncludesList() {
        return this.toIncList(true);
    }

    public Set<Include> toIncludesList(boolean iterate) {
        return this.toIncList(false, false, iterate);
    }

    public Set<Include> toRevIncludesList(boolean iterate) {
        return this.toIncList(true, false, iterate);
    }

    public void addInclude(SearchInclude theInclude) {
        this.getIncludes().add(theInclude);
    }

    public Integer getVersion() {
        return this.myVersion;
    }

    public Optional<SearchParameterMap> getSearchParameterMap() {
        if (this.mySearchParameterMapTransient != null) {
            return Optional.of(this.mySearchParameterMapTransient);
        }
        SearchParameterMap searchParameterMap = null;
        if (this.mySearchParameterMap != null) {
            this.mySearchParameterMapTransient = searchParameterMap = (SearchParameterMap)SerializationUtils.deserialize((byte[])this.mySearchParameterMap);
        }
        return Optional.ofNullable(searchParameterMap);
    }

    public void setSearchParameterMap(SearchParameterMap theSearchParameterMap) {
        this.mySearchParameterMapTransient = theSearchParameterMap;
        this.mySearchParameterMap = SerializationUtils.serialize((Serializable)theSearchParameterMap);
    }

    public void setCannotBeReused() {
        this.mySearchQueryStringHash = null;
    }

    public Integer getOffset() {
        return this.myOffset;
    }

    public void setOffset(Integer theOffset) {
        this.myOffset = theOffset;
    }

    public HistorySearchStyleEnum getHistorySearchStyle() {
        return this.myHistorySearchStyle;
    }

    public void setHistorySearchStyle(HistorySearchStyleEnum theHistorySearchStyle) {
        this.myHistorySearchStyle = theHistorySearchStyle;
    }

    @Nonnull
    public static String createSearchQueryStringForStorage(@Nonnull String theSearchQueryString, @Nonnull RequestPartitionId theRequestPartitionId) {
        Object searchQueryString = theSearchQueryString;
        if (!theRequestPartitionId.isAllPartitions()) {
            searchQueryString = RequestPartitionId.stringifyForKey((RequestPartitionId)theRequestPartitionId) + " " + (String)searchQueryString;
        }
        return searchQueryString;
    }
}

