/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConceptDesignation;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.entity.TermConceptPropertyBinder;
import ca.uhn.fhir.jpa.entity.TermConceptPropertyTypeEnum;
import ca.uhn.fhir.jpa.search.DeferConceptIndexingRoutingBinder;
import ca.uhn.fhir.util.ValidateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.PropertyBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.RoutingBinderRef;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.Indexed;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.PropertyBinding;
import org.hl7.fhir.r4.model.Coding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Indexed(routingBinder=@RoutingBinderRef(type=DeferConceptIndexingRoutingBinder.class))
@Table(name="TRM_CONCEPT", uniqueConstraints={@UniqueConstraint(name="IDX_CONCEPT_CS_CODE", columnNames={"CODESYSTEM_PID", "CODEVAL"})}, indexes={@Index(name="IDX_CONCEPT_INDEXSTATUS", columnList="INDEX_STATUS"), @Index(name="IDX_CONCEPT_UPDATED", columnList="CONCEPT_UPDATED")})
public class TermConcept
implements Serializable {
    public static final int MAX_CODE_LENGTH = 500;
    public static final int MAX_DESC_LENGTH = 400;
    public static final int MAX_DISP_LENGTH = 500;
    private static final Logger ourLog = LoggerFactory.getLogger(TermConcept.class);
    private static final long serialVersionUID = 1L;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="myParent", cascade={})
    private List<TermConceptParentChildLink> myChildren;
    @Column(name="CODEVAL", nullable=false, length=500)
    @FullTextField(name="myCode", searchable=Searchable.YES, projectable=Projectable.YES, analyzer="exactAnalyzer")
    private String myCode;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CONCEPT_UPDATED", nullable=true)
    private Date myUpdated;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CODESYSTEM_PID", referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_CONCEPT_PID_CS_PID"))
    private TermCodeSystemVersion myCodeSystem;
    @Column(name="CODESYSTEM_PID", insertable=false, updatable=false)
    @GenericField(name="myCodeSystemVersionPid")
    private long myCodeSystemVersionPid;
    @Column(name="DISPLAY", nullable=true, length=400)
    @FullTextField.List(value={@FullTextField(name="myDisplay", searchable=Searchable.YES, projectable=Projectable.YES, analyzer="standardAnalyzer"), @FullTextField(name="myDisplayEdgeNGram", searchable=Searchable.YES, projectable=Projectable.NO, analyzer="autocompleteEdgeAnalyzer"), @FullTextField(name="myDisplayWordEdgeNGram", searchable=Searchable.YES, projectable=Projectable.NO, analyzer="autocompleteWordEdgeAnalyzer"), @FullTextField(name="myDisplayNGram", searchable=Searchable.YES, projectable=Projectable.NO, analyzer="autocompleteNGramAnalyzer"), @FullTextField(name="myDisplayPhonetic", searchable=Searchable.YES, projectable=Projectable.NO, analyzer="autocompletePhoneticAnalyzer")})
    private String myDisplay;
    @OneToMany(mappedBy="myConcept", orphanRemoval=false, fetch=FetchType.LAZY)
    @PropertyBinding(binder=@PropertyBinderRef(type=TermConceptPropertyBinder.class))
    private Collection<TermConceptProperty> myProperties;
    @OneToMany(mappedBy="myConcept", orphanRemoval=false, fetch=FetchType.LAZY)
    private Collection<TermConceptDesignation> myDesignations;
    @Id
    @SequenceGenerator(name="SEQ_CONCEPT_PID", sequenceName="SEQ_CONCEPT_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CONCEPT_PID")
    @Column(name="PID")
    @GenericField
    private Long myId;
    @Column(name="INDEX_STATUS", nullable=true)
    private Long myIndexStatus;
    @Lob
    @Column(name="PARENT_PIDS", nullable=true)
    @FullTextField(name="myParentPids", searchable=Searchable.YES, projectable=Projectable.YES, analyzer="conceptParentPidsAnalyzer")
    private String myParentPids;
    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="myChild")
    private List<TermConceptParentChildLink> myParents;
    @Column(name="CODE_SEQUENCE", nullable=true)
    private Integer mySequence;

    public TermConcept() {
    }

    public TermConcept(TermCodeSystemVersion theCs, String theCode) {
        this.setCodeSystemVersion(theCs);
        this.setCode(theCode);
    }

    public TermConcept addChild(TermConceptParentChildLink.RelationshipTypeEnum theRelationshipType) {
        TermConcept child = new TermConcept();
        child.setCodeSystemVersion(this.myCodeSystem);
        this.addChild(child, theRelationshipType);
        return child;
    }

    public TermConceptParentChildLink addChild(TermConcept theChild, TermConceptParentChildLink.RelationshipTypeEnum theRelationshipType) {
        Validate.notNull((Object)((Object)theRelationshipType), (String)"theRelationshipType must not be null", (Object[])new Object[0]);
        TermConceptParentChildLink link = new TermConceptParentChildLink();
        link.setParent(this);
        link.setChild(theChild);
        link.setRelationshipType(theRelationshipType);
        this.getChildren().add(link);
        theChild.getParents().add(link);
        return link;
    }

    public void addChildren(List<TermConcept> theChildren, TermConceptParentChildLink.RelationshipTypeEnum theRelationshipType) {
        for (TermConcept next : theChildren) {
            this.addChild(next, theRelationshipType);
        }
    }

    public TermConceptDesignation addDesignation() {
        TermConceptDesignation designation = new TermConceptDesignation();
        designation.setConcept(this);
        designation.setCodeSystemVersion(this.myCodeSystem);
        this.getDesignations().add(designation);
        return designation;
    }

    private TermConceptProperty addProperty(@Nonnull TermConceptPropertyTypeEnum thePropertyType, @Nonnull String thePropertyName, @Nonnull String thePropertyValue) {
        Validate.notBlank((CharSequence)thePropertyName);
        TermConceptProperty property = new TermConceptProperty();
        property.setConcept(this);
        property.setCodeSystemVersion(this.myCodeSystem);
        property.setType(thePropertyType);
        property.setKey(thePropertyName);
        property.setValue(thePropertyValue);
        if (!this.getProperties().contains(property)) {
            this.getProperties().add(property);
        }
        return property;
    }

    public TermConceptProperty addPropertyCoding(@Nonnull String thePropertyName, @Nonnull String thePropertyCodeSystem, @Nonnull String thePropertyCode, String theDisplayName) {
        return this.addProperty(TermConceptPropertyTypeEnum.CODING, thePropertyName, thePropertyCode).setCodeSystem(thePropertyCodeSystem).setDisplay(theDisplayName);
    }

    public TermConceptProperty addPropertyString(@Nonnull String thePropertyName, @Nonnull String thePropertyValue) {
        return this.addProperty(TermConceptPropertyTypeEnum.STRING, thePropertyName, thePropertyValue);
    }

    public boolean equals(Object theObj) {
        if (!(theObj instanceof TermConcept)) {
            return false;
        }
        if (theObj == this) {
            return true;
        }
        TermConcept obj = (TermConcept)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.myCodeSystem, (Object)obj.myCodeSystem);
        b.append((Object)this.myCode, (Object)obj.myCode);
        return b.isEquals();
    }

    public List<TermConceptParentChildLink> getChildren() {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<TermConceptParentChildLink>();
        }
        return this.myChildren;
    }

    public String getCode() {
        return this.myCode;
    }

    public TermConcept setCode(@Nonnull String theCode) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theCode, (String)"theCode must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theCode, (int)500, (String)("Code exceeds maximum length (500): " + StringUtils.length((CharSequence)theCode)));
        this.myCode = theCode;
        return this;
    }

    public TermCodeSystemVersion getCodeSystemVersion() {
        return this.myCodeSystem;
    }

    public TermConcept setCodeSystemVersion(TermCodeSystemVersion theCodeSystemVersion) {
        this.myCodeSystem = theCodeSystemVersion;
        if (theCodeSystemVersion != null && theCodeSystemVersion.getPid() != null) {
            this.myCodeSystemVersionPid = theCodeSystemVersion.getPid();
        }
        return this;
    }

    public List<Coding> getCodingProperties(String thePropertyName) {
        ArrayList<Coding> retVal = new ArrayList<Coding>();
        for (TermConceptProperty next : this.getProperties()) {
            if (!thePropertyName.equals(next.getKey()) || next.getType() != TermConceptPropertyTypeEnum.CODING) continue;
            Coding coding = new Coding();
            coding.setSystem(next.getCodeSystem());
            coding.setCode(next.getValue());
            coding.setDisplay(next.getDisplay());
            retVal.add(coding);
        }
        return retVal;
    }

    public Collection<TermConceptDesignation> getDesignations() {
        if (this.myDesignations == null) {
            this.myDesignations = new ArrayList<TermConceptDesignation>();
        }
        return this.myDesignations;
    }

    public String getDisplay() {
        return this.myDisplay;
    }

    public TermConcept setDisplay(String theDisplay) {
        this.myDisplay = StringUtils.left((String)theDisplay, (int)400);
        return this;
    }

    public Long getId() {
        return this.myId;
    }

    public TermConcept setId(Long theId) {
        this.myId = theId;
        return this;
    }

    public Long getIndexStatus() {
        return this.myIndexStatus;
    }

    public TermConcept setIndexStatus(Long theIndexStatus) {
        this.myIndexStatus = theIndexStatus;
        return this;
    }

    public String getParentPidsAsString() {
        return this.myParentPids;
    }

    public List<TermConceptParentChildLink> getParents() {
        if (this.myParents == null) {
            this.myParents = new ArrayList<TermConceptParentChildLink>();
        }
        return this.myParents;
    }

    public Collection<TermConceptProperty> getProperties() {
        if (this.myProperties == null) {
            this.myProperties = new ArrayList<TermConceptProperty>();
        }
        return this.myProperties;
    }

    public Integer getSequence() {
        return this.mySequence;
    }

    public TermConcept setSequence(Integer theSequence) {
        this.mySequence = theSequence;
        return this;
    }

    public List<String> getStringProperties(String thePropertyName) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (TermConceptProperty next : this.getProperties()) {
            if (!thePropertyName.equals(next.getKey()) || next.getType() != TermConceptPropertyTypeEnum.STRING) continue;
            retVal.add(next.getValue());
        }
        return retVal;
    }

    public String getStringProperty(String thePropertyName) {
        List<String> properties = this.getStringProperties(thePropertyName);
        if (properties.size() > 0) {
            return properties.get(0);
        }
        return null;
    }

    public Date getUpdated() {
        return this.myUpdated;
    }

    public TermConcept setUpdated(Date theUpdated) {
        this.myUpdated = theUpdated;
        return this;
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.myCodeSystem);
        b.append((Object)this.myCode);
        return b.toHashCode();
    }

    private void parentPids(TermConcept theNextConcept, Set<Long> theParentPids) {
        for (TermConceptParentChildLink nextParentLink : theNextConcept.getParents()) {
            TermConcept parent = nextParentLink.getParent();
            if (parent == null) continue;
            Long parentConceptId = parent.getId();
            Validate.notNull((Object)parentConceptId);
            if (!theParentPids.add(parentConceptId)) continue;
            this.parentPids(parent, theParentPids);
        }
    }

    @PreUpdate
    @PrePersist
    public void prePersist() {
        if (this.myParentPids == null) {
            HashSet<Long> parentPids = new HashSet<Long>();
            TermConcept entity = this;
            this.parentPids(entity, parentPids);
            entity.setParentPids(parentPids);
            ourLog.trace("Code {}/{} has parents {}", new Object[]{entity.getId(), entity.getCode(), entity.getParentPidsAsString()});
        }
    }

    private void setParentPids(Set<Long> theParentPids) {
        StringBuilder b = new StringBuilder();
        for (Long next : theParentPids) {
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(next);
        }
        if (b.length() == 0) {
            b.append("NONE");
        }
        this.setParentPids(b.toString());
    }

    public TermConcept setParentPids(String theParentPids) {
        this.myParentPids = theParentPids;
        return this;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("pid", (Object)this.myId);
        b.append("csvPid", this.myCodeSystemVersionPid);
        b.append("code", (Object)this.myCode);
        b.append("display", (Object)this.myDisplay);
        if (this.mySequence != null) {
            b.append("sequence", (Object)this.mySequence);
        }
        return b.build();
    }

    public List<IValidationSupport.BaseConceptProperty> toValidationProperties() {
        ArrayList<IValidationSupport.BaseConceptProperty> retVal = new ArrayList<IValidationSupport.BaseConceptProperty>();
        block4: for (TermConceptProperty next : this.getProperties()) {
            switch (next.getType()) {
                case STRING: {
                    retVal.add((IValidationSupport.BaseConceptProperty)new IValidationSupport.StringConceptProperty(next.getKey(), next.getValue()));
                    continue block4;
                }
                case CODING: {
                    retVal.add((IValidationSupport.BaseConceptProperty)new IValidationSupport.CodingConceptProperty(next.getKey(), next.getCodeSystem(), next.getValue(), next.getDisplay()));
                    continue block4;
                }
            }
            throw new IllegalStateException(Msg.code((int)830) + "Don't know how to handle " + next.getType());
        }
        return retVal;
    }

    public List<TermConcept> getChildCodes() {
        return this.getChildren().stream().map(TermConceptParentChildLink::getChild).collect(Collectors.toList());
    }
}

