/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermConceptMap;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElement;
import ca.uhn.fhir.util.ValidateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="TRM_CONCEPT_MAP_GROUP", indexes={@Index(name="FK_TCMGROUP_CONCEPTMAP", columnList="CONCEPT_MAP_PID")})
public class TermConceptMapGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_CONCEPT_MAP_GROUP_PID", sequenceName="SEQ_CONCEPT_MAP_GROUP_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CONCEPT_MAP_GROUP_PID")
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="CONCEPT_MAP_PID", nullable=false, referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_TCMGROUP_CONCEPTMAP"))
    private TermConceptMap myConceptMap;
    @Column(name="SOURCE_URL", nullable=false, length=200)
    private String mySource;
    @Column(name="SOURCE_VERSION", nullable=true, length=200)
    private String mySourceVersion;
    @Column(name="TARGET_URL", nullable=false, length=200)
    private String myTarget;
    @Column(name="TARGET_VERSION", nullable=true, length=200)
    private String myTargetVersion;
    @OneToMany(mappedBy="myConceptMapGroup")
    private List<TermConceptMapGroupElement> myConceptMapGroupElements;
    @Column(name="CONCEPT_MAP_URL", nullable=true, length=200)
    private String myConceptMapUrl;
    @Column(name="SOURCE_VS", nullable=true, length=200)
    private String mySourceValueSet;
    @Column(name="TARGET_VS", nullable=true, length=200)
    private String myTargetValueSet;

    public TermConceptMap getConceptMap() {
        return this.myConceptMap;
    }

    public TermConceptMapGroup setConceptMap(TermConceptMap theTermConceptMap) {
        this.myConceptMap = theTermConceptMap;
        return this;
    }

    public List<TermConceptMapGroupElement> getConceptMapGroupElements() {
        if (this.myConceptMapGroupElements == null) {
            this.myConceptMapGroupElements = new ArrayList<TermConceptMapGroupElement>();
        }
        return this.myConceptMapGroupElements;
    }

    public String getConceptMapUrl() {
        if (this.myConceptMapUrl == null) {
            this.myConceptMapUrl = this.getConceptMap().getUrl();
        }
        return this.myConceptMapUrl;
    }

    public Long getId() {
        return this.myId;
    }

    public String getSource() {
        return this.mySource;
    }

    public TermConceptMapGroup setSource(@Nonnull String theSource) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theSource, (String)"theSource must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theSource, (int)200, (String)("Source exceeds maximum length (200): " + StringUtils.length((CharSequence)theSource)));
        this.mySource = theSource;
        return this;
    }

    public String getSourceValueSet() {
        if (this.mySourceValueSet == null) {
            this.mySourceValueSet = this.getConceptMap().getSource();
        }
        return this.mySourceValueSet;
    }

    public String getSourceVersion() {
        return this.mySourceVersion;
    }

    public TermConceptMapGroup setSourceVersion(String theSourceVersion) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theSourceVersion, (int)200, (String)("Source version ID exceeds maximum length (200): " + StringUtils.length((CharSequence)theSourceVersion)));
        this.mySourceVersion = theSourceVersion;
        return this;
    }

    public String getTarget() {
        return this.myTarget;
    }

    public TermConceptMapGroup setTarget(@Nonnull String theTarget) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theTarget, (String)"theTarget must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theTarget, (int)200, (String)("Target exceeds maximum length (200): " + StringUtils.length((CharSequence)theTarget)));
        this.myTarget = theTarget;
        return this;
    }

    public String getTargetValueSet() {
        if (this.myTargetValueSet == null) {
            this.myTargetValueSet = this.getConceptMap().getTarget();
        }
        return this.myTargetValueSet;
    }

    public String getTargetVersion() {
        return this.myTargetVersion;
    }

    public TermConceptMapGroup setTargetVersion(String theTargetVersion) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theTargetVersion, (int)200, (String)("Target version ID exceeds maximum length (200): " + StringUtils.length((CharSequence)theTargetVersion)));
        this.myTargetVersion = theTargetVersion;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("myId", (Object)this.myId).append(this.myConceptMap != null ? "myConceptMap - id=" + this.myConceptMap.getId() : "myConceptMap=(null)").append("mySource", (Object)this.mySource).append("mySourceVersion", (Object)this.mySourceVersion).append("myTarget", (Object)this.myTarget).append("myTargetVersion", (Object)this.myTargetVersion).append(this.myConceptMapGroupElements != null ? "myConceptMapGroupElements - size=" + this.myConceptMapGroupElements.size() : "myConceptMapGroupElements=(null)").append("myConceptMapUrl", (Object)this.getConceptMapUrl()).append("mySourceValueSet", (Object)this.getSourceValueSet()).append("myTargetValueSet", (Object)this.getTargetValueSet()).toString();
    }
}

