/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermConceptMapGroup;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElementTarget;
import ca.uhn.fhir.util.ValidateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="TRM_CONCEPT_MAP_GRP_ELEMENT", indexes={@Index(name="IDX_CNCPT_MAP_GRP_CD", columnList="SOURCE_CODE"), @Index(name="FK_TCMGELEMENT_GROUP", columnList="CONCEPT_MAP_GROUP_PID")})
public class TermConceptMapGroupElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_CONCEPT_MAP_GRP_ELM_PID", sequenceName="SEQ_CONCEPT_MAP_GRP_ELM_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CONCEPT_MAP_GRP_ELM_PID")
    @Column(name="PID")
    private Long myId;
    @ManyToOne
    @JoinColumn(name="CONCEPT_MAP_GROUP_PID", nullable=false, referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_TCMGELEMENT_GROUP"))
    private TermConceptMapGroup myConceptMapGroup;
    @Column(name="SOURCE_CODE", nullable=false, length=500)
    private String myCode;
    @Column(name="SOURCE_DISPLAY", length=500)
    private String myDisplay;
    @OneToMany(mappedBy="myConceptMapGroupElement")
    private List<TermConceptMapGroupElementTarget> myConceptMapGroupElementTargets;
    @Column(name="CONCEPT_MAP_URL", nullable=true, length=200)
    private String myConceptMapUrl;
    @Column(name="SYSTEM_URL", nullable=true, length=200)
    private String mySystem;
    @Column(name="SYSTEM_VERSION", nullable=true, length=200)
    private String mySystemVersion;
    @Column(name="VALUESET_URL", nullable=true, length=200)
    private String myValueSet;

    public String getCode() {
        return this.myCode;
    }

    public TermConceptMapGroupElement setCode(@Nonnull String theCode) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theCode, (String)"theCode must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theCode, (int)500, (String)("Code exceeds maximum length (500): " + StringUtils.length((CharSequence)theCode)));
        this.myCode = theCode;
        return this;
    }

    public TermConceptMapGroup getConceptMapGroup() {
        return this.myConceptMapGroup;
    }

    public TermConceptMapGroupElement setConceptMapGroup(TermConceptMapGroup theTermConceptMapGroup) {
        this.myConceptMapGroup = theTermConceptMapGroup;
        return this;
    }

    public List<TermConceptMapGroupElementTarget> getConceptMapGroupElementTargets() {
        if (this.myConceptMapGroupElementTargets == null) {
            this.myConceptMapGroupElementTargets = new ArrayList<TermConceptMapGroupElementTarget>();
        }
        return this.myConceptMapGroupElementTargets;
    }

    public String getConceptMapUrl() {
        if (this.myConceptMapUrl == null) {
            this.myConceptMapUrl = this.getConceptMapGroup().getConceptMap().getUrl();
        }
        return this.myConceptMapUrl;
    }

    public String getDisplay() {
        return this.myDisplay;
    }

    public TermConceptMapGroupElement setDisplay(String theDisplay) {
        this.myDisplay = StringUtils.left((String)theDisplay, (int)500);
        return this;
    }

    public Long getId() {
        return this.myId;
    }

    public String getSystem() {
        if (this.mySystem == null) {
            this.mySystem = this.getConceptMapGroup().getSource();
        }
        return this.mySystem;
    }

    public String getSystemVersion() {
        if (this.mySystemVersion == null) {
            this.mySystemVersion = this.getConceptMapGroup().getSourceVersion();
        }
        return this.mySystemVersion;
    }

    public String getValueSet() {
        if (this.myValueSet == null) {
            this.myValueSet = this.getConceptMapGroup().getSourceValueSet();
        }
        return this.myValueSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TermConceptMapGroupElement)) {
            return false;
        }
        TermConceptMapGroupElement that = (TermConceptMapGroupElement)o;
        return new EqualsBuilder().append((Object)this.getCode(), (Object)that.getCode()).append((Object)this.getSystem(), (Object)that.getSystem()).append((Object)this.getSystemVersion(), (Object)that.getSystemVersion()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getCode()).append((Object)this.getSystem()).append((Object)this.getSystemVersion()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("myId", (Object)this.myId).append(this.myConceptMapGroup != null ? "myConceptMapGroup - id=" + this.myConceptMapGroup.getId() : "myConceptMapGroup=(null)").append("myCode", (Object)this.myCode).append("myDisplay", (Object)this.myDisplay).append(this.myConceptMapGroupElementTargets != null ? "myConceptMapGroupElementTargets - size=" + this.myConceptMapGroupElementTargets.size() : "myConceptMapGroupElementTargets=(null)").append("myConceptMapUrl", (Object)this.getConceptMapUrl()).append("mySystem", (Object)this.getSystem()).append("mySystemVersion", (Object)this.getSystemVersion()).append("myValueSet", (Object)this.getValueSet()).toString();
    }
}

