/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.entity.TermConceptPropertyTypeEnum;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.PropertyBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.PropertyBinder;
import org.hibernate.search.mapper.pojo.bridge.runtime.PropertyBridgeWriteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermConceptPropertyBinder
implements PropertyBinder {
    public static final String CONCEPT_PROPERTY_PREFIX_NAME = "P:";
    private static final Logger ourLog = LoggerFactory.getLogger(TermConceptPropertyBinder.class);

    public void bind(PropertyBindingContext thePropertyBindingContext) {
        thePropertyBindingContext.dependencies().use("myKey").use("myValue");
        IndexSchemaElement indexSchemaElement = thePropertyBindingContext.indexSchemaElement();
        indexSchemaElement.fieldTemplate("propTemplate", IndexFieldTypeFactory::asString).matchingPathGlob("P:*").multiValued();
        thePropertyBindingContext.bridge(Collection.class, (PropertyBridge)new TermConceptPropertyBridge());
    }

    private static class TermConceptPropertyBridge
    implements PropertyBridge<Collection> {
        private TermConceptPropertyBridge() {
        }

        public void write(DocumentElement theDocument, Collection theObject, PropertyBridgeWriteContext thePropertyBridgeWriteContext) {
            Collection properties = theObject;
            if (properties != null) {
                for (TermConceptProperty next : properties) {
                    theDocument.addValue(TermConceptPropertyBinder.CONCEPT_PROPERTY_PREFIX_NAME + next.getKey(), (Object)next.getValue());
                    ourLog.trace("Adding Prop: {}{} -- {}", new Object[]{TermConceptPropertyBinder.CONCEPT_PROPERTY_PREFIX_NAME, next.getKey(), next.getValue()});
                    if (next.getType() != TermConceptPropertyTypeEnum.CODING || !StringUtils.isNotBlank((CharSequence)next.getDisplay())) continue;
                    theDocument.addValue(TermConceptPropertyBinder.CONCEPT_PROPERTY_PREFIX_NAME + next.getKey(), (Object)next.getDisplay());
                    ourLog.trace("Adding multivalue Prop: {}{} -- {}", new Object[]{TermConceptPropertyBinder.CONCEPT_PROPERTY_PREFIX_NAME, next.getKey(), next.getDisplay()});
                }
            }
        }
    }
}

