/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermValueSetConcept;
import ca.uhn.fhir.jpa.entity.TermValueSetPreExpansionStatusEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.util.ValidateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.ColumnDefault;

@Table(name="TRM_VALUESET", uniqueConstraints={@UniqueConstraint(name="IDX_VALUESET_URL", columnNames={"URL", "VER"})}, indexes={@Index(name="FK_TRMVALUESET_RES", columnList="RES_ID")})
@Entity
public class TermValueSet
implements Serializable {
    public static final int MAX_EXPANSION_STATUS_LENGTH = 50;
    public static final int MAX_NAME_LENGTH = 200;
    public static final int MAX_URL_LENGTH = 200;
    public static final int MAX_VER_LENGTH = 200;
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_VALUESET_PID", sequenceName="SEQ_VALUESET_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_VALUESET_PID")
    @Column(name="PID")
    private Long myId;
    @Column(name="URL", nullable=false, length=200)
    private String myUrl;
    @Column(name="VER", nullable=true, length=200)
    private String myVersion;
    @OneToOne
    @JoinColumn(name="RES_ID", referencedColumnName="RES_ID", nullable=false, updatable=false, foreignKey=@ForeignKey(name="FK_TRMVALUESET_RES"))
    private ResourceTable myResource;
    @Column(name="RES_ID", insertable=false, updatable=false)
    private Long myResourcePid;
    @Column(name="VSNAME", nullable=true, length=200)
    private String myName;
    @OneToMany(mappedBy="myValueSet", fetch=FetchType.LAZY)
    private List<TermValueSetConcept> myConcepts;
    @Column(name="TOTAL_CONCEPTS", nullable=false)
    @ColumnDefault(value="0")
    private Long myTotalConcepts = 0L;
    @Column(name="TOTAL_CONCEPT_DESIGNATIONS", nullable=false)
    @ColumnDefault(value="0")
    private Long myTotalConceptDesignations = 0L;
    @Enumerated(value=EnumType.STRING)
    @Column(name="EXPANSION_STATUS", nullable=false, length=50)
    private TermValueSetPreExpansionStatusEnum myExpansionStatus = TermValueSetPreExpansionStatusEnum.NOT_EXPANDED;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="EXPANDED_AT", nullable=true)
    private Date myExpansionTimestamp;
    @Transient
    private transient Integer myHashCode;

    public Date getExpansionTimestamp() {
        return this.myExpansionTimestamp;
    }

    public void setExpansionTimestamp(Date theExpansionTimestamp) {
        this.myExpansionTimestamp = theExpansionTimestamp;
    }

    public Long getId() {
        return this.myId;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public TermValueSet setUrl(@Nonnull String theUrl) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theUrl, (String)"theUrl must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theUrl, (int)200, (String)("URL exceeds maximum length (200): " + StringUtils.length((CharSequence)theUrl)));
        this.myUrl = theUrl;
        return this;
    }

    public ResourceTable getResource() {
        return this.myResource;
    }

    public TermValueSet setResource(ResourceTable theResource) {
        this.myResource = theResource;
        return this;
    }

    public String getName() {
        return this.myName;
    }

    public TermValueSet setName(String theName) {
        this.myName = StringUtils.left((String)theName, (int)200);
        return this;
    }

    public List<TermValueSetConcept> getConcepts() {
        if (this.myConcepts == null) {
            this.myConcepts = new ArrayList<TermValueSetConcept>();
        }
        return this.myConcepts;
    }

    public Long getTotalConcepts() {
        return this.myTotalConcepts;
    }

    public TermValueSet setTotalConcepts(Long theTotalConcepts) {
        this.myTotalConcepts = theTotalConcepts;
        return this;
    }

    public TermValueSet decrementTotalConcepts() {
        if (this.myTotalConcepts > 0L) {
            Long l = this.myTotalConcepts;
            this.myTotalConcepts = this.myTotalConcepts - 1L;
        }
        return this;
    }

    public TermValueSet incrementTotalConcepts() {
        Long l = this.myTotalConcepts;
        this.myTotalConcepts = this.myTotalConcepts + 1L;
        return this;
    }

    public Long getTotalConceptDesignations() {
        return this.myTotalConceptDesignations;
    }

    public TermValueSet setTotalConceptDesignations(Long theTotalConceptDesignations) {
        this.myTotalConceptDesignations = theTotalConceptDesignations;
        return this;
    }

    public TermValueSet decrementTotalConceptDesignations() {
        if (this.myTotalConceptDesignations > 0L) {
            Long l = this.myTotalConceptDesignations;
            this.myTotalConceptDesignations = this.myTotalConceptDesignations - 1L;
        }
        return this;
    }

    public TermValueSet incrementTotalConceptDesignations() {
        Long l = this.myTotalConceptDesignations;
        this.myTotalConceptDesignations = this.myTotalConceptDesignations + 1L;
        return this;
    }

    public TermValueSetPreExpansionStatusEnum getExpansionStatus() {
        return this.myExpansionStatus;
    }

    public void setExpansionStatus(TermValueSetPreExpansionStatusEnum theExpansionStatus) {
        this.myExpansionStatus = theExpansionStatus;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public TermValueSet setVersion(String theVersion) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theVersion, (int)200, (String)("Version exceeds maximum length (200): " + StringUtils.length((CharSequence)theVersion)));
        this.myVersion = theVersion;
        return this;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (!(theO instanceof TermValueSet)) {
            return false;
        }
        TermValueSet that = (TermValueSet)theO;
        return new EqualsBuilder().append((Object)this.getUrl(), (Object)that.getUrl()).isEquals();
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            this.myHashCode = this.getUrl().hashCode();
        }
        return this.myHashCode;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.myId).append("url", (Object)this.myUrl).append(this.myResource != null ? "resource=" + this.myResource.toString() : "resource=(null)").append("resourcePid", (Object)this.myResourcePid).append("name", (Object)this.myName).append(this.myConcepts != null ? "concepts - size=" + this.myConcepts.size() : "concepts=(null)").append("totalConcepts", (Object)this.myTotalConcepts).append("totalConceptDesignations", (Object)this.myTotalConceptDesignations).append("expansionStatus", (Object)this.myExpansionStatus).toString();
    }
}

