/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermValueSet;
import ca.uhn.fhir.jpa.entity.TermValueSetConceptDesignation;
import ca.uhn.fhir.util.ValidateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Table(name="TRM_VALUESET_CONCEPT", uniqueConstraints={@UniqueConstraint(name="IDX_VS_CONCEPT_CSCD", columnNames={"VALUESET_PID", "SYSTEM_URL", "CODEVAL"}), @UniqueConstraint(name="IDX_VS_CONCEPT_ORDER", columnNames={"VALUESET_PID", "VALUESET_ORDER"})})
@Entity
public class TermValueSetConcept
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_VALUESET_CONCEPT_PID", sequenceName="SEQ_VALUESET_CONCEPT_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_VALUESET_CONCEPT_PID")
    @Column(name="PID")
    private Long myId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="VALUESET_PID", referencedColumnName="PID", nullable=false, foreignKey=@ForeignKey(name="FK_TRM_VALUESET_PID"))
    private TermValueSet myValueSet;
    @Column(name="VALUESET_PID", insertable=false, updatable=false, nullable=false)
    private Long myValueSetPid;
    @Column(name="INDEX_STATUS", nullable=true)
    private Long myIndexStatus;
    @Column(name="VALUESET_ORDER", nullable=false)
    private int myOrder;
    @Transient
    private String myValueSetUrl;
    @Transient
    private String myValueSetName;
    @Column(name="SOURCE_PID", nullable=true)
    private Long mySourceConceptPid;
    @Lob
    @Column(name="SOURCE_DIRECT_PARENT_PIDS", nullable=true)
    private String mySourceConceptDirectParentPids;
    @Column(name="SYSTEM_URL", nullable=false, length=200)
    private String mySystem;
    @Column(name="SYSTEM_VER", nullable=true, length=200)
    private String mySystemVer;
    @Column(name="CODEVAL", nullable=false, length=500)
    private String myCode;
    @Column(name="DISPLAY", nullable=true, length=400)
    private String myDisplay;
    @OneToMany(mappedBy="myConcept", fetch=FetchType.LAZY)
    private List<TermValueSetConceptDesignation> myDesignations;
    @Transient
    private transient Integer myHashCode;

    public Long getId() {
        return this.myId;
    }

    public TermValueSet getValueSet() {
        return this.myValueSet;
    }

    public TermValueSetConcept setValueSet(TermValueSet theValueSet) {
        this.myValueSet = theValueSet;
        return this;
    }

    public int getOrder() {
        return this.myOrder;
    }

    public TermValueSetConcept setOrder(int theOrder) {
        this.myOrder = theOrder;
        return this;
    }

    public String getValueSetUrl() {
        if (this.myValueSetUrl == null) {
            this.myValueSetUrl = this.getValueSet().getUrl();
        }
        return this.myValueSetUrl;
    }

    public String getValueSetName() {
        if (this.myValueSetName == null) {
            this.myValueSetName = this.getValueSet().getName();
        }
        return this.myValueSetName;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public TermValueSetConcept setSystem(@Nonnull String theSystem) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theSystem, (String)"theSystem must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theSystem, (int)200, (String)("System exceeds maximum length (200): " + StringUtils.length((CharSequence)theSystem)));
        this.mySystem = theSystem;
        return this;
    }

    public String getSystemVersion() {
        return this.mySystemVer;
    }

    public TermValueSetConcept setSystemVersion(String theSystemVersion) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theSystemVersion, (int)200, (String)("System version exceeds maximum length (200): " + StringUtils.length((CharSequence)theSystemVersion)));
        this.mySystemVer = theSystemVersion;
        return this;
    }

    public String getCode() {
        return this.myCode;
    }

    public TermValueSetConcept setCode(@Nonnull String theCode) {
        ValidateUtil.isNotBlankOrThrowIllegalArgument((String)theCode, (String)"theCode must not be null or empty");
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theCode, (int)500, (String)("Code exceeds maximum length (500): " + StringUtils.length((CharSequence)theCode)));
        this.myCode = theCode;
        return this;
    }

    public String getDisplay() {
        return this.myDisplay;
    }

    public TermValueSetConcept setDisplay(String theDisplay) {
        this.myDisplay = StringUtils.left((String)theDisplay, (int)400);
        return this;
    }

    public List<TermValueSetConceptDesignation> getDesignations() {
        if (this.myDesignations == null) {
            this.myDesignations = new ArrayList<TermValueSetConceptDesignation>();
        }
        return this.myDesignations;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (!(theO instanceof TermValueSetConcept)) {
            return false;
        }
        TermValueSetConcept that = (TermValueSetConcept)theO;
        return new EqualsBuilder().append((Object)this.myValueSetPid, (Object)that.myValueSetPid).append((Object)this.getSystem(), (Object)that.getSystem()).append((Object)this.getCode(), (Object)that.getCode()).isEquals();
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.myValueSetPid).append((Object)this.getSystem()).append((Object)this.getCode()).toHashCode();
        }
        return this.myHashCode;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.myId).append("order", this.myOrder).append("system", (Object)this.mySystem).append("code", (Object)this.myCode).append("valueSet", this.myValueSet != null ? this.myValueSet.getId() : "(null)").append("valueSetPid", (Object)this.myValueSetPid).append("valueSetUrl", (Object)this.getValueSetUrl()).append("valueSetName", (Object)this.getValueSetName()).append("display", (Object)this.myDisplay).append("designationCount", this.myDesignations != null ? Integer.valueOf(this.myDesignations.size()) : "(null)").append("parentPids", (Object)this.mySourceConceptDirectParentPids).toString();
    }

    public Long getIndexStatus() {
        return this.myIndexStatus;
    }

    public void setIndexStatus(Long theIndexStatus) {
        this.myIndexStatus = theIndexStatus;
    }

    public void setSourceConceptPid(Long theSourceConceptPid) {
        this.mySourceConceptPid = theSourceConceptPid;
    }

    public void setSourceConceptDirectParentPids(String theSourceConceptDirectParentPids) {
        this.mySourceConceptDirectParentPids = theSourceConceptDirectParentPids;
    }
}

