/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.entity.ITermValueSetConceptView;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Clob;
import java.sql.SQLException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import org.apache.commons.io.IOUtils;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Subselect;

@Entity
@Immutable
@Subselect(value="SELECT CONCAT_WS(' ', vsc.PID, vscd.PID) AS PID,        vsc.PID                         AS CONCEPT_PID,        vsc.VALUESET_PID                AS CONCEPT_VALUESET_PID,        vsc.VALUESET_ORDER              AS CONCEPT_VALUESET_ORDER,        vsc.SYSTEM_URL                  AS CONCEPT_SYSTEM_URL,        vsc.CODEVAL                     AS CONCEPT_CODEVAL,        vsc.DISPLAY                     AS CONCEPT_DISPLAY,        vsc.SYSTEM_VER                  AS SYSTEM_VER,        vsc.SOURCE_PID                  AS SOURCE_PID,        vsc.SOURCE_DIRECT_PARENT_PIDS   AS SOURCE_DIRECT_PARENT_PIDS,        vscd.PID                        AS DESIGNATION_PID,        vscd.LANG                       AS DESIGNATION_LANG,        vscd.USE_SYSTEM                 AS DESIGNATION_USE_SYSTEM,        vscd.USE_CODE                   AS DESIGNATION_USE_CODE,        vscd.USE_DISPLAY                AS DESIGNATION_USE_DISPLAY,        vscd.VAL                        AS DESIGNATION_VAL FROM TRM_VALUESET_CONCEPT vsc LEFT OUTER JOIN TRM_VALUESET_C_DESIGNATION vscd ON vsc.PID = vscd.VALUESET_CONCEPT_PID")
public class TermValueSetConceptView
implements Serializable,
ITermValueSetConceptView {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PID", length=1000)
    private String id;
    @Column(name="CONCEPT_PID")
    private Long myConceptPid;
    @Column(name="CONCEPT_VALUESET_PID")
    private Long myConceptValueSetPid;
    @Column(name="CONCEPT_VALUESET_ORDER")
    private int myConceptOrder;
    @Column(name="CONCEPT_SYSTEM_URL", length=200)
    private String myConceptSystemUrl;
    @Column(name="CONCEPT_CODEVAL", length=500)
    private String myConceptCode;
    @Column(name="CONCEPT_DISPLAY", length=400)
    private String myConceptDisplay;
    @Column(name="SYSTEM_VER", length=200)
    private String myConceptSystemVersion;
    @Column(name="DESIGNATION_PID")
    private Long myDesignationPid;
    @Column(name="DESIGNATION_LANG", length=500)
    private String myDesignationLang;
    @Column(name="DESIGNATION_USE_SYSTEM", length=500)
    private String myDesignationUseSystem;
    @Column(name="DESIGNATION_USE_CODE", length=500)
    private String myDesignationUseCode;
    @Column(name="DESIGNATION_USE_DISPLAY", length=500)
    private String myDesignationUseDisplay;
    @Column(name="DESIGNATION_VAL", length=2000)
    private String myDesignationVal;
    @Column(name="SOURCE_PID", nullable=true)
    private Long mySourceConceptPid;
    @Lob
    @Column(name="SOURCE_DIRECT_PARENT_PIDS", nullable=true)
    private Clob mySourceConceptDirectParentPids;

    @Override
    public Long getSourceConceptPid() {
        return this.mySourceConceptPid;
    }

    @Override
    public String getSourceConceptDirectParentPids() {
        if (this.mySourceConceptDirectParentPids != null) {
            String string;
            block9: {
                Reader characterStream = this.mySourceConceptDirectParentPids.getCharacterStream();
                try {
                    string = IOUtils.toString((Reader)characterStream);
                    if (characterStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (characterStream != null) {
                            try {
                                characterStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | SQLException e) {
                        throw new InternalErrorException(Msg.code((int)828) + e);
                    }
                }
                characterStream.close();
            }
            return string;
        }
        return null;
    }

    @Override
    public Long getConceptPid() {
        return this.myConceptPid;
    }

    @Override
    public String getConceptSystemUrl() {
        return this.myConceptSystemUrl;
    }

    @Override
    public String getConceptCode() {
        return this.myConceptCode;
    }

    @Override
    public String getConceptDisplay() {
        return this.myConceptDisplay;
    }

    @Override
    public Long getDesignationPid() {
        return this.myDesignationPid;
    }

    @Override
    public String getDesignationLang() {
        return this.myDesignationLang;
    }

    @Override
    public String getDesignationUseSystem() {
        return this.myDesignationUseSystem;
    }

    @Override
    public String getDesignationUseCode() {
        return this.myDesignationUseCode;
    }

    @Override
    public String getDesignationUseDisplay() {
        return this.myDesignationUseDisplay;
    }

    @Override
    public String getDesignationVal() {
        return this.myDesignationVal;
    }

    @Override
    public String getConceptSystemVersion() {
        return this.myConceptSystemVersion;
    }
}

