/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.esr;

import ca.uhn.fhir.jpa.esr.IExternallyStoredResourceService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ExternallyStoredResourceServiceRegistry {
    private static final String VALID_ID_PATTERN = "[a-zA-Z0-9_.-]+";
    private final Map<String, IExternallyStoredResourceService> myIdToProvider = new HashMap<String, IExternallyStoredResourceService>();

    public void registerProvider(@Nonnull IExternallyStoredResourceService theProvider) {
        String id = StringUtils.defaultString((String)theProvider.getId());
        Validate.isTrue((boolean)id.matches(VALID_ID_PATTERN), (String)"Invalid provider ID (must match pattern [a-zA-Z0-9_.-]+): %s", (Object[])new Object[]{id});
        Validate.isTrue((!this.myIdToProvider.containsKey(id) ? 1 : 0) != 0, (String)"Already have a provider with ID: %s", (Object[])new Object[]{id});
        this.myIdToProvider.put(id, theProvider);
    }

    public boolean hasProviders() {
        return !this.myIdToProvider.isEmpty();
    }

    public void clearProviders() {
        this.myIdToProvider.clear();
    }

    @Nonnull
    public IExternallyStoredResourceService getProvider(@Nonnull String theProviderId) {
        IExternallyStoredResourceService retVal = this.myIdToProvider.get(theProviderId);
        Validate.notNull((Object)retVal, (String)"Invalid ESR provider ID: %s", (Object[])new Object[]{theProviderId});
        return retVal;
    }
}

