/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.jpa.delete.DeleteConflictOutcome;
import ca.uhn.fhir.jpa.delete.DeleteConflictService;
import ca.uhn.fhir.jpa.delete.ThreadSafeResourceDeleterSvc;
import ca.uhn.fhir.rest.api.DeleteCascadeModeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class CascadingDeleteInterceptor {
    public static final int OVERRIDE_PATH_BASED_REF_INTEGRITY_INTERCEPTOR_ORDER = 0;
    public static final int CASCADING_DELETE_INTERCEPTOR_ORDER = 1;
    private static final Logger ourLog = LoggerFactory.getLogger(CascadingDeleteInterceptor.class);
    private static final String CASCADED_DELETES_KEY = CascadingDeleteInterceptor.class.getName() + "_CASCADED_DELETES_KEY";
    private static final String CASCADED_DELETES_FAILED_KEY = CascadingDeleteInterceptor.class.getName() + "_CASCADED_DELETES_FAILED_KEY";
    private final DaoRegistry myDaoRegistry;
    private final IInterceptorBroadcaster myInterceptorBroadcaster;
    private final FhirContext myFhirContext;
    private final ThreadSafeResourceDeleterSvc myThreadSafeResourceDeleterSvc;

    public CascadingDeleteInterceptor(@Nonnull FhirContext theFhirContext, @Nonnull DaoRegistry theDaoRegistry, @Nonnull IInterceptorBroadcaster theInterceptorBroadcaster, @Nonnull ThreadSafeResourceDeleterSvc theThreadSafeResourceDeleterSvc) {
        Validate.notNull((Object)theDaoRegistry, (String)"theDaoRegistry must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theInterceptorBroadcaster, (String)"theInterceptorBroadcaster must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theFhirContext, (String)"theFhirContext must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theThreadSafeResourceDeleterSvc, (String)"theSafeDeleter must not be null", (Object[])new Object[0]);
        this.myDaoRegistry = theDaoRegistry;
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
        this.myFhirContext = theFhirContext;
        this.myThreadSafeResourceDeleterSvc = theThreadSafeResourceDeleterSvc;
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_DELETE_CONFLICTS, order=1)
    public DeleteConflictOutcome handleDeleteConflicts(DeleteConflictList theConflictList, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        ourLog.debug("Have delete conflicts: {}", (Object)theConflictList);
        if (this.shouldCascade(theRequest) == DeleteCascadeModeEnum.NONE) {
            String message = this.myFhirContext.getLocalizer().getMessage(CascadingDeleteInterceptor.class, "noParam", new Object[0]);
            ourLog.trace(message);
            if (theRequest != null) {
                theRequest.getUserData().put(CASCADED_DELETES_FAILED_KEY, message);
            }
            return null;
        }
        this.myThreadSafeResourceDeleterSvc.delete(theRequest, theConflictList, theTransactionDetails);
        return new DeleteConflictOutcome().setShouldRetryCount(DeleteConflictService.MAX_RETRY_ATTEMPTS);
    }

    public static List<String> getCascadedDeletesList(RequestDetails theRequest, boolean theCreate) {
        ArrayList retVal = (ArrayList)theRequest.getUserData().get(CASCADED_DELETES_KEY);
        if (retVal == null && theCreate) {
            retVal = new ArrayList();
            theRequest.getUserData().put(CASCADED_DELETES_KEY, retVal);
        }
        return retVal;
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_FAILURE_OPERATIONOUTCOME)
    public void outgoingFailureOperationOutcome(RequestDetails theRequestDetails, IBaseOperationOutcome theResponse) {
        String failedDeleteMessage;
        if (theRequestDetails != null && StringUtils.isNotBlank((CharSequence)(failedDeleteMessage = (String)theRequestDetails.getUserData().get(CASCADED_DELETES_FAILED_KEY)))) {
            FhirContext ctx = theRequestDetails.getFhirContext();
            String severity = OperationOutcome.IssueSeverity.INFORMATION.toCode();
            String code = OperationOutcome.IssueType.INFORMATIONAL.toCode();
            String details = failedDeleteMessage;
            OperationOutcomeUtil.addIssue((FhirContext)ctx, (IBaseOperationOutcome)theResponse, (String)severity, (String)details, null, (String)code);
        }
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public void outgoingResponse(RequestDetails theRequestDetails, ResponseDetails theResponseDetails, IBaseResource theResponse) {
        List<String> deleteList;
        if (theRequestDetails != null && (deleteList = CascadingDeleteInterceptor.getCascadedDeletesList(theRequestDetails, false)) != null && theResponseDetails.getResponseCode() == 200 && theResponse instanceof IBaseOperationOutcome) {
            FhirContext ctx = theRequestDetails.getFhirContext();
            IBaseOperationOutcome oo = (IBaseOperationOutcome)theResponse;
            String severity = OperationOutcome.IssueSeverity.INFORMATION.toCode();
            String code = OperationOutcome.IssueType.INFORMATIONAL.toCode();
            String details = ctx.getLocalizer().getMessage(CascadingDeleteInterceptor.class, "successMsg", new Object[]{deleteList.size(), deleteList});
            OperationOutcomeUtil.addIssue((FhirContext)ctx, (IBaseOperationOutcome)oo, (String)severity, (String)details, null, (String)code);
        }
    }

    @Nonnull
    protected DeleteCascadeModeEnum shouldCascade(@Nullable RequestDetails theRequest) {
        return RestfulServerUtils.extractDeleteCascadeParameter((RequestDetails)theRequest).getMode();
    }
}

