/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.binary.api.IBinaryStorageSvc;
import ca.uhn.fhir.jpa.binary.svc.NullBinaryStorageSvcImpl;
import ca.uhn.fhir.jpa.dao.data.INpmPackageDao;
import ca.uhn.fhir.jpa.dao.data.INpmPackageVersionDao;
import ca.uhn.fhir.jpa.dao.data.INpmPackageVersionResourceDao;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.NpmPackageEntity;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionEntity;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.packages.IHapiPackageCacheManager;
import ca.uhn.fhir.jpa.packages.NpmPackageMetadataJson;
import ca.uhn.fhir.jpa.packages.NpmPackageSearchResultJson;
import ca.uhn.fhir.jpa.packages.PackageDeleteOutcomeJson;
import ca.uhn.fhir.jpa.packages.PackageInstallationSpec;
import ca.uhn.fhir.jpa.packages.PackageSearchSpec;
import ca.uhn.fhir.jpa.packages.PackageVersionComparator;
import ca.uhn.fhir.jpa.packages.loader.NpmPackageData;
import ca.uhn.fhir.jpa.packages.loader.PackageLoaderSvc;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.BinaryUtil;
import ca.uhn.fhir.util.ResourceUtil;
import ca.uhn.fhir.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.collections4.comparators.ReverseComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.npm.PackageServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaPackageCache
extends BasePackageCacheManager
implements IHapiPackageCacheManager {
    public static final String UTF8_BOM = "\ufeff";
    private static final Logger ourLog = LoggerFactory.getLogger(JpaPackageCache.class);
    private final Map<FhirVersionEnum, FhirContext> myVersionToContext = Collections.synchronizedMap(new HashMap());
    @PersistenceContext
    protected EntityManager myEntityManager;
    @Autowired
    private INpmPackageDao myPackageDao;
    @Autowired
    private INpmPackageVersionDao myPackageVersionDao;
    @Autowired
    private INpmPackageVersionResourceDao myPackageVersionResourceDao;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myCtx;
    @Autowired
    private PlatformTransactionManager myTxManager;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private PackageLoaderSvc myPackageLoaderSvc;
    @Autowired(required=false)
    private IBinaryStorageSvc myBinaryStorageSvc;

    public void addPackageServer(@Nonnull PackageServer thePackageServer) {
        assert (this.myPackageLoaderSvc != null);
        this.myPackageLoaderSvc.addPackageServer(thePackageServer);
    }

    public String getPackageId(String theS) throws IOException {
        return this.myPackageLoaderSvc.getPackageId(theS);
    }

    public void setSilent(boolean silent) {
        this.myPackageLoaderSvc.setSilent(silent);
    }

    public String getPackageUrl(String theS) throws IOException {
        return this.myPackageLoaderSvc.getPackageUrl(theS);
    }

    public List<PackageServer> getPackageServers() {
        return this.myPackageLoaderSvc.getPackageServers();
    }

    protected BasePackageCacheManager.InputStreamWithSrc loadFromPackageServer(String id, String version) {
        throw new UnsupportedOperationException(Msg.code((int)2220) + "Use PackageLoaderSvc for loading packages.");
    }

    @Transactional
    public NpmPackage loadPackageFromCacheOnly(String theId, @Nullable String theVersion) {
        Optional<NpmPackageVersionEntity> packageVersion = this.loadPackageVersionEntity(theId, theVersion);
        if (!packageVersion.isPresent() && theVersion.endsWith(".x")) {
            String lookupVersion = theVersion;
            while ((lookupVersion = lookupVersion.substring(0, lookupVersion.length() - 2)).endsWith(".x")) {
            }
            List<String> candidateVersionIds = this.myPackageVersionDao.findVersionIdsByPackageIdAndLikeVersion(theId, lookupVersion + ".%");
            if (candidateVersionIds.size() > 0) {
                candidateVersionIds.sort(PackageVersionComparator.INSTANCE);
                packageVersion = this.loadPackageVersionEntity(theId, candidateVersionIds.get(candidateVersionIds.size() - 1));
            }
        }
        return packageVersion.map(t -> this.loadPackage((NpmPackageVersionEntity)t)).orElse(null);
    }

    private Optional<NpmPackageVersionEntity> loadPackageVersionEntity(String theId, @Nullable String theVersion) {
        Validate.notBlank((CharSequence)theId, (String)"theId must be populated", (Object[])new Object[0]);
        Optional<NpmPackageVersionEntity> packageVersion = Optional.empty();
        if (StringUtils.isNotBlank((CharSequence)theVersion) && !"latest".equals(theVersion)) {
            packageVersion = this.myPackageVersionDao.findByPackageIdAndVersion(theId, theVersion);
        } else {
            Optional<NpmPackageEntity> pkg = this.myPackageDao.findByPackageId(theId);
            if (pkg.isPresent()) {
                packageVersion = this.myPackageVersionDao.findByPackageIdAndVersion(theId, pkg.get().getCurrentVersionId());
            }
        }
        return packageVersion;
    }

    private NpmPackage loadPackage(NpmPackageVersionEntity thePackageVersion) {
        IHapiPackageCacheManager.PackageContents content = this.loadPackageContents(thePackageVersion);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        try {
            return NpmPackage.fromPackage((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code((int)1294) + e);
        }
    }

    private IHapiPackageCacheManager.PackageContents loadPackageContents(NpmPackageVersionEntity thePackageVersion) {
        IFhirResourceDao<IBaseBinary> binaryDao = this.getBinaryDao();
        IBaseBinary binary = (IBaseBinary)binaryDao.readByPid((IResourcePersistentId)JpaPid.fromId((Long)thePackageVersion.getPackageBinary().getId()));
        try {
            byte[] content = this.fetchBlobFromBinary(binary);
            IHapiPackageCacheManager.PackageContents retVal = new IHapiPackageCacheManager.PackageContents().setBytes(content).setPackageId(thePackageVersion.getPackageId()).setVersion(thePackageVersion.getVersionId()).setLastModified(thePackageVersion.getUpdatedTime());
            return retVal;
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code((int)1295) + "Failed to load package. There was a problem reading binaries", (Throwable)e);
        }
    }

    private byte[] fetchBlobFromBinary(IBaseBinary theBinary) throws IOException {
        if (this.myBinaryStorageSvc != null && !(this.myBinaryStorageSvc instanceof NullBinaryStorageSvcImpl)) {
            return this.myBinaryStorageSvc.fetchDataBlobFromBinary(theBinary);
        }
        byte[] value = (byte[])BinaryUtil.getOrCreateData((FhirContext)this.myCtx, (IBaseBinary)theBinary).getValue();
        if (value == null) {
            throw new InternalErrorException(Msg.code((int)1296) + "Failed to fetch blob from Binary/" + theBinary.getIdElement());
        }
        return value;
    }

    private IFhirResourceDao<IBaseBinary> getBinaryDao() {
        return this.myDaoRegistry.getResourceDao("Binary");
    }

    private NpmPackage addPackageToCacheInternal(NpmPackageData thePackageData) {
        NpmPackage npmPackage = thePackageData.getPackage();
        String packageId = thePackageData.getPackageId();
        String initialPackageVersionId = thePackageData.getPackageVersionId();
        byte[] bytes = thePackageData.getBytes();
        if (!npmPackage.id().equalsIgnoreCase(packageId)) {
            throw new InvalidRequestException(Msg.code((int)1297) + "Package ID " + npmPackage.id() + " doesn't match expected: " + packageId);
        }
        if (!PackageVersionComparator.isEquivalent(initialPackageVersionId, npmPackage.version())) {
            throw new InvalidRequestException(Msg.code((int)1298) + "Package ID " + npmPackage.version() + " doesn't match expected: " + initialPackageVersionId);
        }
        String packageVersionId = npmPackage.version();
        FhirVersionEnum fhirVersion = FhirVersionEnum.forVersionString((String)npmPackage.fhirVersion());
        if (fhirVersion == null) {
            throw new InvalidRequestException(Msg.code((int)1299) + "Unknown FHIR version: " + npmPackage.fhirVersion());
        }
        FhirContext packageContext = this.getFhirContext(fhirVersion);
        IBaseBinary binary = this.createPackageBinary(bytes);
        return (NpmPackage)this.newTxTemplate().execute(tx -> {
            ResourceTable persistedPackage = this.createResourceBinary(binary);
            NpmPackageEntity pkg = this.myPackageDao.findByPackageId(packageId).orElseGet(() -> this.createPackage(npmPackage));
            NpmPackageVersionEntity packageVersion = this.myPackageVersionDao.findByPackageIdAndVersion(packageId, packageVersionId).orElse(null);
            if (packageVersion != null) {
                NpmPackage existingPackage = this.loadPackageFromCacheOnly(packageVersion.getPackageId(), packageVersion.getVersionId());
                String msg = "Package version already exists in local storage, no action taken: " + packageId + "#" + packageVersionId;
                JpaPackageCache.getProcessingMessages(existingPackage).add(msg);
                ourLog.info(msg);
                return existingPackage;
            }
            boolean currentVersion = this.updateCurrentVersionFlagForAllPackagesBasedOnNewIncomingVersion(packageId, packageVersionId);
            Object packageDesc = null;
            if (npmPackage.description() != null) {
                packageDesc = npmPackage.description().length() > 200 ? npmPackage.description().substring(0, 196) + "..." : npmPackage.description();
            }
            if (currentVersion) {
                JpaPackageCache.getProcessingMessages(npmPackage).add("Marking package " + packageId + "#" + initialPackageVersionId + " as current version");
                pkg.setCurrentVersionId(packageVersionId);
                pkg.setDescription((String)packageDesc);
                this.myPackageDao.save(pkg);
            } else {
                JpaPackageCache.getProcessingMessages(npmPackage).add("Package " + packageId + "#" + initialPackageVersionId + " is not the newest version");
            }
            packageVersion = new NpmPackageVersionEntity();
            packageVersion.setPackageId(packageId);
            packageVersion.setVersionId(packageVersionId);
            packageVersion.setPackage(pkg);
            packageVersion.setPackageBinary(persistedPackage);
            packageVersion.setSavedTime(new Date());
            packageVersion.setDescription((String)packageDesc);
            packageVersion.setFhirVersionId(npmPackage.fhirVersion());
            packageVersion.setFhirVersion(fhirVersion);
            packageVersion.setCurrentVersion(currentVersion);
            packageVersion.setPackageSizeBytes((long)bytes.length);
            packageVersion = (NpmPackageVersionEntity)this.myPackageVersionDao.save(packageVersion);
            String dirName = "package";
            NpmPackage.NpmPackageFolder packageFolder = (NpmPackage.NpmPackageFolder)npmPackage.getFolders().get(dirName);
            Map packageFolderTypes = null;
            try {
                packageFolderTypes = packageFolder.getTypes();
            }
            catch (IOException e) {
                throw new InternalErrorException(Msg.code((int)2371) + e);
            }
            for (Map.Entry nextTypeToFiles : packageFolderTypes.entrySet()) {
                String nextType = (String)nextTypeToFiles.getKey();
                for (String nextFile : (List)nextTypeToFiles.getValue()) {
                    IBaseResource resource;
                    String contentsString;
                    byte[] contents;
                    try {
                        contents = packageFolder.fetchFile(nextFile);
                        contentsString = StringUtil.toUtf8String((byte[])contents);
                    }
                    catch (IOException e) {
                        throw new InternalErrorException(Msg.code((int)1300) + e);
                    }
                    if (nextFile.toLowerCase().endsWith(".xml")) {
                        resource = packageContext.newXmlParser().parseResource(contentsString);
                    } else if (nextFile.toLowerCase().endsWith(".json")) {
                        resource = packageContext.newJsonParser().parseResource(contentsString);
                    } else {
                        JpaPackageCache.getProcessingMessages(npmPackage).add("Not indexing file: " + nextFile);
                        continue;
                    }
                    String contentType = "application/fhir+json";
                    ResourceUtil.removeNarrative((FhirContext)packageContext, (IBaseResource)resource);
                    byte[] minimizedContents = packageContext.newJsonParser().encodeResourceToString(resource).getBytes(StandardCharsets.UTF_8);
                    IBaseBinary resourceBinary = this.createPackageResourceBinary(nextFile, minimizedContents, contentType);
                    ResourceTable persistedResource = this.createResourceBinary(resourceBinary);
                    NpmPackageVersionResourceEntity resourceEntity = new NpmPackageVersionResourceEntity();
                    resourceEntity.setPackageVersion(packageVersion);
                    resourceEntity.setResourceBinary(persistedResource);
                    resourceEntity.setDirectory(dirName);
                    resourceEntity.setFhirVersionId(npmPackage.fhirVersion());
                    resourceEntity.setFhirVersion(fhirVersion);
                    resourceEntity.setFilename(nextFile);
                    resourceEntity.setResourceType(nextType);
                    resourceEntity.setResSizeBytes((long)contents.length);
                    BaseRuntimeChildDefinition urlChild = packageContext.getResourceDefinition(nextType).getChildByName("url");
                    BaseRuntimeChildDefinition versionChild = packageContext.getResourceDefinition(nextType).getChildByName("version");
                    String url = null;
                    String version = null;
                    if (urlChild != null) {
                        url = urlChild.getAccessor().getFirstValueOrNull((IBase)resource).map(t -> ((IPrimitiveType)t).getValueAsString()).orElse(null);
                        resourceEntity.setCanonicalUrl(url);
                        version = versionChild.getAccessor().getFirstValueOrNull((IBase)resource).map(t -> ((IPrimitiveType)t).getValueAsString()).orElse(null);
                        resourceEntity.setCanonicalVersion(version);
                    }
                    this.myPackageVersionResourceDao.save(resourceEntity);
                    String resType = packageContext.getResourceType(resource);
                    String msg = "Indexing " + resType + " Resource[" + dirName + "/" + nextFile + "] with URL: " + StringUtils.defaultString((String)url) + "|" + StringUtils.defaultString(version);
                    JpaPackageCache.getProcessingMessages(npmPackage).add(msg);
                    ourLog.info("Package[{}#{}] " + msg, (Object)packageId, (Object)packageVersionId);
                }
            }
            JpaPackageCache.getProcessingMessages(npmPackage).add("Successfully added package " + npmPackage.id() + "#" + npmPackage.version() + " to registry");
            return npmPackage;
        });
    }

    public NpmPackage addPackageToCache(String thePackageId, String thePackageVersionId, InputStream thePackageTgzInputStream, String theSourceDesc) throws IOException {
        NpmPackageData npmData = this.myPackageLoaderSvc.createNpmPackageDataFromData(thePackageId, thePackageVersionId, theSourceDesc, thePackageTgzInputStream);
        return this.addPackageToCacheInternal(npmData);
    }

    private ResourceTable createResourceBinary(IBaseBinary theResourceBinary) {
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            SystemRequestDetails requestDetails = new SystemRequestDetails();
            if (this.myPartitionSettings.isUnnamedPartitionMode() && this.myPartitionSettings.getDefaultPartitionId() != null) {
                requestDetails.setRequestPartitionId(RequestPartitionId.fromPartitionId((Integer)this.myPartitionSettings.getDefaultPartitionId()));
            } else {
                requestDetails.setTenantId("DEFAULT");
            }
            return (ResourceTable)this.getBinaryDao().create((IBaseResource)theResourceBinary, (RequestDetails)requestDetails).getEntity();
        }
        return (ResourceTable)this.getBinaryDao().create((IBaseResource)theResourceBinary).getEntity();
    }

    private boolean updateCurrentVersionFlagForAllPackagesBasedOnNewIncomingVersion(String thePackageId, String thePackageVersion) {
        Collection<NpmPackageVersionEntity> existingVersions = this.myPackageVersionDao.findByPackageId(thePackageId);
        boolean retVal = true;
        for (NpmPackageVersionEntity next : existingVersions) {
            int cmp = PackageVersionComparator.INSTANCE.compare(next.getVersionId(), thePackageVersion);
            assert (cmp != 0);
            if (cmp < 0) {
                if (!next.isCurrentVersion()) continue;
                next.setCurrentVersion(false);
                this.myPackageVersionDao.save(next);
                continue;
            }
            retVal = false;
        }
        return retVal;
    }

    @Nonnull
    public FhirContext getFhirContext(FhirVersionEnum theFhirVersion) {
        return this.myVersionToContext.computeIfAbsent(theFhirVersion, v -> new FhirContext(v));
    }

    private IBaseBinary createPackageBinary(byte[] theBytes) {
        IBaseBinary binary = BinaryUtil.newBinary((FhirContext)this.myCtx);
        BinaryUtil.setData((FhirContext)this.myCtx, (IBaseBinary)binary, (byte[])theBytes, (String)"application/gzip");
        return binary;
    }

    private IBaseBinary createPackageResourceBinary(String theFileName, byte[] theBytes, String theContentType) {
        IBaseBinary binary = BinaryUtil.newBinary((FhirContext)this.myCtx);
        BinaryUtil.setData((FhirContext)this.myCtx, (IBaseBinary)binary, (byte[])theBytes, (String)theContentType);
        return binary;
    }

    private NpmPackageEntity createPackage(NpmPackage theNpmPackage) {
        NpmPackageEntity entity = new NpmPackageEntity();
        entity.setPackageId(theNpmPackage.id());
        entity.setCurrentVersionId(theNpmPackage.version());
        return (NpmPackageEntity)this.myPackageDao.save(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public NpmPackage loadPackage(String thePackageId, String thePackageVersion) throws FHIRException, IOException {
        NpmPackage cachedPackage = this.loadPackageFromCacheOnly(thePackageId, thePackageVersion);
        if (cachedPackage != null) {
            return cachedPackage;
        }
        NpmPackageData pkgData = this.myPackageLoaderSvc.fetchPackageFromPackageSpec(thePackageId, thePackageVersion);
        try {
            NpmPackage retVal = this.addPackageToCacheInternal(pkgData);
            JpaPackageCache.getProcessingMessages(retVal).add(0, "Package fetched from server at: " + pkgData.getPackage().url());
            NpmPackage npmPackage = retVal;
            return npmPackage;
        }
        finally {
            pkgData.getInputStream().close();
        }
    }

    public NpmPackage loadPackage(String theS) throws FHIRException, IOException {
        return this.loadPackage(theS, null);
    }

    private TransactionTemplate newTxTemplate() {
        return new TransactionTemplate(this.myTxManager);
    }

    @Override
    @Transactional(propagation=Propagation.NEVER)
    public NpmPackage installPackage(PackageInstallationSpec theInstallationSpec) throws IOException {
        Validate.notBlank((CharSequence)theInstallationSpec.getName(), (String)"thePackageId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theInstallationSpec.getVersion(), (String)"thePackageVersion must not be blank", (Object[])new Object[0]);
        String sourceDescription = "Embedded content";
        if (StringUtils.isNotBlank((CharSequence)theInstallationSpec.getPackageUrl())) {
            byte[] contents = this.myPackageLoaderSvc.loadPackageUrlContents(theInstallationSpec.getPackageUrl());
            theInstallationSpec.setPackageContents(contents);
            sourceDescription = theInstallationSpec.getPackageUrl();
        }
        if (theInstallationSpec.getPackageContents() != null) {
            return this.addPackageToCache(theInstallationSpec.getName(), theInstallationSpec.getVersion(), new ByteArrayInputStream(theInstallationSpec.getPackageContents()), sourceDescription);
        }
        return (NpmPackage)this.newTxTemplate().execute(tx -> {
            try {
                return this.loadPackage(theInstallationSpec.getName(), theInstallationSpec.getVersion());
            }
            catch (IOException e) {
                throw new InternalErrorException(Msg.code((int)1302) + e);
            }
        });
    }

    @Override
    @Transactional
    public IBaseResource loadPackageAssetByUrl(FhirVersionEnum theFhirVersion, String theCanonicalUrl) {
        Slice<NpmPackageVersionResourceEntity> slice;
        String canonicalUrl = theCanonicalUrl;
        int versionSeparator = canonicalUrl.lastIndexOf(124);
        if (versionSeparator != -1) {
            String canonicalVersion = canonicalUrl.substring(versionSeparator + 1);
            canonicalUrl = canonicalUrl.substring(0, versionSeparator);
            slice = this.myPackageVersionResourceDao.findCurrentVersionByCanonicalUrlAndVersion((Pageable)PageRequest.of((int)0, (int)1), theFhirVersion, canonicalUrl, canonicalVersion);
        } else {
            slice = this.myPackageVersionResourceDao.findCurrentVersionByCanonicalUrl((Pageable)PageRequest.of((int)0, (int)1), theFhirVersion, canonicalUrl);
        }
        if (slice.isEmpty()) {
            return null;
        }
        NpmPackageVersionResourceEntity contents = (NpmPackageVersionResourceEntity)slice.getContent().get(0);
        return this.loadPackageEntity(contents);
    }

    private IBaseResource loadPackageEntity(NpmPackageVersionResourceEntity contents) {
        try {
            JpaPid binaryPid = JpaPid.fromId((Long)contents.getResourceBinary().getId());
            IBaseBinary binary = (IBaseBinary)this.getBinaryDao().readByPid((IResourcePersistentId)binaryPid);
            byte[] resourceContentsBytes = this.fetchBlobFromBinary(binary);
            String resourceContents = new String(resourceContentsBytes, StandardCharsets.UTF_8);
            FhirContext packageContext = this.getFhirContext(contents.getFhirVersion());
            return EncodingEnum.detectEncoding((String)resourceContents).newParser(packageContext).parseResource(resourceContents);
        }
        catch (Exception e) {
            throw new RuntimeException(Msg.code((int)1305) + "Failed to load package resource " + contents, e);
        }
    }

    @Override
    @Transactional
    public NpmPackageMetadataJson loadPackageMetadata(String thePackageId) {
        NpmPackageMetadataJson retVal = new NpmPackageMetadataJson();
        Optional<NpmPackageEntity> pkg = this.myPackageDao.findByPackageId(thePackageId);
        if (!pkg.isPresent()) {
            throw new ResourceNotFoundException(Msg.code((int)1306) + "Unknown package ID: " + thePackageId);
        }
        ArrayList<NpmPackageVersionEntity> packageVersions = new ArrayList<NpmPackageVersionEntity>(this.myPackageVersionDao.findByPackageId(thePackageId));
        packageVersions.sort((Comparator<NpmPackageVersionEntity>)new ReverseComparator((o1, o2) -> PackageVersionComparator.INSTANCE.compare(o1.getVersionId(), o2.getVersionId())));
        for (NpmPackageVersionEntity next : packageVersions) {
            if (next.isCurrentVersion()) {
                retVal.setDistTags(new NpmPackageMetadataJson.DistTags().setLatest(next.getVersionId()));
            }
            NpmPackageMetadataJson.Version version = new NpmPackageMetadataJson.Version();
            version.setFhirVersion(next.getFhirVersionId());
            version.setDescription(next.getDescription());
            version.setName(next.getPackageId());
            version.setVersion(next.getVersionId());
            version.setBytes(next.getPackageSizeBytes());
            retVal.addVersion(version);
        }
        return retVal;
    }

    @Override
    @Transactional
    public IHapiPackageCacheManager.PackageContents loadPackageContents(String thePackageId, String theVersion) {
        Optional<NpmPackageVersionEntity> entity = this.loadPackageVersionEntity(thePackageId, theVersion);
        return entity.map(t -> this.loadPackageContents((NpmPackageVersionEntity)t)).orElse(null);
    }

    @Override
    @Transactional
    public NpmPackageSearchResultJson search(PackageSearchSpec thePackageSearchSpec) {
        NpmPackageSearchResultJson retVal = new NpmPackageSearchResultJson();
        CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery countCriteriaQuery = cb.createQuery(Long.class);
        Root countCriteriaRoot = countCriteriaQuery.from(NpmPackageVersionEntity.class);
        countCriteriaQuery.multiselect(new Selection[]{cb.countDistinct((Expression)countCriteriaRoot.get("myPackageId"))});
        List<Predicate> predicates = this.createSearchPredicates(thePackageSearchSpec, cb, (Root<NpmPackageVersionEntity>)countCriteriaRoot);
        countCriteriaQuery.where(QueryParameterUtils.toPredicateArray(predicates));
        Long total = (Long)this.myEntityManager.createQuery(countCriteriaQuery).getSingleResult();
        retVal.setTotal(Math.toIntExact(total));
        CriteriaQuery criteriaQuery = cb.createQuery(NpmPackageVersionEntity.class);
        Root root = criteriaQuery.from(NpmPackageVersionEntity.class);
        predicates = this.createSearchPredicates(thePackageSearchSpec, cb, (Root<NpmPackageVersionEntity>)root);
        criteriaQuery.where(QueryParameterUtils.toPredicateArray(predicates));
        criteriaQuery.orderBy(new Order[]{cb.asc((Expression)root.get("myPackageId"))});
        TypedQuery query = this.myEntityManager.createQuery(criteriaQuery);
        query.setFirstResult(thePackageSearchSpec.getStart());
        query.setMaxResults(thePackageSearchSpec.getSize());
        List resultList = query.getResultList();
        for (NpmPackageVersionEntity next : resultList) {
            if (!retVal.hasPackageWithId(next.getPackageId())) {
                retVal.addObject().getPackage().setName(next.getPackageId()).setDescription(next.getPackage().getDescription()).setVersion(next.getVersionId()).addFhirVersion(next.getFhirVersionId()).setBytes(next.getPackageSizeBytes());
                continue;
            }
            NpmPackageSearchResultJson.Package retPackage = retVal.getPackageWithId(next.getPackageId());
            retPackage.addFhirVersion(next.getFhirVersionId());
            int cmp = PackageVersionComparator.INSTANCE.compare(next.getVersionId(), retPackage.getVersion());
            if (cmp <= 0) continue;
            retPackage.setVersion(next.getVersionId());
        }
        return retVal;
    }

    @Override
    @Transactional
    public PackageDeleteOutcomeJson uninstallPackage(String thePackageId, String theVersion) {
        PackageDeleteOutcomeJson retVal = new PackageDeleteOutcomeJson();
        Optional<NpmPackageVersionEntity> packageVersion = this.myPackageVersionDao.findByPackageIdAndVersion(thePackageId, theVersion);
        if (packageVersion.isPresent()) {
            String msg = "Deleting package " + thePackageId + "#" + theVersion;
            ourLog.info(msg);
            retVal.getMessage().add(msg);
            for (NpmPackageVersionResourceEntity next : packageVersion.get().getResources()) {
                msg = "Deleting package +" + thePackageId + "#" + theVersion + "resource: " + next.getCanonicalUrl();
                ourLog.info(msg);
                retVal.getMessage().add(msg);
                this.myPackageVersionResourceDao.delete(next);
                ExpungeOptions options = new ExpungeOptions();
                options.setExpungeDeletedResources(true).setExpungeOldVersions(true);
                this.deleteAndExpungeResourceBinary((IIdType)next.getResourceBinary().getIdDt().toVersionless(), options);
            }
            this.myPackageVersionDao.delete(packageVersion.get());
            ExpungeOptions options = new ExpungeOptions();
            options.setExpungeDeletedResources(true).setExpungeOldVersions(true);
            this.deleteAndExpungeResourceBinary((IIdType)packageVersion.get().getPackageBinary().getIdDt().toVersionless(), options);
            Collection<NpmPackageVersionEntity> remainingVersions = this.myPackageVersionDao.findByPackageId(thePackageId);
            if (remainingVersions.size() == 0) {
                msg = "No versions of package " + thePackageId + " remain";
                ourLog.info(msg);
                retVal.getMessage().add(msg);
                Optional<NpmPackageEntity> pkgEntity = this.myPackageDao.findByPackageId(thePackageId);
                this.myPackageDao.delete(pkgEntity.get());
            } else {
                List versions = remainingVersions.stream().sorted((o1, o2) -> PackageVersionComparator.INSTANCE.compare(o1.getVersionId(), o2.getVersionId())).collect(Collectors.toList());
                for (int i = 0; i < versions.size(); ++i) {
                    boolean isCurrent;
                    boolean bl = isCurrent = i == versions.size() - 1;
                    if (isCurrent == ((NpmPackageVersionEntity)versions.get(i)).isCurrentVersion()) continue;
                    ((NpmPackageVersionEntity)versions.get(i)).setCurrentVersion(isCurrent);
                    this.myPackageVersionDao.save((NpmPackageVersionEntity)versions.get(i));
                }
            }
        } else {
            String msg = "No package found with the given ID";
            retVal.getMessage().add(msg);
        }
        return retVal;
    }

    @Override
    @Transactional
    public List<IBaseResource> loadPackageAssetsByType(FhirVersionEnum theFhirVersion, String theResourceType) {
        Slice<NpmPackageVersionResourceEntity> outcome = this.myPackageVersionResourceDao.findCurrentVersionByResourceType((Pageable)PageRequest.of((int)0, (int)1000), theFhirVersion, theResourceType);
        return outcome.stream().map(t -> this.loadPackageEntity((NpmPackageVersionResourceEntity)t)).collect(Collectors.toList());
    }

    private void deleteAndExpungeResourceBinary(IIdType theResourceBinaryId, ExpungeOptions theOptions) {
        this.getBinaryDao().delete(theResourceBinaryId, (RequestDetails)new SystemRequestDetails()).getEntity();
        this.getBinaryDao().forceExpungeInExistingTransaction(theResourceBinaryId, theOptions, (RequestDetails)new SystemRequestDetails());
    }

    @Nonnull
    public List<Predicate> createSearchPredicates(PackageSearchSpec thePackageSearchSpec, CriteriaBuilder theCb, Root<NpmPackageVersionEntity> theRoot) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotBlank((CharSequence)thePackageSearchSpec.getResourceUrl())) {
            Join resources = theRoot.join("myResources", JoinType.LEFT);
            predicates.add(theCb.equal(resources.get("myCanonicalUrl").as(String.class), (Object)thePackageSearchSpec.getResourceUrl()));
        }
        if (StringUtils.isNotBlank((CharSequence)thePackageSearchSpec.getDescription())) {
            Object searchTerm = "%" + thePackageSearchSpec.getDescription() + "%";
            searchTerm = StringUtil.normalizeStringForSearchIndexing((String)searchTerm);
            predicates.add(theCb.like(theRoot.get("myDescriptionUpper").as(String.class), (String)searchTerm));
        }
        if (StringUtils.isNotBlank((CharSequence)thePackageSearchSpec.getFhirVersion())) {
            if (!thePackageSearchSpec.getFhirVersion().matches("([0-9]+\\.)+[0-9]+")) {
                FhirVersionEnum versionEnum = FhirVersionEnum.forVersionString((String)thePackageSearchSpec.getFhirVersion());
                if (versionEnum != null) {
                    predicates.add(theCb.equal(theRoot.get("myFhirVersion").as(FhirVersionEnum.class), (Object)versionEnum));
                }
            } else {
                predicates.add(theCb.like(theRoot.get("myFhirVersionId").as(String.class), thePackageSearchSpec.getFhirVersion() + "%"));
            }
        }
        return predicates;
    }

    public static List<String> getProcessingMessages(NpmPackage thePackage) {
        return (List)thePackage.getUserData().computeIfAbsent("JpPackageCache_ProcessingMessages", t -> new ArrayList());
    }
}

