/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages;

import java.math.BigDecimal;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;

public class PackageVersionComparator
implements Comparator<String> {
    public static final PackageVersionComparator INSTANCE = new PackageVersionComparator();

    @Override
    public int compare(String o1, String o2) {
        String[] o1parts = o1.split("\\.");
        String[] o2parts = o2.split("\\.");
        for (int i = 0; i < o1parts.length && i < o2parts.length; ++i) {
            int cmp;
            String i1part = o1parts[i];
            String i2part = o2parts[i];
            if (StringUtils.isNumeric((CharSequence)i1part) && StringUtils.isNumeric((CharSequence)i2part) && (cmp = new BigDecimal(i1part).compareTo(new BigDecimal(i2part))) != 0) {
                return cmp;
            }
            cmp = i1part.compareTo(i2part);
            if (cmp == 0) continue;
            return cmp;
        }
        return o1parts.length - o2parts.length;
    }

    public static boolean isEquivalent(String theSpec, String thePackageVersion) {
        String[] o1parts = theSpec.split("\\.");
        String[] o2parts = thePackageVersion.split("\\.");
        for (int i = 0; i < o1parts.length; ++i) {
            if (o1parts[i].equals("x") || o1parts[i].equals(o2parts[i])) continue;
            return false;
        }
        return true;
    }
}

