/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.partition;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.entity.PartitionEntity;
import ca.uhn.fhir.jpa.partition.IPartitionLookupSvc;
import ca.uhn.fhir.jpa.partition.PartitionLookupSvcImpl;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PartitionManagementProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(PartitionLookupSvcImpl.class);
    @Autowired
    private FhirContext myCtx;
    @Autowired
    private IPartitionLookupSvc myPartitionLookupSvc;

    @Operation(name="$partition-management-create-partition")
    public IBaseParameters addPartition(@ResourceParam IBaseParameters theRequest, @OperationParam(name="id", min=1, max=1, typeName="integer") IPrimitiveType<Integer> thePartitionId, @OperationParam(name="name", min=1, max=1, typeName="code") IPrimitiveType<String> thePartitionName, @OperationParam(name="description", min=0, max=1, typeName="string") IPrimitiveType<String> thePartitionDescription, RequestDetails theRequestDetails) {
        if (thePartitionId == null && thePartitionName != null && thePartitionName.hasValue()) {
            thePartitionId = this.requestRandomPartitionId(thePartitionName);
        }
        PartitionLookupSvcImpl.validatePartitionIdSupplied(this.myCtx, (Integer)IPrimitiveType.toValueOrNull(thePartitionId));
        PartitionEntity input = this.parseInput(thePartitionId, thePartitionName, thePartitionDescription);
        PartitionEntity output = this.myPartitionLookupSvc.createPartition(input, theRequestDetails);
        IBaseParameters retVal = this.prepareOutput(output);
        return retVal;
    }

    @Nonnull
    private IPrimitiveType<Integer> requestRandomPartitionId(IPrimitiveType<String> thePartitionName) {
        int unusedPartitionId = this.myPartitionLookupSvc.generateRandomUnusedPartitionId();
        ourLog.info("Request to create partition came in without a partition ID. Auto-assigning an available ID.[partition_id={}, partition_name={}]", (Object)unusedPartitionId, thePartitionName);
        return new IntegerDt(unusedPartitionId);
    }

    @Operation(name="$partition-management-read-partition", idempotent=true)
    public IBaseParameters addPartition(@ResourceParam IBaseParameters theRequest, @OperationParam(name="id", min=1, max=1, typeName="integer") IPrimitiveType<Integer> thePartitionId) {
        PartitionLookupSvcImpl.validatePartitionIdSupplied(this.myCtx, (Integer)IPrimitiveType.toValueOrNull(thePartitionId));
        PartitionEntity output = this.myPartitionLookupSvc.getPartitionById((Integer)thePartitionId.getValue());
        return this.prepareOutput(output);
    }

    @Operation(name="$partition-management-update-partition")
    public IBaseParameters updatePartition(@ResourceParam IBaseParameters theRequest, @OperationParam(name="id", min=1, max=1, typeName="integer") IPrimitiveType<Integer> thePartitionId, @OperationParam(name="name", min=1, max=1, typeName="code") IPrimitiveType<String> thePartitionName, @OperationParam(name="description", min=0, max=1, typeName="string") IPrimitiveType<String> thePartitionDescription) {
        PartitionLookupSvcImpl.validatePartitionIdSupplied(this.myCtx, (Integer)IPrimitiveType.toValueOrNull(thePartitionId));
        PartitionEntity input = this.parseInput(thePartitionId, thePartitionName, thePartitionDescription);
        PartitionEntity output = this.myPartitionLookupSvc.updatePartition(input);
        IBaseParameters retVal = this.prepareOutput(output);
        return retVal;
    }

    @Operation(name="$partition-management-delete-partition")
    public IBaseParameters updatePartition(@ResourceParam IBaseParameters theRequest, @OperationParam(name="id", min=1, max=1, typeName="integer") IPrimitiveType<Integer> thePartitionId) {
        PartitionLookupSvcImpl.validatePartitionIdSupplied(this.myCtx, (Integer)IPrimitiveType.toValueOrNull(thePartitionId));
        this.myPartitionLookupSvc.deletePartition((Integer)thePartitionId.getValue());
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myCtx);
        ParametersUtil.addParameterToParametersString((FhirContext)this.myCtx, (IBaseParameters)retVal, (String)"message", (String)"Success");
        return retVal;
    }

    @Operation(name="$partition-management-list-partitions", idempotent=true)
    public IBaseParameters addPartitions(@ResourceParam IBaseParameters theRequest) {
        List<PartitionEntity> output = this.myPartitionLookupSvc.listPartitions();
        return this.prepareOutputList(output);
    }

    private IBaseParameters prepareOutput(PartitionEntity theOutput) {
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myCtx);
        ParametersUtil.addParameterToParametersInteger((FhirContext)this.myCtx, (IBaseParameters)retVal, (String)"id", (int)theOutput.getId());
        ParametersUtil.addParameterToParametersCode((FhirContext)this.myCtx, (IBaseParameters)retVal, (String)"name", (String)theOutput.getName());
        if (StringUtils.isNotBlank((CharSequence)theOutput.getDescription())) {
            ParametersUtil.addParameterToParametersString((FhirContext)this.myCtx, (IBaseParameters)retVal, (String)"description", (String)theOutput.getDescription());
        }
        return retVal;
    }

    private IBaseParameters prepareOutputList(List<PartitionEntity> theOutput) {
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.myCtx);
        for (PartitionEntity partitionEntity : theOutput) {
            IBase resultPart = ParametersUtil.addParameterToParameters((FhirContext)this.myCtx, (IBaseParameters)retVal, (String)"partition");
            ParametersUtil.addPartInteger((FhirContext)this.myCtx, (IBase)resultPart, (String)"id", (Integer)partitionEntity.getId());
            ParametersUtil.addPartCode((FhirContext)this.myCtx, (IBase)resultPart, (String)"name", (String)partitionEntity.getName());
            if (!StringUtils.isNotBlank((CharSequence)partitionEntity.getDescription())) continue;
            ParametersUtil.addPartString((FhirContext)this.myCtx, (IBase)resultPart, (String)"description", (String)partitionEntity.getDescription());
        }
        return retVal;
    }

    @Nonnull
    private PartitionEntity parseInput(@OperationParam(name="id", min=1, max=1, typeName="integer") IPrimitiveType<Integer> thePartitionId, @OperationParam(name="name", min=1, max=1, typeName="code") IPrimitiveType<String> thePartitionName, @OperationParam(name="description", min=0, max=1, typeName="string") IPrimitiveType<String> thePartitionDescription) {
        PartitionEntity input = new PartitionEntity();
        if (thePartitionId != null) {
            input.setId((Integer)thePartitionId.getValue());
        }
        if (thePartitionName != null) {
            input.setName((String)thePartitionName.getValue());
        }
        if (thePartitionDescription != null) {
            input.setDescription((String)thePartitionDescription.getValue());
        }
        return input;
    }
}

