/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.partition;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.entity.PartitionEntity;
import ca.uhn.fhir.jpa.partition.BaseRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.partition.IPartitionLookupSvc;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestPartitionHelperSvc
extends BaseRequestPartitionHelperSvc {
    @Autowired
    IPartitionLookupSvc myPartitionConfigSvc;

    protected RequestPartitionId validateAndNormalizePartitionIds(RequestPartitionId theRequestPartitionId) {
        ArrayList<String> names = null;
        for (int i = 0; i < theRequestPartitionId.getPartitionIds().size(); ++i) {
            PartitionEntity partition;
            Integer id = (Integer)theRequestPartitionId.getPartitionIds().get(i);
            if (id == null) {
                partition = null;
            } else {
                try {
                    partition = this.myPartitionConfigSvc.getPartitionById(id);
                }
                catch (IllegalArgumentException e) {
                    String msg = this.myFhirContext.getLocalizer().getMessage(BaseRequestPartitionHelperSvc.class, "unknownPartitionId", new Object[]{theRequestPartitionId.getPartitionIds().get(i)});
                    throw new ResourceNotFoundException(Msg.code((int)1316) + msg);
                }
            }
            if (theRequestPartitionId.getPartitionNames() != null) {
                if (partition == null) {
                    Validate.isTrue((theRequestPartitionId.getPartitionIds().get(i) == null ? 1 : 0) != 0, (String)"Partition %s must not have an ID", (Object[])new Object[]{"DEFAULT"});
                    continue;
                }
                Validate.isTrue((boolean)Objects.equals(theRequestPartitionId.getPartitionIds().get(i), partition.getId()), (String)"Partition name %s does not match ID %n", (Object[])new Object[]{theRequestPartitionId.getPartitionNames().get(i), theRequestPartitionId.getPartitionIds().get(i)});
                continue;
            }
            if (names == null) {
                names = new ArrayList<String>();
            }
            if (partition != null) {
                names.add(partition.getName());
                continue;
            }
            names.add(null);
        }
        if (names != null) {
            return RequestPartitionId.forPartitionIdsAndNames(names, (List)theRequestPartitionId.getPartitionIds(), (LocalDate)theRequestPartitionId.getPartitionDate());
        }
        return theRequestPartitionId;
    }

    protected RequestPartitionId validateAndNormalizePartitionNames(RequestPartitionId theRequestPartitionId) {
        ArrayList<Integer> ids = null;
        for (int i = 0; i < theRequestPartitionId.getPartitionNames().size(); ++i) {
            PartitionEntity partition;
            try {
                partition = this.myPartitionConfigSvc.getPartitionByName((String)theRequestPartitionId.getPartitionNames().get(i));
            }
            catch (IllegalArgumentException e) {
                String msg = this.myFhirContext.getLocalizer().getMessage(BaseRequestPartitionHelperSvc.class, "unknownPartitionName", new Object[]{theRequestPartitionId.getPartitionNames().get(i)});
                throw new ResourceNotFoundException(Msg.code((int)1317) + msg);
            }
            if (theRequestPartitionId.hasPartitionIds()) {
                if (partition == null) {
                    Validate.isTrue((theRequestPartitionId.getPartitionIds().get(i) == null ? 1 : 0) != 0, (String)"Partition %s must not have an ID", (Object[])new Object[]{"DEFAULT"});
                    continue;
                }
                Validate.isTrue((boolean)Objects.equals(theRequestPartitionId.getPartitionIds().get(i), partition.getId()), (String)"Partition name %s does not match ID %n", (Object[])new Object[]{theRequestPartitionId.getPartitionNames().get(i), theRequestPartitionId.getPartitionIds().get(i)});
                continue;
            }
            if (ids == null) {
                ids = new ArrayList<Integer>();
            }
            if (partition != null) {
                ids.add(partition.getId());
                continue;
            }
            ids.add(null);
        }
        if (ids != null) {
            return RequestPartitionId.forPartitionIdsAndNames((List)theRequestPartitionId.getPartitionNames(), ids, (LocalDate)theRequestPartitionId.getPartitionDate());
        }
        return theRequestPartitionId;
    }
}

