/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.provider.ValueSetOperationProvider;
import ca.uhn.fhir.jpa.validation.JpaValidationSupportChain;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseJpaResourceProviderCodeSystem<T extends IBaseResource>
extends BaseJpaResourceProvider<T> {
    @Autowired
    private JpaValidationSupportChain myValidationSupportChain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$lookup", idempotent=true, returnParameters={@OperationParam(name="name", typeName="string", min=1), @OperationParam(name="version", typeName="string", min=0), @OperationParam(name="display", typeName="string", min=1), @OperationParam(name="abstract", typeName="boolean", min=1)})
    public IBaseParameters lookup(HttpServletRequest theServletRequest, @OperationParam(name="code", min=0, max=1, typeName="code") IPrimitiveType<String> theCode, @OperationParam(name="system", min=0, max=1, typeName="uri") IPrimitiveType<String> theSystem, @OperationParam(name="coding", min=0, max=1, typeName="Coding") IBaseCoding theCoding, @OperationParam(name="version", min=0, max=1, typeName="string") IPrimitiveType<String> theVersion, @OperationParam(name="displayLanguage", min=0, max=1, typeName="code") IPrimitiveType<String> theDisplayLanguage, @OperationParam(name="property", min=0, max=-1, typeName="code") List<IPrimitiveType<String>> theProperties, RequestDetails theRequestDetails) {
        BaseJpaResourceProviderCodeSystem.startRequest((HttpServletRequest)theServletRequest);
        try {
            IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
            BaseJpaResourceProviderCodeSystem.applyVersionToSystem(theSystem, theVersion);
            IValidationSupport.LookupCodeResult result = dao.lookupCode(theCode, theSystem, theCoding, theDisplayLanguage, theRequestDetails);
            result.throwNotFoundIfAppropriate();
            IBaseParameters iBaseParameters = result.toParameters(theRequestDetails.getFhirContext(), theProperties);
            return iBaseParameters;
        }
        finally {
            BaseJpaResourceProviderCodeSystem.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$subsumes", idempotent=true, returnParameters={@OperationParam(name="outcome", typeName="code", min=1)})
    public IBaseParameters subsumes(HttpServletRequest theServletRequest, @OperationParam(name="codeA", min=0, max=1, typeName="code") IPrimitiveType<String> theCodeA, @OperationParam(name="codeB", min=0, max=1, typeName="code") IPrimitiveType<String> theCodeB, @OperationParam(name="system", min=0, max=1, typeName="uri") IPrimitiveType<String> theSystem, @OperationParam(name="codingA", min=0, max=1, typeName="Coding") IBaseCoding theCodingA, @OperationParam(name="codingB", min=0, max=1, typeName="Coding") IBaseCoding theCodingB, @OperationParam(name="version", min=0, max=1, typeName="string") IPrimitiveType<String> theVersion, RequestDetails theRequestDetails) {
        BaseJpaResourceProviderCodeSystem.startRequest((HttpServletRequest)theServletRequest);
        try {
            IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
            BaseJpaResourceProviderCodeSystem.applyVersionToSystem(theSystem, theVersion);
            IFhirResourceDaoCodeSystem.SubsumesResult result = dao.subsumes(theCodeA, theCodeB, theSystem, theCodingA, theCodingB, theRequestDetails);
            IBaseParameters iBaseParameters = result.toParameters(theRequestDetails.getFhirContext());
            return iBaseParameters;
        }
        finally {
            BaseJpaResourceProviderCodeSystem.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    static void applyVersionToSystem(IPrimitiveType<String> theSystem, IPrimitiveType<String> theVersion) {
        if (theVersion != null && StringUtils.isNotBlank((CharSequence)theVersion.getValueAsString()) && theSystem != null) {
            theSystem.setValue((Object)(theSystem.getValueAsString() + "|" + theVersion.getValueAsString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$validate-code", idempotent=true, returnParameters={@OperationParam(name="result", typeName="boolean", min=1), @OperationParam(name="message", typeName="string"), @OperationParam(name="display", typeName="string")})
    public IBaseParameters validateCode(HttpServletRequest theServletRequest, @IdParam(optional=true) IIdType theId, @OperationParam(name="url", min=0, max=1, typeName="uri") IPrimitiveType<String> theCodeSystemUrl, @OperationParam(name="version", min=0, max=1, typeName="string") IPrimitiveType<String> theVersion, @OperationParam(name="code", min=0, max=1, typeName="code") IPrimitiveType<String> theCode, @OperationParam(name="display", min=0, max=1, typeName="string") IPrimitiveType<String> theDisplay, @OperationParam(name="coding", min=0, max=1, typeName="Coding") IBaseCoding theCoding, @OperationParam(name="codeableConcept", min=0, max=1, typeName="CodeableConcept") IBaseDatatype theCodeableConcept, RequestDetails theRequestDetails) {
        IValidationSupport.CodeValidationResult result = null;
        BaseJpaResourceProviderCodeSystem.startRequest((HttpServletRequest)theServletRequest);
        try {
            if (this.myValidationSupportChain.isRemoteTerminologyServiceConfigured()) {
                String codeSystemUrl;
                String string = codeSystemUrl = theCodeSystemUrl != null && theCodeSystemUrl.hasValue() ? theCodeSystemUrl.getValueAsString() : null;
                if (theCoding != null && StringUtils.isNotBlank((CharSequence)theCoding.getSystem())) {
                    if (codeSystemUrl != null && !codeSystemUrl.equalsIgnoreCase(theCoding.getSystem())) {
                        throw new InvalidRequestException(Msg.code((int)1160) + "Coding.system '" + theCoding.getSystem() + "' does not equal param url '" + theCodeSystemUrl + "'. Unable to validate-code.");
                    }
                    codeSystemUrl = theCoding.getSystem();
                    String code = theCoding.getCode();
                    String display = theCoding.getDisplay();
                    result = this.validateCodeWithTerminologyService(codeSystemUrl, code, display).orElseGet(this.supplyUnableToValidateResult(codeSystemUrl, code));
                }
            } else {
                IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
                result = dao.validateCode(theId, theCodeSystemUrl, theVersion, theCode, theDisplay, theCoding, theCodeableConcept, theRequestDetails);
            }
            IBaseParameters iBaseParameters = ValueSetOperationProvider.toValidateCodeResult(this.getContext(), result);
            return iBaseParameters;
        }
        finally {
            BaseJpaResourceProviderCodeSystem.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    private Optional<IValidationSupport.CodeValidationResult> validateCodeWithTerminologyService(String theCodeSystemUrl, String theCode, String theDisplay) {
        return Optional.ofNullable(this.myValidationSupportChain.validateCode(new ValidationSupportContext((IValidationSupport)this.myValidationSupportChain), new ConceptValidationOptions(), theCodeSystemUrl, theCode, theDisplay, null));
    }

    private Supplier<IValidationSupport.CodeValidationResult> supplyUnableToValidateResult(String theCodeSystemUrl, String theCode) {
        return () -> new IValidationSupport.CodeValidationResult().setMessage("Terminology service was unable to provide validation for " + theCodeSystemUrl + "#" + theCode);
    }
}

