/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoStructureDefinition;
import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.ValidateUtil;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BaseJpaResourceProviderStructureDefinition<T extends IBaseResource>
extends BaseJpaResourceProvider<T> {
    @Operation(name="$snapshot", idempotent=true)
    public IBaseResource snapshot(@IdParam(optional=true) IIdType theId, @OperationParam(name="definition", typeName="StructureDefinition") IBaseResource theStructureDefinition, @OperationParam(name="url", typeName="string") IPrimitiveType<String> theUrl, RequestDetails theRequestDetails) {
        IBaseResource sd;
        ValidateUtil.exactlyOneNotNullOrThrowInvalidRequestException((Object[])new Object[]{theId, theStructureDefinition, theUrl}, (String)"Must supply either an ID or a StructureDefinition or a URL (but not more than one of these things)");
        IFhirResourceDaoStructureDefinition<T> dao = this.getDao();
        if (theId == null && theStructureDefinition != null && theUrl == null) {
            sd = theStructureDefinition;
        } else if (theId != null && theStructureDefinition == null) {
            sd = dao.read(theId, theRequestDetails);
        } else {
            SearchParameterMap map = new SearchParameterMap();
            map.setLoadSynchronousUpTo(Integer.valueOf(2));
            map.add("url", (IQueryParameterType)new UriParam((String)theUrl.getValue()));
            IBundleProvider outcome = dao.search(map, theRequestDetails);
            Integer numResults = outcome.size();
            assert (numResults != null);
            if (numResults == 0) {
                throw new ResourceNotFoundException(Msg.code((int)1162) + "No StructureDefiniton found with url = '" + (String)theUrl.getValue() + "'");
            }
            sd = (IBaseResource)outcome.getResources(0, 1).get(0);
        }
        return dao.generateSnapshot(sd, null, null, null);
    }

    public IFhirResourceDaoStructureDefinition<T> getDao() {
        return (IFhirResourceDaoStructureDefinition)super.getDao();
    }
}

