/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.jpa.search.reindex.IInstanceReindexService;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class InstanceReindexProvider {
    private final IInstanceReindexService myInstanceReindexService;

    public InstanceReindexProvider(@Nonnull IInstanceReindexService theInstanceReindexService) {
        Validate.notNull((Object)theInstanceReindexService);
        this.myInstanceReindexService = theInstanceReindexService;
    }

    @Operation(name="$reindex-dryrun", idempotent=true, global=true)
    public IBaseParameters reindexInstanceDryRun(@IdParam IIdType theId, @OperationParam(name="code", typeName="code", min=0, max=-1) List<IPrimitiveType<String>> theCodes, RequestDetails theRequestDetails) {
        Set codes = null;
        if (theCodes != null && theCodes.size() > 0) {
            codes = theCodes.stream().map(IPrimitiveType::getValueAsString).collect(Collectors.toSet());
        }
        return this.myInstanceReindexService.reindexDryRun(theRequestDetails, theId, codes);
    }

    @Operation(name="$reindex", idempotent=false, global=true)
    public IBaseParameters reindexInstance(@IdParam IIdType theId, RequestDetails theRequestDetails) {
        return this.myInstanceReindexService.reindex(theRequestDetails, theId);
    }
}

