/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.provider.BaseJpaSystemProvider;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public final class JpaSystemProvider<T, MT>
extends BaseJpaSystemProvider<T, MT> {
    @Description(value="Marks all currently existing resources of a given type, or all resources of all types, for reindexing.")
    @Operation(name="$mark-all-resources-for-reindexing", idempotent=false, returnParameters={@OperationParam(name="status")})
    @Deprecated
    public IBaseResource markAllResourcesForReindexing(@OperationParam(name="type", min=0, max=1, typeName="code") IPrimitiveType<String> theType) {
        if (theType != null && StringUtils.isNotBlank((CharSequence)theType.getValueAsString())) {
            this.getResourceReindexingSvc().markAllResourcesForReindexing(theType.getValueAsString());
        } else {
            this.getResourceReindexingSvc().markAllResourcesForReindexing();
        }
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
        IPrimitiveType string = ParametersUtil.createString((FhirContext)this.getContext(), (String)"Marked resources");
        ParametersUtil.addParameterToParameters((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)"status", (Object)string);
        return retVal;
    }

    @Description(value="Forces a single pass of the resource reindexing processor")
    @Operation(name="$perform-reindexing-pass", idempotent=false, returnParameters={@OperationParam(name="status")})
    @Deprecated
    public IBaseResource performReindexingPass() {
        Integer count = this.getResourceReindexingSvc().runReindexingPass();
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
        IPrimitiveType string = count == null ? ParametersUtil.createString((FhirContext)this.getContext(), (String)"Index pass already proceeding") : ParametersUtil.createString((FhirContext)this.getContext(), (String)("Indexed " + count + " resources"));
        ParametersUtil.addParameterToParameters((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)"status", (Object)string);
        return retVal;
    }

    @Operation(name="$get-resource-counts", idempotent=true)
    @Description(shortDefinition="Provides the number of resources currently stored on the server, broken down by resource type")
    public IBaseParameters getResourceCounts() {
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
        TreeMap counts = this.getDao().getResourceCountsFromCache();
        counts = (Map)ObjectUtils.defaultIfNull((Object)counts, Collections.emptyMap());
        counts = new TreeMap(counts);
        for (Map.Entry nextEntry : counts.entrySet()) {
            ParametersUtil.addParameterToParametersInteger((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)((String)nextEntry.getKey()), (int)((Long)nextEntry.getValue()).intValue());
        }
        return retVal;
    }

    @Operation(name="$meta", idempotent=true, returnParameters={@OperationParam(name="return", typeName="Meta")})
    public IBaseParameters meta(RequestDetails theRequestDetails) {
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
        ParametersUtil.addParameterToParameters((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)"return", (Object)this.getDao().metaGetOperation(theRequestDetails));
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transaction
    public IBaseBundle transaction(RequestDetails theRequestDetails, @TransactionParam IBaseBundle theResources) {
        JpaSystemProvider.startRequest((HttpServletRequest)((ServletRequestDetails)theRequestDetails).getServletRequest());
        try {
            IFhirSystemDao dao = this.getDao();
            IBaseBundle iBaseBundle = (IBaseBundle)dao.transaction(theRequestDetails, (Object)theResources);
            return iBaseBundle;
        }
        finally {
            JpaSystemProvider.endRequest((HttpServletRequest)((ServletRequestDetails)theRequestDetails).getServletRequest());
        }
    }
}

