/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.provider.BaseJpaProvider;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.springframework.beans.factory.annotation.Autowired;

public class ProcessMessageProvider {
    @Autowired
    private IFhirSystemDao<?, ?> mySystemDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Accept a FHIR Message Bundle for processing")
    @Operation(name="$process-message", idempotent=false)
    public IBaseBundle processMessage(HttpServletRequest theServletRequest, RequestDetails theRequestDetails, @OperationParam(name="content", min=1, max=1, typeName="Bundle") @Description(shortDefinition="The message to process (or, if using asynchronous messaging, it may be a response message to accept)") IBaseBundle theMessageToProcess) {
        BaseJpaProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBaseBundle iBaseBundle = this.mySystemDao.processMessage(theRequestDetails, theMessageToProcess);
            return iBaseBundle;
        }
        finally {
            BaseJpaProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

