/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.provider.r4.MemberMatcherR4Helper;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;

public class MemberMatchR4ResourceProvider {
    private final MemberMatcherR4Helper myMemberMatcherR4Helper;
    private final FhirContext myFhirContext;

    public MemberMatchR4ResourceProvider(FhirContext theFhirContext, MemberMatcherR4Helper theMemberMatcherR4Helper) {
        this.myFhirContext = theFhirContext;
        this.myMemberMatcherR4Helper = theMemberMatcherR4Helper;
    }

    @Operation(name="$member-match", typeName="Patient", canonicalUrl="http://hl7.org/fhir/us/davinci-hrex/OperationDefinition/member-match", idempotent=false, returnParameters={@OperationParam(name="MemberIdentifier", typeName="string")})
    public Parameters patientMemberMatch(HttpServletRequest theServletRequest, @Description(shortDefinition="The target of the operation. Will be returned with Identifier for matched coverage added.") @OperationParam(name="MemberPatient", min=1, max=1) Patient theMemberPatient, @Description(shortDefinition="Old coverage information as extracted from beneficiary's card.") @OperationParam(name="OldCoverage", min=1, max=1) Coverage oldCoverage, @Description(shortDefinition="New Coverage information. Provided as a reference. Optionally returned unmodified.") @OperationParam(name="NewCoverage", min=1, max=1) Coverage newCoverage, @Description(shortDefinition="Consent information. Consent held by the system seeking the match that grants permission to access the patient information.") @OperationParam(name="Consent", min=1, max=1) Consent theConsent, RequestDetails theRequestDetails) {
        return this.doMemberMatchOperation(theMemberPatient, oldCoverage, newCoverage, theConsent, theRequestDetails);
    }

    private Parameters doMemberMatchOperation(Patient theMemberPatient, Coverage theCoverageToMatch, Coverage theCoverageToLink, Consent theConsent, RequestDetails theRequestDetails) {
        this.validateParams(theMemberPatient, theCoverageToMatch, theCoverageToLink, theConsent);
        Optional<Coverage> coverageOpt = this.myMemberMatcherR4Helper.findMatchingCoverage(theCoverageToMatch, theRequestDetails);
        if (coverageOpt.isEmpty()) {
            String i18nMessage = this.myFhirContext.getLocalizer().getMessage("operation.member.match.error.coverage.not.found", new Object[0]);
            throw new UnprocessableEntityException(Msg.code((int)1155) + i18nMessage);
        }
        Coverage coverage = coverageOpt.get();
        Optional<Patient> patientOpt = this.myMemberMatcherR4Helper.getBeneficiaryPatient(coverage, theRequestDetails);
        if (patientOpt.isEmpty()) {
            String i18nMessage = this.myFhirContext.getLocalizer().getMessage("operation.member.match.error.beneficiary.not.found", new Object[0]);
            throw new UnprocessableEntityException(Msg.code((int)1156) + i18nMessage);
        }
        Patient patient = patientOpt.get();
        if (!this.myMemberMatcherR4Helper.validPatientMember(patient, theMemberPatient, theRequestDetails)) {
            String i18nMessage = this.myFhirContext.getLocalizer().getMessage("operation.member.match.error.patient.not.found", new Object[0]);
            throw new UnprocessableEntityException(Msg.code((int)2146) + i18nMessage);
        }
        if (patient.getIdentifier().isEmpty()) {
            String i18nMessage = this.myFhirContext.getLocalizer().getMessage("operation.member.match.error.beneficiary.without.identifier", new Object[0]);
            throw new UnprocessableEntityException(Msg.code((int)1157) + i18nMessage);
        }
        if (!this.myMemberMatcherR4Helper.validConsentDataAccess(theConsent)) {
            String i18nMessage = this.myFhirContext.getLocalizer().getMessage("operation.member.match.error.consent.release.data.mismatch", new Object[0]);
            throw new UnprocessableEntityException(Msg.code((int)2147) + i18nMessage);
        }
        this.myMemberMatcherR4Helper.addMemberIdentifierToMemberPatient(theMemberPatient, patient.getIdentifierFirstRep());
        this.myMemberMatcherR4Helper.updateConsentForMemberMatch(theConsent, patient, theMemberPatient, theRequestDetails);
        return this.myMemberMatcherR4Helper.buildSuccessReturnParameters(theMemberPatient, theCoverageToLink, theConsent);
    }

    private void validateParams(Patient theMemberPatient, Coverage theOldCoverage, Coverage theNewCoverage, Consent theConsent) {
        this.validateParam(theMemberPatient, "MemberPatient");
        this.validateParam(theOldCoverage, "OldCoverage");
        this.validateParam(theNewCoverage, "NewCoverage");
        this.validateParam(theConsent, "Consent");
        this.validateMemberPatientParam(theMemberPatient);
        this.validateConsentParam(theConsent);
    }

    private void validateParam(@Nullable Object theParam, String theParamName) {
        if (theParam == null) {
            String i18nMessage = this.myFhirContext.getLocalizer().getMessage("operation.member.match.error.missing.parameter", new Object[]{theParamName});
            throw new UnprocessableEntityException(Msg.code((int)1158) + i18nMessage);
        }
    }

    private void validateMemberPatientParam(Patient theMemberPatient) {
        if (theMemberPatient.getName().isEmpty()) {
            this.validateParam(null, "MemberPatient Name");
        }
        this.validateParam(((HumanName)theMemberPatient.getName().get(0)).getFamily(), "MemberPatient Name");
        this.validateParam(theMemberPatient.getBirthDate(), "MemberPatient Birthdate");
    }

    private void validateConsentParam(Consent theConsent) {
        if (theConsent.getPatient().isEmpty()) {
            this.validateParam(null, "Consent's Patient Reference");
        }
        if (theConsent.getPerformer().isEmpty()) {
            this.validateParam(null, "Consent's Performer Reference");
        }
    }
}

