/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.reindex;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.pid.EmptyResourcePidList;
import ca.uhn.fhir.jpa.api.pid.HomogeneousResourcePidList;
import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.jpa.api.pid.MixedResourcePidList;
import ca.uhn.fhir.jpa.api.svc.IBatch2DaoSvc;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;

public class Batch2DaoSvcImpl
implements IBatch2DaoSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(Batch2DaoSvcImpl.class);
    private final IResourceTableDao myResourceTableDao;
    private final MatchUrlService myMatchUrlService;
    private final DaoRegistry myDaoRegistry;
    private final FhirContext myFhirContext;
    private final IHapiTransactionService myTransactionService;
    private final JpaStorageSettings myJpaStorageSettings;

    public boolean isAllResourceTypeSupported() {
        return true;
    }

    public Batch2DaoSvcImpl(IResourceTableDao theResourceTableDao, MatchUrlService theMatchUrlService, DaoRegistry theDaoRegistry, FhirContext theFhirContext, IHapiTransactionService theTransactionService, JpaStorageSettings theJpaStorageSettings) {
        this.myResourceTableDao = theResourceTableDao;
        this.myMatchUrlService = theMatchUrlService;
        this.myDaoRegistry = theDaoRegistry;
        this.myFhirContext = theFhirContext;
        this.myTransactionService = theTransactionService;
        this.myJpaStorageSettings = theJpaStorageSettings;
    }

    public IResourcePidList fetchResourceIdsPage(Date theStart, Date theEnd, @Nullable RequestPartitionId theRequestPartitionId, @Nullable String theUrl) {
        return (IResourcePidList)this.myTransactionService.withSystemRequest().withRequestPartitionId(theRequestPartitionId).execute(() -> {
            if (theUrl == null) {
                return this.fetchResourceIdsPageNoUrl(theStart, theEnd, theRequestPartitionId);
            }
            return this.fetchResourceIdsPageWithUrl(theEnd, theUrl, theRequestPartitionId);
        });
    }

    @Nonnull
    private HomogeneousResourcePidList fetchResourceIdsPageWithUrl(Date theEnd, @Nonnull String theUrl, @Nullable RequestPartitionId theRequestPartitionId) {
        if (!theUrl.contains("?")) {
            throw new InternalErrorException(Msg.code((int)2422) + "this should never happen: URL is missing a '?'");
        }
        Integer internalSynchronousSearchSize = this.myJpaStorageSettings.getInternalSynchronousSearchSize();
        if (internalSynchronousSearchSize == null || internalSynchronousSearchSize <= 0) {
            throw new InternalErrorException(Msg.code((int)2423) + "this should never happen: internalSynchronousSearchSize is null or less than or equal to 0");
        }
        List<IResourcePersistentId> currentIds = this.fetchResourceIdsPageWithUrl(0, theUrl, theRequestPartitionId);
        ourLog.debug("FIRST currentIds: {}", (Object)currentIds.size());
        ArrayList<IResourcePersistentId> allIds = new ArrayList<IResourcePersistentId>(currentIds);
        while (internalSynchronousSearchSize < currentIds.size()) {
            currentIds = this.fetchResourceIdsPageWithUrl(allIds.size(), theUrl, theRequestPartitionId);
            ourLog.debug("NEXT currentIds: {}", (Object)currentIds.size());
            allIds.addAll(currentIds);
        }
        String resourceType = theUrl.substring(0, theUrl.indexOf(63));
        return new HomogeneousResourcePidList(resourceType, allIds, theEnd, theRequestPartitionId);
    }

    private List<IResourcePersistentId> fetchResourceIdsPageWithUrl(int theOffset, String theUrl, RequestPartitionId theRequestPartitionId) {
        String resourceType = theUrl.substring(0, theUrl.indexOf(63));
        RuntimeResourceDefinition def = this.myFhirContext.getResourceDefinition(resourceType);
        SearchParameterMap searchParamMap = this.myMatchUrlService.translateMatchUrl(theUrl, def, new MatchUrlService.Flag[0]);
        searchParamMap.setSort(new SortSpec("_id", SortOrderEnum.ASC));
        searchParamMap.setOffset(Integer.valueOf(theOffset));
        searchParamMap.setLoadSynchronousUpTo(Integer.valueOf(this.myJpaStorageSettings.getInternalSynchronousSearchSize() + 1));
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
        SystemRequestDetails request = new SystemRequestDetails();
        request.setRequestPartitionId(theRequestPartitionId);
        return dao.searchForIds(searchParamMap, (RequestDetails)request);
    }

    @Nonnull
    private IResourcePidList fetchResourceIdsPageNoUrl(Date theStart, Date theEnd, RequestPartitionId theRequestPartitionId) {
        Pageable page = Pageable.unpaged();
        Slice<Object[]> slice = theRequestPartitionId == null || theRequestPartitionId.isAllPartitions() ? this.myResourceTableDao.findIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldest(page, theStart, theEnd) : (theRequestPartitionId.isDefaultPartition() ? this.myResourceTableDao.findIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldestForDefaultPartition(page, theStart, theEnd) : this.myResourceTableDao.findIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldestForPartitionIds(page, theStart, theEnd, theRequestPartitionId.getPartitionIds()));
        List content = slice.getContent();
        if (content.isEmpty()) {
            return new EmptyResourcePidList();
        }
        List ids = content.stream().map(t -> JpaPid.fromId((Long)((Long)t[0]))).collect(Collectors.toList());
        List types = content.stream().map(t -> (String)t[1]).collect(Collectors.toList());
        Date lastDate = (Date)((Object[])content.get(content.size() - 1))[2];
        return new MixedResourcePidList(types, ids, lastDate, theRequestPartitionId);
    }
}

