/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.dstu3;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.dstu3.model.Appointment;

public class AppointmentResourceProvider
extends BaseJpaResourceProvider<Appointment> {
    public Class<Appointment> getResourceType() {
        return Appointment.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Any one of the individuals participating in the appointment") @OptionalParam(name="actor", targetTypes={}) ReferenceAndListParam theActor, @Description(shortDefinition="The style of appointment or patient that has been booked in the slot (not service type)") @OptionalParam(name="appointment-type") TokenAndListParam theAppointment_type, @Description(shortDefinition="Appointment date/time.") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="An Identifier of the Appointment") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="The ReferralRequest provided as information to allocate to the Encounter") @OptionalParam(name="incomingreferral", targetTypes={}) ReferenceAndListParam theIncomingreferral, @Description(shortDefinition="This location is listed in the participants of the appointment") @OptionalParam(name="location", targetTypes={}) ReferenceAndListParam theLocation, @Description(shortDefinition="The Participation status of the subject, or other participant on the appointment. Can be used to locate participants that have not responded to meeting requests.") @OptionalParam(name="part-status") TokenAndListParam thePart_status, @Description(shortDefinition="One of the individuals of the appointment is this patient") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="One of the individuals of the appointment is this practitioner") @OptionalParam(name="practitioner", targetTypes={}) ReferenceAndListParam thePractitioner, @Description(shortDefinition="The specific service that is to be performed during this appointment") @OptionalParam(name="service-type") TokenAndListParam theService_type, @Description(shortDefinition="The overall status of the appointment") @OptionalParam(name="status") TokenAndListParam theStatus, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        AppointmentResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("actor", (IQueryParameterAnd)theActor);
            paramMap.add("appointment-type", (IQueryParameterAnd)theAppointment_type);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("incomingreferral", (IQueryParameterAnd)theIncomingreferral);
            paramMap.add("location", (IQueryParameterAnd)theLocation);
            paramMap.add("part-status", (IQueryParameterAnd)thePart_status);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("practitioner", (IQueryParameterAnd)thePractitioner);
            paramMap.add("service-type", (IQueryParameterAnd)theService_type);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            AppointmentResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

