/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.dstu3;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.dstu3.model.MedicationStatement;

public class MedicationStatementResourceProvider
extends BaseJpaResourceProvider<MedicationStatement> {
    public Class<MedicationStatement> getResourceType() {
        return MedicationStatement.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Returns statements of this category of medicationstatement") @OptionalParam(name="category") TokenAndListParam theCategory, @Description(shortDefinition="Return statements of this medication code") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="Returns statements for a specific context (episode or episode of Care).") @OptionalParam(name="context", targetTypes={}) ReferenceAndListParam theContext, @Description(shortDefinition="Date when patient was taking (or not taking) the medication") @OptionalParam(name="effective") DateRangeParam theEffective, @Description(shortDefinition="Return statements with this external identifier") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Return statements of this medication reference") @OptionalParam(name="medication", targetTypes={}) ReferenceAndListParam theMedication, @Description(shortDefinition="Returns statements that are part of another event.") @OptionalParam(name="part-of", targetTypes={}) ReferenceAndListParam thePart_of, @Description(shortDefinition="Returns statements for a specific patient.") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="Who or where the information in the statement came from") @OptionalParam(name="source", targetTypes={}) ReferenceAndListParam theSource, @Description(shortDefinition="Return statements that match the given status") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="The identity of a patient, animal or group to list statements for") @OptionalParam(name="subject", targetTypes={}) ReferenceAndListParam theSubject, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        MedicationStatementResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("category", (IQueryParameterAnd)theCategory);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("context", (IQueryParameterAnd)theContext);
            paramMap.add("effective", (IQueryParameterAnd)theEffective);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("medication", (IQueryParameterAnd)theMedication);
            paramMap.add("part-of", (IQueryParameterAnd)thePart_of);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("source", (IQueryParameterAnd)theSource);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("subject", (IQueryParameterAnd)theSubject);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            MedicationStatementResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

