/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProviderEncounter;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4.model.Encounter;

public class EncounterResourceProvider
extends BaseJpaResourceProviderEncounter<Encounter> {
    public Class<Encounter> getResourceType() {
        return Encounter.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="The set of accounts that may be used for billing for this Encounter") @OptionalParam(name="account", targetTypes={}) ReferenceAndListParam theAccount, @Description(shortDefinition="The appointment that scheduled this encounter") @OptionalParam(name="appointment", targetTypes={}) ReferenceAndListParam theAppointment, @Description(shortDefinition="The ServiceRequest that initiated this encounter") @OptionalParam(name="based-on", targetTypes={}) ReferenceAndListParam theBased_on, @Description(shortDefinition="Classification of patient encounter") @OptionalParam(name="class") TokenAndListParam theClass, @Description(shortDefinition="A date within the period the Encounter lasted") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="The diagnosis or procedure relevant to the encounter") @OptionalParam(name="diagnosis", targetTypes={}) ReferenceAndListParam theDiagnosis, @Description(shortDefinition="Episode(s) of care that this encounter should be recorded against") @OptionalParam(name="episode-of-care", targetTypes={}) ReferenceAndListParam theEpisode_of_care, @Description(shortDefinition="Identifier(s) by which this encounter is known") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Length of encounter in days") @OptionalParam(name="length") QuantityAndListParam theLength, @Description(shortDefinition="Location the encounter takes place") @OptionalParam(name="location", targetTypes={}) ReferenceAndListParam theLocation, @Description(shortDefinition="Time period during which the patient was present at the location") @OptionalParam(name="location-period") DateRangeParam theLocation_period, @Description(shortDefinition="Another Encounter this encounter is part of") @OptionalParam(name="part-of", targetTypes={}) ReferenceAndListParam thePart_of, @Description(shortDefinition="Persons involved in the encounter other than the patient") @OptionalParam(name="participant", targetTypes={}) ReferenceAndListParam theParticipant, @Description(shortDefinition="Role of participant in encounter") @OptionalParam(name="participant-type") TokenAndListParam theParticipant_type, @Description(shortDefinition="The patient or group present at the encounter") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="Persons involved in the encounter other than the patient") @OptionalParam(name="practitioner", targetTypes={}) ReferenceAndListParam thePractitioner, @Description(shortDefinition="Coded reason the encounter takes place") @OptionalParam(name="reason-code") TokenAndListParam theReason_code, @Description(shortDefinition="Reason the encounter takes place (reference)") @OptionalParam(name="reason-reference", targetTypes={}) ReferenceAndListParam theReason_reference, @Description(shortDefinition="The organization (facility) responsible for this encounter") @OptionalParam(name="service-provider", targetTypes={}) ReferenceAndListParam theService_provider, @Description(shortDefinition="Wheelchair, translator, stretcher, etc.") @OptionalParam(name="special-arrangement") TokenAndListParam theSpecial_arrangement, @Description(shortDefinition="planned | arrived | triaged | in-progress | onleave | finished | cancelled +") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="The patient or group present at the encounter") @OptionalParam(name="subject", targetTypes={}) ReferenceAndListParam theSubject, @Description(shortDefinition="Specific type of encounter") @OptionalParam(name="type") TokenAndListParam theType, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        EncounterResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("account", (IQueryParameterAnd)theAccount);
            paramMap.add("appointment", (IQueryParameterAnd)theAppointment);
            paramMap.add("based-on", (IQueryParameterAnd)theBased_on);
            paramMap.add("class", (IQueryParameterAnd)theClass);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("diagnosis", (IQueryParameterAnd)theDiagnosis);
            paramMap.add("episode-of-care", (IQueryParameterAnd)theEpisode_of_care);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("length", (IQueryParameterAnd)theLength);
            paramMap.add("location", (IQueryParameterAnd)theLocation);
            paramMap.add("location-period", (IQueryParameterAnd)theLocation_period);
            paramMap.add("part-of", (IQueryParameterAnd)thePart_of);
            paramMap.add("participant", (IQueryParameterAnd)theParticipant);
            paramMap.add("participant-type", (IQueryParameterAnd)theParticipant_type);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("practitioner", (IQueryParameterAnd)thePractitioner);
            paramMap.add("reason-code", (IQueryParameterAnd)theReason_code);
            paramMap.add("reason-reference", (IQueryParameterAnd)theReason_reference);
            paramMap.add("service-provider", (IQueryParameterAnd)theService_provider);
            paramMap.add("special-arrangement", (IQueryParameterAnd)theSpecial_arrangement);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("subject", (IQueryParameterAnd)theSubject);
            paramMap.add("type", (IQueryParameterAnd)theType);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            EncounterResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

