/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.CompositeAndListParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4.model.Measure;

public class MeasureResourceProvider
extends BaseJpaResourceProvider<Measure> {
    public Class<Measure> getResourceType() {
        return Measure.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="What resource is being referenced") @OptionalParam(name="composed-of", targetTypes={}) ReferenceAndListParam theComposed_of, @Description(shortDefinition="A use context assigned to the measure") @OptionalParam(name="context") TokenAndListParam theContext, @Description(shortDefinition="A quantity- or range-valued use context assigned to the measure") @OptionalParam(name="context-quantity") QuantityAndListParam theContext_quantity, @Description(shortDefinition="A type of use context assigned to the measure") @OptionalParam(name="context-type") TokenAndListParam theContext_type, @Description(shortDefinition="A use context type and quantity- or range-based value assigned to the measure") @OptionalParam(name="context-type-quantity", compositeTypes={TokenParam.class, QuantityParam.class}) CompositeAndListParam<TokenParam, QuantityParam> theContext_type_quantity, @Description(shortDefinition="A use context type and value assigned to the measure") @OptionalParam(name="context-type-value", compositeTypes={TokenParam.class, TokenParam.class}) CompositeAndListParam<TokenParam, TokenParam> theContext_type_value, @Description(shortDefinition="The measure publication date") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="What resource is being referenced") @OptionalParam(name="depends-on", targetTypes={}) ReferenceAndListParam theDepends_on, @Description(shortDefinition="What resource is being referenced") @OptionalParam(name="derived-from", targetTypes={}) ReferenceAndListParam theDerived_from, @Description(shortDefinition="The description of the measure") @OptionalParam(name="description") StringAndListParam theDescription, @Description(shortDefinition="The time during which the measure is intended to be in use") @OptionalParam(name="effective") DateRangeParam theEffective, @Description(shortDefinition="External identifier for the measure") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Intended jurisdiction for the measure") @OptionalParam(name="jurisdiction") TokenAndListParam theJurisdiction, @Description(shortDefinition="Computationally friendly name of the measure") @OptionalParam(name="name") StringAndListParam theName, @Description(shortDefinition="What resource is being referenced") @OptionalParam(name="predecessor", targetTypes={}) ReferenceAndListParam thePredecessor, @Description(shortDefinition="Name of the publisher of the measure") @OptionalParam(name="publisher") StringAndListParam thePublisher, @Description(shortDefinition="The current status of the measure") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="What resource is being referenced") @OptionalParam(name="successor", targetTypes={}) ReferenceAndListParam theSuccessor, @Description(shortDefinition="The human-friendly name of the measure") @OptionalParam(name="title") StringAndListParam theTitle, @Description(shortDefinition="Topics associated with the measure") @OptionalParam(name="topic") TokenAndListParam theTopic, @Description(shortDefinition="The uri that identifies the measure") @OptionalParam(name="url") UriAndListParam theUrl, @Description(shortDefinition="The business version of the measure") @OptionalParam(name="version") TokenAndListParam theVersion, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        MeasureResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("composed-of", (IQueryParameterAnd)theComposed_of);
            paramMap.add("context", (IQueryParameterAnd)theContext);
            paramMap.add("context-quantity", (IQueryParameterAnd)theContext_quantity);
            paramMap.add("context-type", (IQueryParameterAnd)theContext_type);
            paramMap.add("context-type-quantity", theContext_type_quantity);
            paramMap.add("context-type-value", theContext_type_value);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("depends-on", (IQueryParameterAnd)theDepends_on);
            paramMap.add("derived-from", (IQueryParameterAnd)theDerived_from);
            paramMap.add("description", (IQueryParameterAnd)theDescription);
            paramMap.add("effective", (IQueryParameterAnd)theEffective);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("jurisdiction", (IQueryParameterAnd)theJurisdiction);
            paramMap.add("name", (IQueryParameterAnd)theName);
            paramMap.add("predecessor", (IQueryParameterAnd)thePredecessor);
            paramMap.add("publisher", (IQueryParameterAnd)thePublisher);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("successor", (IQueryParameterAnd)theSuccessor);
            paramMap.add("title", (IQueryParameterAnd)theTitle);
            paramMap.add("topic", (IQueryParameterAnd)theTopic);
            paramMap.add("url", (IQueryParameterAnd)theUrl);
            paramMap.add("version", (IQueryParameterAnd)theVersion);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            MeasureResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

