/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4.model.PractitionerRole;

public class PractitionerRoleResourceProvider
extends BaseJpaResourceProvider<PractitionerRole> {
    public Class<PractitionerRole> getResourceType() {
        return PractitionerRole.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Whether this practitioner role record is in active use") @OptionalParam(name="active") TokenAndListParam theActive, @Description(shortDefinition="The period during which the practitioner is authorized to perform in these role(s)") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="A value in an email contact") @OptionalParam(name="email") TokenAndListParam theEmail, @Description(shortDefinition="Technical endpoints providing access to services operated for the practitioner with this role") @OptionalParam(name="endpoint", targetTypes={}) ReferenceAndListParam theEndpoint, @Description(shortDefinition="A practitioner's Identifier") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="One of the locations at which this practitioner provides care") @OptionalParam(name="location", targetTypes={}) ReferenceAndListParam theLocation, @Description(shortDefinition="The identity of the organization the practitioner represents / acts on behalf of") @OptionalParam(name="organization", targetTypes={}) ReferenceAndListParam theOrganization, @Description(shortDefinition="A value in a phone contact") @OptionalParam(name="phone") TokenAndListParam thePhone, @Description(shortDefinition="Practitioner that is able to provide the defined services for the organization") @OptionalParam(name="practitioner", targetTypes={}) ReferenceAndListParam thePractitioner, @Description(shortDefinition="The practitioner can perform this role at for the organization") @OptionalParam(name="role") TokenAndListParam theRole, @Description(shortDefinition="The list of healthcare services that this worker provides for this role's Organization/Location(s)") @OptionalParam(name="service", targetTypes={}) ReferenceAndListParam theService, @Description(shortDefinition="The practitioner has this specialty at an organization") @OptionalParam(name="specialty") TokenAndListParam theSpecialty, @Description(shortDefinition="The value in any kind of contact") @OptionalParam(name="telecom") TokenAndListParam theTelecom, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        PractitionerRoleResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("active", (IQueryParameterAnd)theActive);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("email", (IQueryParameterAnd)theEmail);
            paramMap.add("endpoint", (IQueryParameterAnd)theEndpoint);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("location", (IQueryParameterAnd)theLocation);
            paramMap.add("organization", (IQueryParameterAnd)theOrganization);
            paramMap.add("phone", (IQueryParameterAnd)thePhone);
            paramMap.add("practitioner", (IQueryParameterAnd)thePractitioner);
            paramMap.add("role", (IQueryParameterAnd)theRole);
            paramMap.add("service", (IQueryParameterAnd)theService);
            paramMap.add("specialty", (IQueryParameterAnd)theSpecialty);
            paramMap.add("telecom", (IQueryParameterAnd)theTelecom);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            PractitionerRoleResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

