/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4.model.Procedure;

public class ProcedureResourceProvider
extends BaseJpaResourceProvider<Procedure> {
    public Class<Procedure> getResourceType() {
        return Procedure.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="A request for this procedure") @OptionalParam(name="based-on", targetTypes={}) ReferenceAndListParam theBased_on, @Description(shortDefinition="Classification of the procedure") @OptionalParam(name="category") TokenAndListParam theCategory, @Description(shortDefinition="A code to identify a  procedure") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="When the procedure was performed") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="Encounter created as part of") @OptionalParam(name="encounter", targetTypes={}) ReferenceAndListParam theEncounter, @Description(shortDefinition="A unique identifier for a procedure") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Instantiates FHIR protocol or definition") @OptionalParam(name="instantiates-canonical", targetTypes={}) ReferenceAndListParam theInstantiates_canonical, @Description(shortDefinition="Instantiates external protocol or definition") @OptionalParam(name="instantiates-uri") UriAndListParam theInstantiates_uri, @Description(shortDefinition="Where the procedure happened") @OptionalParam(name="location", targetTypes={}) ReferenceAndListParam theLocation, @Description(shortDefinition="Part of referenced event") @OptionalParam(name="part-of", targetTypes={}) ReferenceAndListParam thePart_of, @Description(shortDefinition="Search by subject - a patient") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="The reference to the practitioner") @OptionalParam(name="performer", targetTypes={}) ReferenceAndListParam thePerformer, @Description(shortDefinition="Coded reason procedure performed") @OptionalParam(name="reason-code") TokenAndListParam theReason_code, @Description(shortDefinition="The justification that the procedure was performed") @OptionalParam(name="reason-reference", targetTypes={}) ReferenceAndListParam theReason_reference, @Description(shortDefinition="preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="Search by subject") @OptionalParam(name="subject", targetTypes={}) ReferenceAndListParam theSubject, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        ProcedureResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("based-on", (IQueryParameterAnd)theBased_on);
            paramMap.add("category", (IQueryParameterAnd)theCategory);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("encounter", (IQueryParameterAnd)theEncounter);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("instantiates-canonical", (IQueryParameterAnd)theInstantiates_canonical);
            paramMap.add("instantiates-uri", (IQueryParameterAnd)theInstantiates_uri);
            paramMap.add("location", (IQueryParameterAnd)theLocation);
            paramMap.add("part-of", (IQueryParameterAnd)thePart_of);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("performer", (IQueryParameterAnd)thePerformer);
            paramMap.add("reason-code", (IQueryParameterAnd)theReason_code);
            paramMap.add("reason-reference", (IQueryParameterAnd)theReason_reference);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("subject", (IQueryParameterAnd)theSubject);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            ProcedureResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

