/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4.model.ServiceRequest;

public class ServiceRequestResourceProvider
extends BaseJpaResourceProvider<ServiceRequest> {
    public Class<ServiceRequest> getResourceType() {
        return ServiceRequest.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Date request signed") @OptionalParam(name="authored") DateRangeParam theAuthored, @Description(shortDefinition="What request fulfills") @OptionalParam(name="based-on", targetTypes={}) ReferenceAndListParam theBased_on, @Description(shortDefinition="Where procedure is going to be done") @OptionalParam(name="body-site") TokenAndListParam theBody_site, @Description(shortDefinition="Classification of service") @OptionalParam(name="category") TokenAndListParam theCategory, @Description(shortDefinition="What is being requested/ordered") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="An encounter in which this request is made") @OptionalParam(name="encounter", targetTypes={}) ReferenceAndListParam theEncounter, @Description(shortDefinition="Identifiers assigned to this order") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Instantiates FHIR protocol or definition") @OptionalParam(name="instantiates-canonical", targetTypes={}) ReferenceAndListParam theInstantiates_canonical, @Description(shortDefinition="Instantiates external protocol or definition") @OptionalParam(name="instantiates-uri") UriAndListParam theInstantiates_uri, @Description(shortDefinition="proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option") @OptionalParam(name="intent") TokenAndListParam theIntent, @Description(shortDefinition="When service should occur") @OptionalParam(name="occurrence") DateRangeParam theOccurrence, @Description(shortDefinition="Search by subject - a patient") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="Requested performer") @OptionalParam(name="performer", targetTypes={}) ReferenceAndListParam thePerformer, @Description(shortDefinition="Performer role") @OptionalParam(name="performer-type") TokenAndListParam thePerformer_type, @Description(shortDefinition="routine | urgent | asap | stat") @OptionalParam(name="priority") TokenAndListParam thePriority, @Description(shortDefinition="What request replaces") @OptionalParam(name="replaces", targetTypes={}) ReferenceAndListParam theReplaces, @Description(shortDefinition="Who/what is requesting service") @OptionalParam(name="requester", targetTypes={}) ReferenceAndListParam theRequester, @Description(shortDefinition="Composite Request ID") @OptionalParam(name="requisition") TokenAndListParam theRequisition, @Description(shortDefinition="Specimen to be tested") @OptionalParam(name="specimen", targetTypes={}) ReferenceAndListParam theSpecimen, @Description(shortDefinition="draft | active | on-hold | revoked | completed | entered-in-error | unknown") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="Search by subject") @OptionalParam(name="subject", targetTypes={}) ReferenceAndListParam theSubject, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        ServiceRequestResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("authored", (IQueryParameterAnd)theAuthored);
            paramMap.add("based-on", (IQueryParameterAnd)theBased_on);
            paramMap.add("body-site", (IQueryParameterAnd)theBody_site);
            paramMap.add("category", (IQueryParameterAnd)theCategory);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("encounter", (IQueryParameterAnd)theEncounter);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("instantiates-canonical", (IQueryParameterAnd)theInstantiates_canonical);
            paramMap.add("instantiates-uri", (IQueryParameterAnd)theInstantiates_uri);
            paramMap.add("intent", (IQueryParameterAnd)theIntent);
            paramMap.add("occurrence", (IQueryParameterAnd)theOccurrence);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("performer", (IQueryParameterAnd)thePerformer);
            paramMap.add("performer-type", (IQueryParameterAnd)thePerformer_type);
            paramMap.add("priority", (IQueryParameterAnd)thePriority);
            paramMap.add("replaces", (IQueryParameterAnd)theReplaces);
            paramMap.add("requester", (IQueryParameterAnd)theRequester);
            paramMap.add("requisition", (IQueryParameterAnd)theRequisition);
            paramMap.add("specimen", (IQueryParameterAnd)theSpecimen);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("subject", (IQueryParameterAnd)theSubject);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            ServiceRequestResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

