/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4b;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.NumberAndListParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4b.model.ChargeItem;

public class ChargeItemResourceProvider
extends BaseJpaResourceProvider<ChargeItem> {
    public Class<ChargeItem> getResourceType() {
        return ChargeItem.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") StringAndListParam the_text, @Description(shortDefinition="Account to place this charge") @OptionalParam(name="account", targetTypes={}) ReferenceAndListParam theAccount, @Description(shortDefinition="A code that identifies the charge, like a billing code") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="Encounter / Episode associated with event") @OptionalParam(name="context", targetTypes={}) ReferenceAndListParam theContext, @Description(shortDefinition="Date the charge item was entered") @OptionalParam(name="entered-date") DateRangeParam theEntered_date, @Description(shortDefinition="Individual who was entering") @OptionalParam(name="enterer", targetTypes={}) ReferenceAndListParam theEnterer, @Description(shortDefinition="Factor overriding the associated rules") @OptionalParam(name="factor-override") NumberAndListParam theFactor_override, @Description(shortDefinition="Business Identifier for item") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="When the charged service was applied") @OptionalParam(name="occurrence") DateRangeParam theOccurrence, @Description(shortDefinition="Individual service was done for/to") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="Individual who was performing") @OptionalParam(name="performer-actor", targetTypes={}) ReferenceAndListParam thePerformer_actor, @Description(shortDefinition="What type of performance was done") @OptionalParam(name="performer-function") TokenAndListParam thePerformer_function, @Description(shortDefinition="Organization providing the charged service") @OptionalParam(name="performing-organization", targetTypes={}) ReferenceAndListParam thePerforming_organization, @Description(shortDefinition="Price overriding the associated rules") @OptionalParam(name="price-override") QuantityAndListParam thePrice_override, @Description(shortDefinition="Quantity of which the charge item has been serviced") @OptionalParam(name="quantity") QuantityAndListParam theQuantity, @Description(shortDefinition="Organization requesting the charged service") @OptionalParam(name="requesting-organization", targetTypes={}) ReferenceAndListParam theRequesting_organization, @Description(shortDefinition="Which rendered service is being charged?") @OptionalParam(name="service", targetTypes={}) ReferenceAndListParam theService, @Description(shortDefinition="Individual service was done for/to") @OptionalParam(name="subject", targetTypes={}) ReferenceAndListParam theSubject, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        ChargeItemResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("account", (IQueryParameterAnd)theAccount);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("context", (IQueryParameterAnd)theContext);
            paramMap.add("entered-date", (IQueryParameterAnd)theEntered_date);
            paramMap.add("enterer", (IQueryParameterAnd)theEnterer);
            paramMap.add("factor-override", (IQueryParameterAnd)theFactor_override);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("occurrence", (IQueryParameterAnd)theOccurrence);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("performer-actor", (IQueryParameterAnd)thePerformer_actor);
            paramMap.add("performer-function", (IQueryParameterAnd)thePerformer_function);
            paramMap.add("performing-organization", (IQueryParameterAnd)thePerforming_organization);
            paramMap.add("price-override", (IQueryParameterAnd)thePrice_override);
            paramMap.add("quantity", (IQueryParameterAnd)theQuantity);
            paramMap.add("requesting-organization", (IQueryParameterAnd)theRequesting_organization);
            paramMap.add("service", (IQueryParameterAnd)theService);
            paramMap.add("subject", (IQueryParameterAnd)theSubject);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            ChargeItemResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

