/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4b;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4b.model.Consent;

public class ConsentResourceProvider
extends BaseJpaResourceProvider<Consent> {
    public Class<Consent> getResourceType() {
        return Consent.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") StringAndListParam the_text, @Description(shortDefinition="Actions controlled by this rule") @OptionalParam(name="action") TokenAndListParam theAction, @Description(shortDefinition="Resource for the actor (or group, by role)") @OptionalParam(name="actor", targetTypes={}) ReferenceAndListParam theActor, @Description(shortDefinition="Classification of the consent statement - for indexing/retrieval") @OptionalParam(name="category") TokenAndListParam theCategory, @Description(shortDefinition="Who is agreeing to the policy and rules") @OptionalParam(name="consentor", targetTypes={}) ReferenceAndListParam theConsentor, @Description(shortDefinition="The actual data reference") @OptionalParam(name="data", targetTypes={}) ReferenceAndListParam theData, @Description(shortDefinition="Multiple Resources: * [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded* [CarePlan](careplan.html): Time period plan covers* [CareTeam](careteam.html): Time period team covers* [ClinicalImpression](clinicalimpression.html): When the assessment was documented* [Composition](composition.html): Composition editing time* [Consent](consent.html): When this Consent was created or indexed* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report* [Encounter](encounter.html): A date within the period the Encounter lasted* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated* [Flag](flag.html): Time period when flag is active* [Immunization](immunization.html): Vaccination  (non)-Administration Date* [List](list.html): When the list was prepared* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period* [Procedure](procedure.html): When the procedure was performed* [RiskAssessment](riskassessment.html): When was assessment made?* [SupplyRequest](supplyrequest.html): When the request was made") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="Multiple Resources: * [AllergyIntolerance](allergyintolerance.html): External ids for this item* [CarePlan](careplan.html): External Ids for this plan* [CareTeam](careteam.html): External Ids for this team* [Composition](composition.html): Version-independent identifier for the Composition* [Condition](condition.html): A unique identifier of the condition record* [Consent](consent.html): Identifier for this record (external references)* [DetectedIssue](detectedissue.html): Unique id for the detected issue* [DeviceRequest](devicerequest.html): Business identifier for request/order* [DiagnosticReport](diagnosticreport.html): An identifier for the report* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents* [DocumentReference](documentreference.html): Master Version Specific Identifier* [Encounter](encounter.html): Identifier(s) by which this encounter is known* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier* [Goal](goal.html): External Ids for this goal* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID and Accession number* [Immunization](immunization.html): Business identifier* [List](list.html): Business identifier* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier* [MedicationStatement](medicationstatement.html): Return statements with this external identifier* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier* [Observation](observation.html): The unique id for a particular observation* [Procedure](procedure.html): A unique identifier for a procedure* [RiskAssessment](riskassessment.html): Unique identifier for the assessment* [ServiceRequest](servicerequest.html): Identifiers assigned to this order* [SupplyDelivery](supplydelivery.html): External identifier* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Custodian of the consent") @OptionalParam(name="organization", targetTypes={}) ReferenceAndListParam theOrganization, @Description(shortDefinition="Multiple Resources: * [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for* [CarePlan](careplan.html): Who the care plan is for* [CareTeam](careteam.html): Who care team is for* [ClinicalImpression](clinicalimpression.html): Patient or group assessed* [Composition](composition.html): Who and/or what the composition is about* [Condition](condition.html): Who has the condition?* [Consent](consent.html): Who the consent applies to* [DetectedIssue](detectedissue.html): Associated patient* [DeviceRequest](devicerequest.html): Individual the service is ordered for* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient* [DocumentManifest](documentmanifest.html): The subject of the set of documents* [DocumentReference](documentreference.html): Who/what is the subject of the document* [Encounter](encounter.html): The patient or group present at the encounter* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for* [Flag](flag.html): The identity of a subject to list flags for* [Goal](goal.html): Who this goal is intended for* [ImagingStudy](imagingstudy.html): Who the study is about* [Immunization](immunization.html): The patient for the vaccination record* [List](list.html): If all resources have the same subject* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement* [Observation](observation.html): The subject that the observation is about (if patient)* [Procedure](procedure.html): Search by subject - a patient* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?* [ServiceRequest](servicerequest.html): Search by subject - a patient* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="Timeframe for this rule") @OptionalParam(name="period") DateRangeParam thePeriod, @Description(shortDefinition="Context of activities covered by this rule") @OptionalParam(name="purpose") TokenAndListParam thePurpose, @Description(shortDefinition="Which of the four areas this resource covers (extensible)") @OptionalParam(name="scope") TokenAndListParam theScope, @Description(shortDefinition="Security Labels that define affected resources") @OptionalParam(name="security-label") TokenAndListParam theSecurity_label, @Description(shortDefinition="Search by reference to a Consent, DocumentReference, Contract  or QuestionnaireResponse") @OptionalParam(name="source-reference", targetTypes={}) ReferenceAndListParam theSource_reference, @Description(shortDefinition="draft | proposed | active | rejected | inactive | entered-in-error") @OptionalParam(name="status") TokenAndListParam theStatus, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        ConsentResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("action", (IQueryParameterAnd)theAction);
            paramMap.add("actor", (IQueryParameterAnd)theActor);
            paramMap.add("category", (IQueryParameterAnd)theCategory);
            paramMap.add("consentor", (IQueryParameterAnd)theConsentor);
            paramMap.add("data", (IQueryParameterAnd)theData);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("organization", (IQueryParameterAnd)theOrganization);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("period", (IQueryParameterAnd)thePeriod);
            paramMap.add("purpose", (IQueryParameterAnd)thePurpose);
            paramMap.add("scope", (IQueryParameterAnd)theScope);
            paramMap.add("security-label", (IQueryParameterAnd)theSecurity_label);
            paramMap.add("source-reference", (IQueryParameterAnd)theSource_reference);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            ConsentResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

