/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4b;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.CompositeAndListParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4b.model.OperationDefinition;

public class OperationDefinitionResourceProvider
extends BaseJpaResourceProvider<OperationDefinition> {
    public Class<OperationDefinition> getResourceType() {
        return OperationDefinition.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") StringAndListParam the_text, @Description(shortDefinition="Marks this as a profile of the base") @OptionalParam(name="base", targetTypes={}) ReferenceAndListParam theBase, @Description(shortDefinition="Name used to invoke the operation") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement* [CodeSystem](codesystem.html): A use context assigned to the code system* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition* [ConceptMap](conceptmap.html): A use context assigned to the concept map* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition* [NamingSystem](namingsystem.html): A use context assigned to the naming system* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition* [SearchParameter](searchparameter.html): A use context assigned to the search parameter* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition* [StructureMap](structuremap.html): A use context assigned to the structure map* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities* [ValueSet](valueset.html): A use context assigned to the value set") @OptionalParam(name="context") TokenAndListParam theContext, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set") @OptionalParam(name="context-quantity") QuantityAndListParam theContext_quantity, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement* [CodeSystem](codesystem.html): A type of use context assigned to the code system* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition* [StructureMap](structuremap.html): A type of use context assigned to the structure map* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities* [ValueSet](valueset.html): A type of use context assigned to the value set") @OptionalParam(name="context-type") TokenAndListParam theContext_type, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set") @OptionalParam(name="context-type-quantity", compositeTypes={TokenParam.class, QuantityParam.class}) CompositeAndListParam<TokenParam, QuantityParam> theContext_type_quantity, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement* [CodeSystem](codesystem.html): A use context type and value assigned to the code system* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition* [StructureMap](structuremap.html): A use context type and value assigned to the structure map* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities* [ValueSet](valueset.html): A use context type and value assigned to the value set") @OptionalParam(name="context-type-value", compositeTypes={TokenParam.class, TokenParam.class}) CompositeAndListParam<TokenParam, TokenParam> theContext_type_value, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): The capability statement publication date* [CodeSystem](codesystem.html): The code system publication date* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date* [ConceptMap](conceptmap.html): The concept map publication date* [GraphDefinition](graphdefinition.html): The graph definition publication date* [ImplementationGuide](implementationguide.html): The implementation guide publication date* [MessageDefinition](messagedefinition.html): The message definition publication date* [NamingSystem](namingsystem.html): The naming system publication date* [OperationDefinition](operationdefinition.html): The operation definition publication date* [SearchParameter](searchparameter.html): The search parameter publication date* [StructureDefinition](structuredefinition.html): The structure definition publication date* [StructureMap](structuremap.html): The structure map publication date* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date* [ValueSet](valueset.html): The value set publication date") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): The description of the capability statement* [CodeSystem](codesystem.html): The description of the code system* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition* [ConceptMap](conceptmap.html): The description of the concept map* [GraphDefinition](graphdefinition.html): The description of the graph definition* [ImplementationGuide](implementationguide.html): The description of the implementation guide* [MessageDefinition](messagedefinition.html): The description of the message definition* [NamingSystem](namingsystem.html): The description of the naming system* [OperationDefinition](operationdefinition.html): The description of the operation definition* [SearchParameter](searchparameter.html): The description of the search parameter* [StructureDefinition](structuredefinition.html): The description of the structure definition* [StructureMap](structuremap.html): The description of the structure map* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities* [ValueSet](valueset.html): The description of the value set") @OptionalParam(name="description") StringAndListParam theDescription, @Description(shortDefinition="Validation information for in parameters") @OptionalParam(name="input-profile", targetTypes={}) ReferenceAndListParam theInput_profile, @Description(shortDefinition="Invoke on an instance?") @OptionalParam(name="instance") TokenAndListParam theInstance, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement* [CodeSystem](codesystem.html): Intended jurisdiction for the code system* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition* [StructureMap](structuremap.html): Intended jurisdiction for the structure map* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities* [ValueSet](valueset.html): Intended jurisdiction for the value set") @OptionalParam(name="jurisdiction") TokenAndListParam theJurisdiction, @Description(shortDefinition="operation | query") @OptionalParam(name="kind") TokenAndListParam theKind, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement* [CodeSystem](codesystem.html): Computationally friendly name of the code system* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition* [StructureMap](structuremap.html): Computationally friendly name of the structure map* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities* [ValueSet](valueset.html): Computationally friendly name of the value set") @OptionalParam(name="name") StringAndListParam theName, @Description(shortDefinition="Validation information for out parameters") @OptionalParam(name="output-profile", targetTypes={}) ReferenceAndListParam theOutput_profile, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement* [CodeSystem](codesystem.html): Name of the publisher of the code system* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition* [ConceptMap](conceptmap.html): Name of the publisher of the concept map* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition* [NamingSystem](namingsystem.html): Name of the publisher of the naming system* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition* [StructureMap](structuremap.html): Name of the publisher of the structure map* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities* [ValueSet](valueset.html): Name of the publisher of the value set") @OptionalParam(name="publisher") StringAndListParam thePublisher, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): The current status of the capability statement* [CodeSystem](codesystem.html): The current status of the code system* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition* [ConceptMap](conceptmap.html): The current status of the concept map* [GraphDefinition](graphdefinition.html): The current status of the graph definition* [ImplementationGuide](implementationguide.html): The current status of the implementation guide* [MessageDefinition](messagedefinition.html): The current status of the message definition* [NamingSystem](namingsystem.html): The current status of the naming system* [OperationDefinition](operationdefinition.html): The current status of the operation definition* [SearchParameter](searchparameter.html): The current status of the search parameter* [StructureDefinition](structuredefinition.html): The current status of the structure definition* [StructureMap](structuremap.html): The current status of the structure map* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities* [ValueSet](valueset.html): The current status of the value set") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="Invoke at the system level?") @OptionalParam(name="system") TokenAndListParam theSystem, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement* [CodeSystem](codesystem.html): The human-friendly name of the code system* [ConceptMap](conceptmap.html): The human-friendly name of the concept map* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition* [StructureMap](structuremap.html): The human-friendly name of the structure map* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities* [ValueSet](valueset.html): The human-friendly name of the value set") @OptionalParam(name="title") StringAndListParam theTitle, @Description(shortDefinition="Invoke at the type level?") @OptionalParam(name="type") TokenAndListParam theType, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement* [CodeSystem](codesystem.html): The uri that identifies the code system* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition* [ConceptMap](conceptmap.html): The uri that identifies the concept map* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition* [SearchParameter](searchparameter.html): The uri that identifies the search parameter* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition* [StructureMap](structuremap.html): The uri that identifies the structure map* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities* [ValueSet](valueset.html): The uri that identifies the value set") @OptionalParam(name="url") UriAndListParam theUrl, @Description(shortDefinition="Multiple Resources: * [CapabilityStatement](capabilitystatement.html): The business version of the capability statement* [CodeSystem](codesystem.html): The business version of the code system* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition* [ConceptMap](conceptmap.html): The business version of the concept map* [GraphDefinition](graphdefinition.html): The business version of the graph definition* [ImplementationGuide](implementationguide.html): The business version of the implementation guide* [MessageDefinition](messagedefinition.html): The business version of the message definition* [OperationDefinition](operationdefinition.html): The business version of the operation definition* [SearchParameter](searchparameter.html): The business version of the search parameter* [StructureDefinition](structuredefinition.html): The business version of the structure definition* [StructureMap](structuremap.html): The business version of the structure map* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities* [ValueSet](valueset.html): The business version of the value set") @OptionalParam(name="version") TokenAndListParam theVersion, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        OperationDefinitionResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("base", (IQueryParameterAnd)theBase);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("context", (IQueryParameterAnd)theContext);
            paramMap.add("context-quantity", (IQueryParameterAnd)theContext_quantity);
            paramMap.add("context-type", (IQueryParameterAnd)theContext_type);
            paramMap.add("context-type-quantity", theContext_type_quantity);
            paramMap.add("context-type-value", theContext_type_value);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("description", (IQueryParameterAnd)theDescription);
            paramMap.add("input-profile", (IQueryParameterAnd)theInput_profile);
            paramMap.add("instance", (IQueryParameterAnd)theInstance);
            paramMap.add("jurisdiction", (IQueryParameterAnd)theJurisdiction);
            paramMap.add("kind", (IQueryParameterAnd)theKind);
            paramMap.add("name", (IQueryParameterAnd)theName);
            paramMap.add("output-profile", (IQueryParameterAnd)theOutput_profile);
            paramMap.add("publisher", (IQueryParameterAnd)thePublisher);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("system", (IQueryParameterAnd)theSystem);
            paramMap.add("title", (IQueryParameterAnd)theTitle);
            paramMap.add("type", (IQueryParameterAnd)theType);
            paramMap.add("url", (IQueryParameterAnd)theUrl);
            paramMap.add("version", (IQueryParameterAnd)theVersion);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            OperationDefinitionResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

