/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4b;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProviderPatient;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.NumberAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4b.model.Patient;

public class PatientResourceProvider
extends BaseJpaResourceProviderPatient<Patient> {
    public Class<Patient> getResourceType() {
        return Patient.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") StringAndListParam the_text, @Description(shortDefinition="Whether the patient record is active") @OptionalParam(name="active") TokenAndListParam theActive, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text* [Person](person.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text* [Practitioner](practitioner.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text* [RelatedPerson](relatedperson.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text") @OptionalParam(name="address") StringAndListParam theAddress, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A city specified in an address* [Person](person.html): A city specified in an address* [Practitioner](practitioner.html): A city specified in an address* [RelatedPerson](relatedperson.html): A city specified in an address") @OptionalParam(name="address-city") StringAndListParam theAddress_city, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A country specified in an address* [Person](person.html): A country specified in an address* [Practitioner](practitioner.html): A country specified in an address* [RelatedPerson](relatedperson.html): A country specified in an address") @OptionalParam(name="address-country") StringAndListParam theAddress_country, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A postalCode specified in an address* [Person](person.html): A postal code specified in an address* [Practitioner](practitioner.html): A postalCode specified in an address* [RelatedPerson](relatedperson.html): A postal code specified in an address") @OptionalParam(name="address-postalcode") StringAndListParam theAddress_postalcode, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A state specified in an address* [Person](person.html): A state specified in an address* [Practitioner](practitioner.html): A state specified in an address* [RelatedPerson](relatedperson.html): A state specified in an address") @OptionalParam(name="address-state") StringAndListParam theAddress_state, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A use code specified in an address* [Person](person.html): A use code specified in an address* [Practitioner](practitioner.html): A use code specified in an address* [RelatedPerson](relatedperson.html): A use code specified in an address") @OptionalParam(name="address-use") TokenAndListParam theAddress_use, @Description(shortDefinition="Searches for patients based on age as calculated based on current date and date of birth.  Deceased patients are excluded from the search.") @OptionalParam(name="age") NumberAndListParam theAge, @Description(shortDefinition="Search based on whether a patient was part of a multiple birth or not.") @OptionalParam(name="birthOrderBoolean") TokenAndListParam theBirthOrderBoolean, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): The patient's date of birth* [Person](person.html): The person's date of birth* [RelatedPerson](relatedperson.html): The Related Person's date of birth") @OptionalParam(name="birthdate") DateRangeParam theBirthdate, @Description(shortDefinition="The date of death has been provided and satisfies this search value") @OptionalParam(name="death-date") DateRangeParam theDeath_date, @Description(shortDefinition="This patient has been marked as deceased, or as a death date entered") @OptionalParam(name="deceased") TokenAndListParam theDeceased, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A value in an email contact* [Person](person.html): A value in an email contact* [Practitioner](practitioner.html): A value in an email contact* [PractitionerRole](practitionerrole.html): A value in an email contact* [RelatedPerson](relatedperson.html): A value in an email contact") @OptionalParam(name="email") TokenAndListParam theEmail, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A portion of the family name of the patient* [Practitioner](practitioner.html): A portion of the family name") @OptionalParam(name="family") StringAndListParam theFamily, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): Gender of the patient* [Person](person.html): The gender of the person* [Practitioner](practitioner.html): Gender of the practitioner* [RelatedPerson](relatedperson.html): Gender of the related person") @OptionalParam(name="gender") TokenAndListParam theGender, @Description(shortDefinition="Patient's nominated general practitioner, not the organization that manages the record") @OptionalParam(name="general-practitioner", targetTypes={}) ReferenceAndListParam theGeneral_practitioner, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A portion of the given name of the patient* [Practitioner](practitioner.html): A portion of the given name") @OptionalParam(name="given") StringAndListParam theGiven, @Description(shortDefinition="A patient identifier") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Language code (irrespective of use value)") @OptionalParam(name="language") TokenAndListParam theLanguage, @Description(shortDefinition="All patients linked to the given patient") @OptionalParam(name="link", targetTypes={}) ReferenceAndListParam theLink, @Description(shortDefinition="Search based on patient's mother's maiden name") @OptionalParam(name="mothersMaidenName") StringAndListParam theMothersMaidenName, @Description(shortDefinition="A server defined search that may match any of the string fields in the HumanName, including family, give, prefix, suffix, suffix, and/or text") @OptionalParam(name="name") StringAndListParam theName, @Description(shortDefinition="The organization that is the custodian of the patient record") @OptionalParam(name="organization", targetTypes={}) ReferenceAndListParam theOrganization, @Description(shortDefinition="Search by url for a participation agreement, which is stored in a DocumentReference") @OptionalParam(name="part-agree", targetTypes={}) ReferenceAndListParam thePart_agree, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A value in a phone contact* [Person](person.html): A value in a phone contact* [Practitioner](practitioner.html): A value in a phone contact* [PractitionerRole](practitionerrole.html): A value in a phone contact* [RelatedPerson](relatedperson.html): A value in a phone contact") @OptionalParam(name="phone") TokenAndListParam thePhone, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A portion of either family or given name using some kind of phonetic matching algorithm* [Person](person.html): A portion of name using some kind of phonetic matching algorithm* [Practitioner](practitioner.html): A portion of either family or given name using some kind of phonetic matching algorithm* [RelatedPerson](relatedperson.html): A portion of name using some kind of phonetic matching algorithm") @OptionalParam(name="phonetic") StringAndListParam thePhonetic, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): The value in any kind of telecom details of the patient* [Person](person.html): The value in any kind of contact* [Practitioner](practitioner.html): The value in any kind of contact* [PractitionerRole](practitionerrole.html): The value in any kind of contact* [RelatedPerson](relatedperson.html): The value in any kind of contact") @OptionalParam(name="telecom") TokenAndListParam theTelecom, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        PatientResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("active", (IQueryParameterAnd)theActive);
            paramMap.add("address", (IQueryParameterAnd)theAddress);
            paramMap.add("address-city", (IQueryParameterAnd)theAddress_city);
            paramMap.add("address-country", (IQueryParameterAnd)theAddress_country);
            paramMap.add("address-postalcode", (IQueryParameterAnd)theAddress_postalcode);
            paramMap.add("address-state", (IQueryParameterAnd)theAddress_state);
            paramMap.add("address-use", (IQueryParameterAnd)theAddress_use);
            paramMap.add("age", (IQueryParameterAnd)theAge);
            paramMap.add("birthOrderBoolean", (IQueryParameterAnd)theBirthOrderBoolean);
            paramMap.add("birthdate", (IQueryParameterAnd)theBirthdate);
            paramMap.add("death-date", (IQueryParameterAnd)theDeath_date);
            paramMap.add("deceased", (IQueryParameterAnd)theDeceased);
            paramMap.add("email", (IQueryParameterAnd)theEmail);
            paramMap.add("family", (IQueryParameterAnd)theFamily);
            paramMap.add("gender", (IQueryParameterAnd)theGender);
            paramMap.add("general-practitioner", (IQueryParameterAnd)theGeneral_practitioner);
            paramMap.add("given", (IQueryParameterAnd)theGiven);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("language", (IQueryParameterAnd)theLanguage);
            paramMap.add("link", (IQueryParameterAnd)theLink);
            paramMap.add("mothersMaidenName", (IQueryParameterAnd)theMothersMaidenName);
            paramMap.add("name", (IQueryParameterAnd)theName);
            paramMap.add("organization", (IQueryParameterAnd)theOrganization);
            paramMap.add("part-agree", (IQueryParameterAnd)thePart_agree);
            paramMap.add("phone", (IQueryParameterAnd)thePhone);
            paramMap.add("phonetic", (IQueryParameterAnd)thePhonetic);
            paramMap.add("telecom", (IQueryParameterAnd)theTelecom);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            PatientResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

