/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.CompositeAndListParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r5.model.Device;

public class DeviceResourceProvider
extends BaseJpaResourceProvider<Device> {
    public Class<Device> getResourceType() {
        return Device.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="The biological source for the device") @OptionalParam(name="biological-source-event") TokenAndListParam theBiological_source_event, @Description(shortDefinition="The definition / type of the device (code)") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="Code and value parameter pair") @OptionalParam(name="code-value-concept", compositeTypes={TokenParam.class, StringParam.class}) CompositeAndListParam<TokenParam, StringParam> theCode_value_concept, @Description(shortDefinition="The definition / type of the device") @OptionalParam(name="definition", targetTypes={}) ReferenceAndListParam theDefinition, @Description(shortDefinition="A server defined search that may match any of the string fields in Device.name or Device.type.") @OptionalParam(name="device-name") StringAndListParam theDevice_name, @Description(shortDefinition="The expiration date of the device") @OptionalParam(name="expiration-date") DateRangeParam theExpiration_date, @Description(shortDefinition="Instance id from manufacturer, owner, and others") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="A location, where the resource is found") @OptionalParam(name="location", targetTypes={}) ReferenceAndListParam theLocation, @Description(shortDefinition="The lot number of the device") @OptionalParam(name="lot-number") StringAndListParam theLot_number, @Description(shortDefinition="The manufacture date of the device") @OptionalParam(name="manufacture-date") DateRangeParam theManufacture_date, @Description(shortDefinition="The manufacturer of the device") @OptionalParam(name="manufacturer") StringAndListParam theManufacturer, @Description(shortDefinition="The model of the device") @OptionalParam(name="model") StringAndListParam theModel, @Description(shortDefinition="The organization responsible for the device") @OptionalParam(name="organization", targetTypes={}) ReferenceAndListParam theOrganization, @Description(shortDefinition="The parent device") @OptionalParam(name="parent", targetTypes={}) ReferenceAndListParam theParent, @Description(shortDefinition="The serial number of the device") @OptionalParam(name="serial-number") StringAndListParam theSerial_number, @Description(shortDefinition="The standards, specifications, or formal guidances.") @OptionalParam(name="specification") TokenAndListParam theSpecification, @Description(shortDefinition="A composite of both specification and version") @OptionalParam(name="specification-version", compositeTypes={TokenParam.class, StringParam.class}) CompositeAndListParam<TokenParam, StringParam> theSpecification_version, @Description(shortDefinition="active | inactive | entered-in-error | unknown") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="The type of the device") @OptionalParam(name="type") TokenAndListParam theType, @Description(shortDefinition="UDI Barcode (RFID or other technology) string in *HRF* format.") @OptionalParam(name="udi-carrier") StringAndListParam theUdi_carrier, @Description(shortDefinition="The udi Device Identifier (DI)") @OptionalParam(name="udi-di") StringAndListParam theUdi_di, @Description(shortDefinition="Network address to contact device") @OptionalParam(name="url") UriAndListParam theUrl, @Description(shortDefinition="The specific version of the device") @OptionalParam(name="version") StringAndListParam theVersion, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        DeviceResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("biological-source-event", (IQueryParameterAnd)theBiological_source_event);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("code-value-concept", theCode_value_concept);
            paramMap.add("definition", (IQueryParameterAnd)theDefinition);
            paramMap.add("device-name", (IQueryParameterAnd)theDevice_name);
            paramMap.add("expiration-date", (IQueryParameterAnd)theExpiration_date);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("location", (IQueryParameterAnd)theLocation);
            paramMap.add("lot-number", (IQueryParameterAnd)theLot_number);
            paramMap.add("manufacture-date", (IQueryParameterAnd)theManufacture_date);
            paramMap.add("manufacturer", (IQueryParameterAnd)theManufacturer);
            paramMap.add("model", (IQueryParameterAnd)theModel);
            paramMap.add("organization", (IQueryParameterAnd)theOrganization);
            paramMap.add("parent", (IQueryParameterAnd)theParent);
            paramMap.add("serial-number", (IQueryParameterAnd)theSerial_number);
            paramMap.add("specification", (IQueryParameterAnd)theSpecification);
            paramMap.add("specification-version", theSpecification_version);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("type", (IQueryParameterAnd)theType);
            paramMap.add("udi-carrier", (IQueryParameterAnd)theUdi_carrier);
            paramMap.add("udi-di", (IQueryParameterAnd)theUdi_di);
            paramMap.add("url", (IQueryParameterAnd)theUrl);
            paramMap.add("version", (IQueryParameterAnd)theVersion);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            DeviceResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

